/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.LinkedList;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyConsumer;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.Subscription;
import org.jboss.util.UnreachableStatementException;

public class SpyMessageConsumer
implements MessageConsumer,
SpyConsumer,
Runnable {
    static Logger log = Logger.getLogger((Class)SpyMessageConsumer.class);
    static boolean trace = log.isTraceEnabled();
    static final Integer ONCE = new Integer(1);
    public SpySession session;
    public Subscription subscription = new Subscription();
    private SynchronizedBoolean closed = new SynchronizedBoolean(false);
    protected Object stateLock = new Object();
    protected boolean receiving = false;
    protected boolean waitingForMessage = false;
    protected boolean listening = false;
    protected Thread listenerThread = null;
    MessageListener messageListener;
    LinkedList messages;
    boolean sessionConsumer;

    SpyMessageConsumer(SpySession s, boolean sessionConsumer) {
        trace = log.isTraceEnabled();
        this.session = s;
        this.sessionConsumer = sessionConsumer;
        this.messageListener = null;
        this.messages = new LinkedList();
        if (trace) {
            log.trace((Object)("New message consumer " + this));
        }
    }

    SpyMessageConsumer(SpySession s, boolean sessionConsumer, SpyDestination destination, String selector, boolean noLocal) throws InvalidSelectorException {
        trace = log.isTraceEnabled();
        this.session = s;
        this.sessionConsumer = sessionConsumer;
        this.subscription.destination = destination;
        this.subscription.messageSelector = selector;
        this.subscription.noLocal = noLocal;
        if (this.subscription.messageSelector != null) {
            this.subscription.getSelector();
        }
        this.messageListener = null;
        this.messages = new LinkedList();
        if (trace) {
            log.trace((Object)("New message consumer " + this));
        }
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(SpyMessage message) throws JMSException {
        if (this.isClosed()) {
            if (trace) {
                log.trace((Object)("WARNING: NACK issued. message=" + message.header.jmsMessageID + " The message consumer was closed. " + this));
            }
            this.session.connection.send(message.getAcknowledgementRequest(false));
            return;
        }
        if (this.subscription.accepts(message.header)) {
            if (this.sessionConsumer) {
                this.sessionConsumerProcessMessage(message);
            } else {
                LinkedList linkedList = this.messages;
                synchronized (linkedList) {
                    if (this.waitingForMessage) {
                        if (trace) {
                            log.trace((Object)("Adding message=" + message.header.jmsMessageID + " " + this));
                        }
                        this.messages.addLast(message);
                        this.messages.notifyAll();
                    } else {
                        if (trace) {
                            log.trace((Object)("WARNING: NACK issued. message=" + message.header.jmsMessageID + " The message consumer was not waiting for a message. " + this));
                        }
                        this.session.connection.send(message.getAcknowledgementRequest(false));
                    }
                }
            }
        } else {
            if (trace) {
                log.trace((Object)("WARNING: NACK issued. message=" + message.header.jmsMessageID + " The subscription did not accept the message. " + this));
            }
            this.session.connection.send(message.getAcknowledgementRequest(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartProcessing() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (trace) {
                log.trace((Object)("Restarting processing " + this));
            }
            this.messages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (trace) {
                log.trace((Object)("Set message listener=" + listener + " old listener=" + this.messageListener + " " + this));
            }
            boolean oldListening = this.listening;
            this.listening = listener != null;
            this.messageListener = listener;
            if (!this.sessionConsumer && this.listening && !oldListening && this.listenerThread == null) {
                this.listenerThread = new Thread((Runnable)this, "MessageListenerThread - " + this.subscription.destination.getName());
                this.listenerThread.start();
            }
        }
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.subscription.messageSelector;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive() throws JMSException {
        this.checkClosed();
        var1_1 = this.stateLock;
        synchronized (var1_1) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (this.listening) {
                throw new JMSException("A message listener is already registered");
            }
            this.receiving = true;
            if (SpyMessageConsumer.trace) {
                SpyMessageConsumer.log.trace((Object)("receive() " + this));
            }
        }
        try {
            var1_1 = this.messages;
            synchronized (var1_1) {
                message = this.getMessage();
                if (message == null) ** break block38
                if (SpyMessageConsumer.trace) {
                    SpyMessageConsumer.log.trace((Object)("receive() message in list " + message.getJMSMessageID() + " " + this));
                }
                var3_3 = message;
            }
            var4_6 = this.stateLock;
        }
        catch (Throwable var12_12) {
            var13_13 = this.stateLock;
            synchronized (var13_13) {
                this.receiving = false;
                throw var12_12;
            }
        }
        synchronized (var4_6) {
            this.receiving = false;
            return var3_3;
        }
        {
            while ((msg = this.session.connection.receive(this.subscription, 0L)) != null) {
                mes = this.preProcessMessage(msg);
                if (mes == null) continue;
                if (SpyMessageConsumer.trace) {
                    SpyMessageConsumer.log.trace((Object)("receive() message from server " + mes.getJMSMessageID() + " " + this));
                }
                var5_8 = mes;
                // MONITOREXIT @DISABLED, blocks:[18, 27] lbl39 : MonitorExitStatement: MONITOREXIT : var1_1
                var6_10 = this.stateLock;
                synchronized (var6_10) {
                    this.receiving = false;
                    return var5_8;
                }
            }
            if (SpyMessageConsumer.trace) {
                SpyMessageConsumer.log.trace((Object)("No message in receive(), waiting " + this));
            }
            this.waitingForMessage = true;
lbl45:
            // 2 sources

            while (true) {
                if (this.isClosed()) {
                    if (SpyMessageConsumer.trace) {
                        SpyMessageConsumer.log.trace((Object)("Consumer closed in receive() " + this));
                    }
                    msg = null;
                    this.waitingForMessage = false;
                }
                ** GOTO lbl-1000
                break;
            }
            {
                catch (Throwable t) {
                    SpyJMSException.rethrowAsJMSException("Receive interupted", t);
                    throw new UnreachableStatementException();
                }
                catch (Throwable var10_11) {
                    this.waitingForMessage = false;
                    throw var10_11;
                }
                // MONITOREXIT @DISABLED, blocks:[18, 12] lbl63 : MonitorExitStatement: MONITOREXIT : var1_1
                var4_7 /* !! */  = this.stateLock;
                synchronized (var4_7 /* !! */ ) {
                    this.receiving = false;
                    return msg;
                }
lbl-1000:
                // 1 sources

                {
                    mes = this.getMessage();
                    if (mes == null) ** GOTO lbl-1000
                    if (SpyMessageConsumer.trace) {
                        SpyMessageConsumer.log.trace((Object)("receive() message from list after wait " + this));
                    }
                    var4_7 /* !! */  = mes;
                    this.waitingForMessage = false;
                }
                // MONITOREXIT @DISABLED, blocks:[18, 12] lbl75 : MonitorExitStatement: MONITOREXIT : var1_1
                var5_9 = this.stateLock;
                synchronized (var5_9) {
                    this.receiving = false;
                    return var4_7 /* !! */ ;
                }
lbl-1000:
                // 1 sources

                {
                    this.messages.wait();
                    ** continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive(long timeOut) throws JMSException {
        if (timeOut == 0L) {
            if (SpyMessageConsumer.trace == false) return this.receive();
            SpyMessageConsumer.log.trace((Object)("Timeout is zero in receive(long) using receive() " + this));
            return this.receive();
        }
        this.checkClosed();
        var3_2 = this.stateLock;
        synchronized (var3_2) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (this.listening) {
                throw new JMSException("A message listener is already registered");
            }
            this.receiving = true;
            if (SpyMessageConsumer.trace) {
                SpyMessageConsumer.log.trace((Object)("receive(long) " + this));
            }
        }
        endTime = System.currentTimeMillis() + timeOut;
        if (SpyMessageConsumer.trace) {
            SpyMessageConsumer.log.trace((Object)("receive(long) endTime=" + endTime + " " + this));
        }
        try {
            var5_4 = this.messages;
            synchronized (var5_4) {
                message = this.getMessage();
                if (message == null) ** break block45
                if (SpyMessageConsumer.trace) {
                    SpyMessageConsumer.log.trace((Object)("receive(long) message in list " + message.getJMSMessageID() + " " + this));
                }
                var7_6 = message;
            }
            var8_9 = this.stateLock;
        }
        catch (Throwable var17_20) {
            var18_21 = this.stateLock;
            synchronized (var18_21) {
                this.receiving = false;
                throw var17_20;
            }
        }
        synchronized (var8_9) {
            this.receiving = false;
            return var7_6;
        }
        {
            while ((msg = this.session.connection.receive(this.subscription, timeOut)) != null) {
                mes = this.preProcessMessage(msg);
                if (mes == null) continue;
                if (SpyMessageConsumer.trace) {
                    SpyMessageConsumer.log.trace((Object)("receive(long) message from server " + mes.getJMSMessageID() + " " + this));
                }
                var9_14 = mes;
                // MONITOREXIT @DISABLED, blocks:[21, 31] lbl46 : MonitorExitStatement: MONITOREXIT : var5_4
                var10_16 = this.stateLock;
                synchronized (var10_16) {
                    this.receiving = false;
                    return var9_14;
                }
            }
            if (SpyMessageConsumer.trace) {
                SpyMessageConsumer.log.trace((Object)("No message in receive(), waiting " + this));
            }
            this.waitingForMessage = true;
lbl52:
            // 2 sources

            while (true) {
                if (this.isClosed()) {
                    if (SpyMessageConsumer.trace) {
                        SpyMessageConsumer.log.trace((Object)("Consumer closed in receive(long) " + this));
                    }
                    msg = null;
                    this.waitingForMessage = false;
                }
                ** GOTO lbl-1000
                break;
            }
            {
                catch (Throwable t) {
                    SpyJMSException.rethrowAsJMSException("Receive interupted", t);
                    throw new UnreachableStatementException();
                }
                catch (Throwable var15_19) {
                    this.waitingForMessage = false;
                    throw var15_19;
                }
                // MONITOREXIT @DISABLED, blocks:[21, 15] lbl70 : MonitorExitStatement: MONITOREXIT : var5_4
                mes = this.stateLock;
                synchronized (mes) {
                    this.receiving = false;
                    return msg;
                }
lbl-1000:
                // 1 sources

                {
                    mes = this.getMessage();
                    if (mes == null) ** GOTO lbl-1000
                    if (SpyMessageConsumer.trace) {
                        SpyMessageConsumer.log.trace((Object)("receive(long) message from list after wait " + this));
                    }
                    mes = mes;
                    this.waitingForMessage = false;
                }
                // MONITOREXIT @DISABLED, blocks:[21, 15] lbl82 : MonitorExitStatement: MONITOREXIT : var5_4
                var9_15 = this.stateLock;
                synchronized (var9_15) {
                    this.receiving = false;
                    return mes;
                }
lbl-1000:
                // 1 sources

                {
                    att = endTime - System.currentTimeMillis();
                    if (att > 0L) ** GOTO lbl-1000
                    if (SpyMessageConsumer.trace) {
                        SpyMessageConsumer.log.trace((Object)("receive(long) timed out endTime=" + endTime + " " + this));
                    }
                    var10_17 = null;
                    this.waitingForMessage = false;
                }
                // MONITOREXIT @DISABLED, blocks:[21, 15] lbl94 : MonitorExitStatement: MONITOREXIT : var5_4
                var11_18 = this.stateLock;
                synchronized (var11_18) {
                    this.receiving = false;
                    return var10_17;
                }
lbl-1000:
                // 1 sources

                {
                    this.messages.wait(att);
                    ** continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Message receiveNoWait() throws JMSException {
        this.checkClosed();
        var1_1 = this.stateLock;
        synchronized (var1_1) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (this.listening) {
                throw new JMSException("A message listener is already registered");
            }
            this.receiving = true;
            if (SpyMessageConsumer.trace) {
                SpyMessageConsumer.log.trace((Object)("receiveNoWait() " + this));
            }
        }
        try {
            var1_1 = this.messages;
            synchronized (var1_1) {
                block35: {
                    mes = this.getMessage();
                    if (mes == null) break block35;
                    if (SpyMessageConsumer.trace) {
                        SpyMessageConsumer.log.trace((Object)("receiveNoWait() message in list " + mes.getJMSMessageID() + " " + this));
                    }
                    var3_4 = mes;
                    return var3_4;
                }
                ** try [egrp 5[TRYBLOCK] [5 : 185->190)] { 
                {
                }
            }
lbl30:
            // 1 sources

            while (true) {
                if ((msg = this.session.connection.receive(this.subscription, -1L)) != null) {
                    mes = this.preProcessMessage(msg);
                    if (mes != null) {
                        if (SpyMessageConsumer.trace) {
                            SpyMessageConsumer.log.trace((Object)("receiveNoWait() message from server " + mes.getJMSMessageID() + " " + this));
                        }
                        var3_5 = mes;
                        return var3_5;
                    }
                } else {
                    if (SpyMessageConsumer.trace) {
                        SpyMessageConsumer.log.trace((Object)("receiveNoWait() no message " + this));
                    }
                    var2_3 = null;
                    return var2_3;
                }
            }
        }
        finally {
            var4_7 = this.stateLock;
            synchronized (var4_7) {
                this.receiving = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (this.closed.set(true)) {
                return;
            }
            if (trace) {
                log.trace((Object)("Message consumer closing. " + this));
            }
            this.messages.notifyAll();
        }
        this.session.interruptDeliveryLockWaiters();
        if (this.listenerThread != null && !Thread.currentThread().equals(this.listenerThread)) {
            try {
                if (trace) {
                    log.trace((Object)("Joining listener thread. " + this));
                }
                this.listenerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.sessionConsumer) {
            this.session.removeConsumer(this);
        }
        if (trace) {
            log.trace((Object)("Closed. " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SpyMessage mes = null;
        try {
            while (true) {
                MessageListener thisListener;
                if (mes == null) {
                    LinkedList linkedList = this.messages;
                    synchronized (linkedList) {
                        if (this.isClosed()) {
                            this.waitingForMessage = false;
                            if (trace) {
                                log.trace((Object)("Consumer closed in run() " + this));
                            }
                            break;
                        }
                        if (this.messages.isEmpty()) {
                            mes = this.session.connection.receive(this.subscription, 0L);
                        }
                        if (mes == null) {
                            this.waitingForMessage = true;
                            if (trace) {
                                log.trace((Object)("waiting in run() " + this));
                            }
                            while (this.messages.isEmpty() && !this.isClosed() || !this.session.running) {
                                try {
                                    this.messages.wait();
                                }
                                catch (InterruptedException e) {
                                    log.trace((Object)"Ignored interruption waiting for messages");
                                }
                            }
                            if (this.isClosed()) {
                                this.waitingForMessage = false;
                                if (trace) {
                                    log.trace((Object)("Consumer closed while waiting in run() " + this));
                                }
                                break;
                            }
                            mes = (SpyMessage)this.messages.removeFirst();
                            this.waitingForMessage = false;
                        } else if (trace) {
                            log.trace((Object)("run() message from server mes=" + mes.getJMSMessageID() + " " + this));
                        }
                    }
                    mes.session = this.session;
                    continue;
                }
                Object e = this.stateLock;
                synchronized (e) {
                    if (!this.isListening()) {
                        if (mes != null) {
                            if (trace) {
                                log.trace((Object)("run() nacking not listening message mes=" + mes.getJMSMessageID() + " " + this));
                            }
                            this.session.connection.send(mes.getAcknowledgementRequest(false));
                        }
                        this.listenerThread = null;
                        mes = null;
                        break;
                    }
                    thisListener = this.messageListener;
                }
                SpyMessage message = mes;
                if (mes instanceof SpyEncapsulatedMessage) {
                    message = ((SpyEncapsulatedMessage)mes).getMessage();
                }
                boolean gotDeliveryLock = false;
                while (!gotDeliveryLock) {
                    gotDeliveryLock = this.session.tryDeliveryLock();
                    if (gotDeliveryLock) continue;
                    LinkedList linkedList = this.messages;
                    synchronized (linkedList) {
                        if (this.isClosed()) {
                            break;
                        }
                    }
                }
                if (!gotDeliveryLock) {
                    if (trace) {
                        log.trace((Object)("run() nacking didn't get delivery lock mes=" + mes.getJMSMessageID() + " " + this));
                    }
                    this.session.connection.send(mes.getAcknowledgementRequest(false));
                    continue;
                }
                try {
                    if (this.session.transacted) {
                        if (trace) {
                            log.trace((Object)("run() acknowledging message in tx mes=" + mes.getJMSMessageID() + " " + this));
                        }
                        this.session.connection.spyXAResourceManager.ackMessage(this.session.getCurrentTransactionId(), mes);
                    }
                    try {
                        this.prepareDelivery(message);
                        this.session.addUnacknowlegedMessage(message);
                        thisListener.onMessage((Message)message);
                    }
                    catch (Throwable t) {
                        log.warn((Object)("Message listener " + thisListener + " threw a throwable."), t);
                    }
                }
                finally {
                    this.session.releaseDeliveryLock();
                }
                if (!(this.session.transacted || this.session.acknowledgeMode != 1 && this.session.acknowledgeMode != 3)) {
                    boolean recovered;
                    LinkedList linkedList = this.messages;
                    synchronized (linkedList) {
                        recovered = this.messages.contains(message);
                    }
                    if (!recovered) {
                        mes.doAcknowledge();
                    }
                }
                mes = null;
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Message consumer closing due to error in listening thread.", t);
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.session.asynchFailure("Message consumer closing due to error in listening thread.", t);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SpyMessageConsumer@").append(System.identityHashCode(this));
        buffer.append("[sub=").append(this.subscription);
        if (this.isClosed()) {
            buffer.append(" CLOSED");
        }
        buffer.append(" listening=").append(this.listening);
        buffer.append(" receiving=").append(this.receiving);
        buffer.append(" sessionConsumer=").append(this.sessionConsumer);
        buffer.append(" waitingForMessage=").append(this.waitingForMessage);
        buffer.append(" messages=").append(this.messages.size());
        if (this.listenerThread != null) {
            buffer.append(" thread=").append(this.listenerThread);
        }
        if (this.messageListener != null) {
            buffer.append(" listener=").append(this.messageListener);
        }
        buffer.append(" session=").append(this.session);
        buffer.append(']');
        return buffer.toString();
    }

    Message getMessage() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (trace) {
                log.trace((Object)("Getting message from list " + this));
            }
            while (true) {
                try {
                    SpyMessage mes;
                    Message rc;
                    do {
                        if (this.messages.size() != 0) continue;
                        return null;
                    } while ((rc = this.preProcessMessage(mes = (SpyMessage)this.messages.removeFirst())) == null);
                    return rc;
                }
                catch (Throwable t) {
                    log.error((Object)"Ignoring error", t);
                    continue;
                }
                break;
            }
        }
    }

    Message preProcessMessage(SpyMessage message) throws JMSException {
        message.session = this.session;
        this.session.addUnacknowlegedMessage(message);
        this.prepareDelivery(message);
        if (!this.isListening()) {
            if (this.session.transacted) {
                if (trace) {
                    log.trace((Object)("preprocess() acking message in tx message=" + message.getJMSMessageID() + " " + this));
                }
                this.session.connection.spyXAResourceManager.ackMessage(this.session.getCurrentTransactionId(), message);
            } else if (this.session.acknowledgeMode == 1 || this.session.acknowledgeMode == 3) {
                message.doAcknowledge();
            }
            if (message instanceof SpyEncapsulatedMessage) {
                return ((SpyEncapsulatedMessage)message).getMessage();
            }
            return message;
        }
        return message;
    }

    void prepareDelivery(SpyMessage message) throws JMSException {
        int value;
        Integer delivery = ONCE;
        Integer redelivery = (Integer)message.header.jmsProperties.get("JMS_JBOSS_REDELIVERY_COUNT");
        if (redelivery != null && (value = redelivery.intValue()) != 0) {
            delivery = new Integer(value + 1);
        }
        message.header.jmsProperties.put("JMSXDeliveryCount", delivery);
    }

    protected Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.subscription.destination;
    }

    protected boolean getNoLocal() throws JMSException {
        this.checkClosed();
        return this.subscription.noLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isListening() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.listening;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionConsumerProcessMessage(SpyMessage message) throws JMSException {
        MessageListener thisListener;
        message.session = this.session;
        Object object = this.stateLock;
        synchronized (object) {
            thisListener = this.messageListener;
        }
        Object anonymousTXID = null;
        if (this.session.transacted) {
            if (this.session.getCurrentTransactionId() == null) {
                anonymousTXID = this.session.connection.spyXAResourceManager.startTx();
                this.session.setCurrentTransactionId(anonymousTXID);
            }
            if (trace) {
                log.trace((Object)("consumer() acking message in tx message=" + message.getJMSMessageID() + " " + this));
            }
            this.session.connection.spyXAResourceManager.ackMessage(this.session.getCurrentTransactionId(), message);
        }
        if (thisListener != null) {
            SpyMessage mes = message;
            if (message instanceof SpyEncapsulatedMessage) {
                mes = ((SpyEncapsulatedMessage)message).getMessage();
            }
            this.session.addUnacknowlegedMessage(mes);
            if (trace) {
                log.trace((Object)("consumer() before onMessage=" + message.getJMSMessageID() + " " + this));
            }
            thisListener.onMessage((Message)mes);
            if (trace) {
                log.trace((Object)("consumer() after onMessage=" + message.getJMSMessageID() + " " + this));
            }
        }
        if (this.session.transacted) {
            if (anonymousTXID != null && this.session.getCurrentTransactionId() == anonymousTXID) {
                try {
                    if (trace) {
                        log.trace((Object)("XASession was not enlisted - Committing work using anonymous xid: " + anonymousTXID));
                    }
                    this.session.connection.spyXAResourceManager.endTx(anonymousTXID, true);
                    this.session.connection.spyXAResourceManager.commit(anonymousTXID, true);
                }
                catch (Throwable t) {
                    log.error((Object)"Could not commit", t);
                }
                finally {
                    this.session.unsetCurrentTransactionId(anonymousTXID);
                }
            }
        } else if (this.session.acknowledgeMode == 1 || this.session.acknowledgeMode == 3) {
            message.doAcknowledge();
        }
    }

    private boolean isClosed() {
        return this.closed.get();
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The consumer is closed");
        }
    }
}

