/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyMessage;
import org.jboss.util.Primitives;

public class SpyStreamMessage
extends SpyMessage
implements StreamMessage,
Cloneable,
Externalizable {
    private static final long serialVersionUID = 2490910971426786841L;
    Vector content = new Vector();
    int position = 0;
    int offset = 0;
    int size = 0;

    public boolean readBoolean() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Boolean) {
                ++this.position;
                return (Boolean)value;
            }
            if (value instanceof String) {
                boolean result = Boolean.valueOf((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public byte readByte() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Byte) {
                ++this.position;
                return (Byte)value;
            }
            if (value instanceof String) {
                byte result = Byte.parseByte((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public short readShort() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Byte) {
                ++this.position;
                return ((Byte)value).shortValue();
            }
            if (value instanceof Short) {
                ++this.position;
                return (Short)value;
            }
            if (value instanceof String) {
                short result = Short.parseShort((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public char readChar() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Character) {
                ++this.position;
                return ((Character)value).charValue();
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readInt() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Byte) {
                ++this.position;
                return ((Byte)value).intValue();
            }
            if (value instanceof Short) {
                ++this.position;
                return ((Short)value).intValue();
            }
            if (value instanceof Integer) {
                ++this.position;
                return (Integer)value;
            }
            if (value instanceof String) {
                int result = Integer.parseInt((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public long readLong() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Byte) {
                ++this.position;
                return ((Byte)value).longValue();
            }
            if (value instanceof Short) {
                ++this.position;
                return ((Short)value).longValue();
            }
            if (value instanceof Integer) {
                ++this.position;
                return ((Integer)value).longValue();
            }
            if (value instanceof Long) {
                ++this.position;
                return (Long)value;
            }
            if (value instanceof String) {
                long result = Long.parseLong((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public float readFloat() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Float) {
                ++this.position;
                return ((Float)value).floatValue();
            }
            if (value instanceof String) {
                float result = Float.parseFloat((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public double readDouble() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            this.offset = 0;
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            if (value instanceof Float) {
                ++this.position;
                return ((Float)value).doubleValue();
            }
            if (value instanceof Double) {
                ++this.position;
                return (Double)value;
            }
            if (value instanceof String) {
                double result = Double.parseDouble((String)value);
                ++this.position;
                return result;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public String readString() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            this.offset = 0;
            if (value == null) {
                ++this.position;
                return null;
            }
            if (value instanceof Boolean) {
                ++this.position;
                return ((Boolean)value).toString();
            }
            if (value instanceof Byte) {
                ++this.position;
                return ((Byte)value).toString();
            }
            if (value instanceof Short) {
                ++this.position;
                return ((Short)value).toString();
            }
            if (value instanceof Character) {
                ++this.position;
                return ((Character)value).toString();
            }
            if (value instanceof Integer) {
                ++this.position;
                return ((Integer)value).toString();
            }
            if (value instanceof Long) {
                ++this.position;
                return ((Long)value).toString();
            }
            if (value instanceof Float) {
                ++this.position;
                return ((Float)value).toString();
            }
            if (value instanceof Double) {
                ++this.position;
                return ((Double)value).toString();
            }
            if (value instanceof String) {
                ++this.position;
                return (String)value;
            }
            throw new MessageFormatException("Invalid conversion");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object myObj = this.content.get(this.position);
            if (myObj == null) {
                throw new NullPointerException("Value is null");
            }
            if (!(myObj instanceof byte[])) {
                throw new MessageFormatException("Invalid conversion");
            }
            byte[] obj = (byte[])myObj;
            if (obj.length == 0) {
                ++this.position;
                this.offset = 0;
                return 0;
            }
            if (this.offset >= obj.length) {
                ++this.position;
                this.offset = 0;
                return -1;
            }
            if (obj.length - this.offset < value.length) {
                for (int i = 0; i < obj.length; ++i) {
                    value[i] = obj[i + this.offset];
                }
                ++this.position;
                this.offset = 0;
                return obj.length - this.offset;
            }
            for (int i = 0; i < value.length; ++i) {
                value[i] = obj[i + this.offset];
            }
            this.offset += value.length;
            return value.length;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public Object readObject() throws JMSException {
        if (!this.header.msgReadOnly) {
            throw new MessageNotReadableException("The message body is writeonly");
        }
        try {
            Object value = this.content.get(this.position);
            ++this.position;
            this.offset = 0;
            return value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(Primitives.valueOf((boolean)value));
    }

    public void writeByte(byte value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Byte(value));
    }

    public void writeShort(short value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Short(value));
    }

    public void writeChar(char value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Character(value));
    }

    public void writeInt(int value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Integer(value));
    }

    public void writeLong(long value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Long(value));
    }

    public void writeFloat(float value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Float(value));
    }

    public void writeDouble(double value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(new Double(value));
    }

    public void writeString(String value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        if (value == null) {
            this.content.add(null);
        } else {
            this.content.add(value);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        this.content.add(value.clone());
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        if (offset + length > value.length) {
            throw new JMSException("Array is too small");
        }
        byte[] temp = new byte[length];
        for (int i = 0; i < length; ++i) {
            temp[i] = value[i + offset];
        }
        this.content.add(temp);
    }

    public void writeObject(Object value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("The message body is readonly");
        }
        if (value == null) {
            this.content.add(null);
        } else if (value instanceof Boolean) {
            this.content.add(value);
        } else if (value instanceof Byte) {
            this.content.add(value);
        } else if (value instanceof Short) {
            this.content.add(value);
        } else if (value instanceof Character) {
            this.content.add(value);
        } else if (value instanceof Integer) {
            this.content.add(value);
        } else if (value instanceof Long) {
            this.content.add(value);
        } else if (value instanceof Float) {
            this.content.add(value);
        } else if (value instanceof Double) {
            this.content.add(value);
        } else if (value instanceof String) {
            this.content.add(value);
        } else if (value instanceof byte[]) {
            this.content.add(((byte[])value).clone());
        } else {
            throw new MessageFormatException("Invalid object type");
        }
    }

    public void reset() throws JMSException {
        this.header.msgReadOnly = true;
        this.position = 0;
        this.size = this.content.size();
        this.offset = 0;
    }

    public void clearBody() throws JMSException {
        this.content = new Vector();
        this.position = 0;
        this.offset = 0;
        this.size = 0;
        super.clearBody();
    }

    public SpyMessage myClone() throws JMSException {
        SpyStreamMessage result = MessagePool.getStreamMessage();
        result.copyProps(this);
        result.content = (Vector)this.content.clone();
        result.position = this.position;
        result.offset = this.offset;
        result.size = this.size;
        return result;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.content = (Vector)in.readObject();
        this.position = in.readInt();
        this.offset = in.readInt();
        this.size = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.content);
        out.writeInt(this.position);
        out.writeInt(this.offset);
        out.writeInt(this.size);
    }
}

