/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.util.EventObject;

public class FailoverEvent
extends EventObject {
    private static final long serialVersionUID = 8451706459791859231L;
    public static final int FAILURE_DETECTED = 10;
    public static final int FAILOVER_STARTED = 20;
    public static final int FAILOVER_COMPLETED = 30;
    public static final int FAILOVER_ALREADY_COMPLETED = 40;
    public static final int FAILOVER_FAILED = 100;
    private int type;

    public FailoverEvent(int type, Object source) {
        super(source);
        this.checkType(type);
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return this.type == 10 ? "FAILURE_DETECTED" : (this.type == 20 ? "FAILOVER_STARTED" : (this.type == 30 ? "FAILOVER_COMPLETED" : (this.type == 40 ? "FAILOVER_ALREADY_COMPLETED" : (this.type == 100 ? "FAILOVER_FAILED" : "UNKNOWN_FAILOVER_EVENT"))));
    }

    private void checkType(int type) throws IllegalArgumentException {
        if (type != 10 && type != 20 && type != 30 && type != 100 && type != 40) {
            throw new IllegalArgumentException("Illegal failover event type: " + type);
        }
    }
}

