/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf;

import java.beans.PropertyChangeSupport;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.debug.BSFDebugManager;
import org.apache.bsf.debug.util.DebugLog;
import org.apache.bsf.util.BSFDebugManagerImpl;
import org.apache.bsf.util.CodeBuffer;
import org.apache.bsf.util.ObjectRegistry;

public class BSFManager {
    protected static Hashtable registeredEngines = new Hashtable();
    protected static Hashtable extn2Lang = new Hashtable();
    protected Hashtable loadedEngines = new Hashtable();
    protected ObjectRegistry objectRegistry = new ObjectRegistry();
    protected PropertyChangeSupport pcs;
    protected ClassLoader classLoader = this.getClass().getClassLoader();
    protected String tempDir = ".";
    protected String classPath;
    protected Vector declaredBeans = new Vector();
    static BSFDebugManagerImpl gDebugManager;

    public BSFManager() {
        this.pcs = new PropertyChangeSupport(this);
        if (gDebugManager != null) {
            gDebugManager.registerManager(this);
        }
    }

    public Object apply(String string, String string2, int n, int n2, Object object, Vector vector, Vector vector2) throws BSFException {
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        final Vector vector3 = vector;
        final Vector vector4 = vector2;
        Object var15_15 = null;
        try {
            Object t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return bSFEngine.apply(string3, n3, n4, object2, vector3, vector4);
                }
            });
            var15_15 = t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BSFException)privilegedActionException.getException();
        }
        return var15_15;
    }

    public void compileApply(String string, String string2, int n, int n2, Object object, Vector vector, Vector vector2, CodeBuffer codeBuffer) throws BSFException {
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        final Vector vector3 = vector;
        final Vector vector4 = vector2;
        final CodeBuffer codeBuffer2 = codeBuffer;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine.compileApply(string3, n3, n4, object2, vector3, vector4, codeBuffer2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BSFException)privilegedActionException.getException();
        }
    }

    public void compileExpr(String string, String string2, int n, int n2, Object object, CodeBuffer codeBuffer) throws BSFException {
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        final CodeBuffer codeBuffer2 = codeBuffer;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine.compileExpr(string3, n3, n4, object2, codeBuffer2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BSFException)privilegedActionException.getException();
        }
    }

    public void compileScript(String string, String string2, int n, int n2, Object object, CodeBuffer codeBuffer) throws BSFException {
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        final CodeBuffer codeBuffer2 = codeBuffer;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine.compileScript(string3, n3, n4, object2, codeBuffer2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BSFException)privilegedActionException.getException();
        }
    }

    public void declareBean(String string, Object object, Class clazz) throws BSFException {
        this.registerBean(string, object);
        BSFDeclaredBean bSFDeclaredBean = new BSFDeclaredBean(string, object, clazz);
        this.declaredBeans.addElement(bSFDeclaredBean);
        Enumeration enumeration = this.loadedEngines.elements();
        while (enumeration.hasMoreElements()) {
            BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
            bSFEngine.declareBean(bSFDeclaredBean);
        }
    }

    public Object eval(String string, String string2, int n, int n2, Object object) throws BSFException {
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        Object var11_11 = null;
        try {
            Object t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return bSFEngine.eval(string3, n3, n4, object2);
                }
            });
            var11_11 = t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BSFException)privilegedActionException.getException();
        }
        return var11_11;
    }

    public void exec(String string, String string2, int n, int n2, Object object) throws BSFException {
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine.exec(string3, n3, n4, object2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BSFException)privilegedActionException.getException();
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getClassPath() {
        if (this.classPath == null) {
            try {
                this.classPath = System.getProperty("java.class.path");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.classPath;
    }

    public static BSFDebugManager getDebugManager() {
        return gDebugManager;
    }

    public static String getLangFromFilename(String string) throws BSFException {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            String string2 = string.substring(n + 1);
            String string3 = (String)extn2Lang.get(string2);
            String string4 = null;
            int n2 = 0;
            int n3 = 0;
            if (string3 != null) {
                while ((n2 = string3.indexOf(":", 0)) != -1) {
                    string4 = string3.substring(0, n2);
                    string3 = string3.substring(n2 + 1);
                    ++n3;
                    try {
                        String string5 = (String)registeredEngines.get(string4);
                        Class.forName(string5);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        string4 = string3;
                    }
                }
                if (n3 == 0) {
                    string4 = string3;
                }
            }
            if (string4 != null && string4 != "") {
                return string4;
            }
        }
        throw new BSFException(BSFException.REASON_OTHER_ERROR, "file extension missing or unknown: unable to determine language for '" + string + "'");
    }

    public ObjectRegistry getObjectRegistry() {
        return this.objectRegistry;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public static boolean isLanguageRegistered(String string) {
        return registeredEngines.get(string) != null;
    }

    public BSFEngine loadScriptingEngine(String string) throws BSFException {
        BSFEngine bSFEngine = (BSFEngine)this.loadedEngines.get(string);
        if (bSFEngine != null) {
            return bSFEngine;
        }
        String string2 = (String)registeredEngines.get(string);
        if (string2 == null) {
            throw new BSFException(BSFException.REASON_UNKNOWN_LANGUAGE, "unsupported language: " + string);
        }
        try {
            Class<?> clazz = this.classLoader == null ? Class.forName(string2) : this.classLoader.loadClass(string2);
            final BSFEngine bSFEngine2 = (BSFEngine)clazz.newInstance();
            final BSFManager bSFManager = this;
            final String string3 = string;
            final Vector vector = this.declaredBeans;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine2.initialize(bSFManager, string3, vector);
                    return null;
                }
            });
            bSFEngine = bSFEngine2;
            this.loadedEngines.put(string, bSFEngine);
            this.pcs.addPropertyChangeListener(bSFEngine);
            return bSFEngine;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BSFException)privilegedActionException.getException();
        }
        catch (Throwable throwable) {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, "unable to load language: " + string, throwable);
        }
    }

    public Object lookupBean(String string) {
        try {
            return this.objectRegistry.lookup(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static void initBSFDebugManager() {
        if (gDebugManager != null) {
            DebugLog.stdoutPrintln("BSF Debug Manager already running...", 1);
        } else {
            DebugLog.stdoutPrintln("BSF in Debug Mode...", 1);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        System.setProperty("org.apache.bsf.isServer", "true");
                        return null;
                    }
                });
                gDebugManager = new BSFDebugManagerImpl();
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                System.err.println("Cannot set up debug manager: " + exception.getMessage());
                exception.printStackTrace();
                System.err.println("Execution continues without debugging.");
            }
            catch (Exception exception) {
                System.err.println("BSF Factory cannot bound BSF Manager: " + exception.getMessage());
                exception.printStackTrace();
                System.err.println("Ignoring... Execution continues...");
            }
        }
    }

    public void registerBean(String string, Object object) {
        this.objectRegistry.register(string, object);
    }

    public static void registerScriptingEngine(String string, String string2, String[] stringArray) {
        registeredEngines.put(string, string2);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = (String)extn2Lang.get(stringArray[i]);
                string3 = string3 == null ? string : string + ":" + string3;
                extn2Lang.put(stringArray[i], string3);
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.pcs.firePropertyChange("classLoader", this.classLoader, classLoader);
        this.classLoader = classLoader;
    }

    public void setClassPath(String string) {
        this.pcs.firePropertyChange("classPath", this.classPath, string);
        this.classPath = string;
    }

    public void setObjectRegistry(ObjectRegistry objectRegistry) {
        this.objectRegistry = objectRegistry;
    }

    public void setTempDir(String string) {
        this.pcs.firePropertyChange("tempDir", this.tempDir, string);
        this.tempDir = string;
    }

    public void terminate() {
        Enumeration enumeration = this.loadedEngines.elements();
        while (enumeration.hasMoreElements()) {
            BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
            bSFEngine.terminate();
        }
        this.loadedEngines = new Hashtable();
        if (gDebugManager != null) {
            gDebugManager.terminateManagerNotify(this);
        }
    }

    public void undeclareBean(String string) throws BSFException {
        this.unregisterBean(string);
        BSFDeclaredBean bSFDeclaredBean = null;
        for (int i = 0; i < this.declaredBeans.size(); ++i) {
            bSFDeclaredBean = (BSFDeclaredBean)this.declaredBeans.elementAt(i);
            if (bSFDeclaredBean.name.equals(string)) break;
        }
        if (bSFDeclaredBean != null) {
            this.declaredBeans.removeElement(bSFDeclaredBean);
            Enumeration enumeration = this.loadedEngines.elements();
            while (enumeration.hasMoreElements()) {
                BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
                bSFEngine.undeclareBean(bSFDeclaredBean);
            }
        }
    }

    public void unregisterBean(String string) {
        this.objectRegistry.unregister(string);
    }

    static {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.bsf.Languages");
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = resourceBundle.getString(string);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "|");
                String[] stringArray = new String[stringTokenizer2.countTokens()];
                int n = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    stringArray[n] = stringTokenizer2.nextToken().trim();
                    ++n;
                }
                BSFManager.registerScriptingEngine(string, string3, stringArray);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            System.err.println("Syntax error in Languages resource bundle");
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            System.err.println("Initialization error: " + missingResourceException.toString());
        }
        if (Boolean.getBoolean("org.apache.bsf.serverLaunch")) {
            BSFManager.initBSFDebugManager();
        }
    }
}

