/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import java.util.Date;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.scheduler.AbstractScheduleProviderMBean;
import org.jboss.varia.scheduler.ScheduleManagerMBean;

public abstract class AbstractScheduleProvider
extends ServiceMBeanSupport
implements AbstractScheduleProviderMBean {
    private ObjectName scheduleManagerName = ScheduleManagerMBean.OBJECT_NAME;

    public ObjectName getScheduleManagerName() {
        return this.scheduleManagerName;
    }

    public void setScheduleManagerName(ObjectName scheduleManagerName) {
        this.scheduleManagerName = scheduleManagerName;
    }

    public abstract void startProviding() throws Exception;

    public abstract void stopProviding();

    protected int addSchedule(ObjectName pTarget, String pMethodName, String[] pMethodSignature, Date pStart, long pPeriod, int pRepetitions) throws JMException {
        return (Integer)this.server.invoke(this.scheduleManagerName, "addSchedule", new Object[]{this.serviceName, pTarget, pMethodName, pMethodSignature, pStart, new Long(pPeriod), new Integer(pRepetitions)}, new String[]{ObjectName.class.getName(), ObjectName.class.getName(), String.class.getName(), String[].class.getName(), Date.class.getName(), Long.TYPE.getName(), Integer.TYPE.getName()});
    }

    protected void removeSchedule(int pID) throws JMException {
        this.server.invoke(this.scheduleManagerName, "removeSchedule", new Object[]{new Integer(pID)}, new String[]{Integer.TYPE.getName()});
    }

    protected void startService() throws Exception {
        this.startScheduleProviderService();
    }

    protected void stopService() throws Exception {
        this.stopScheduleProviderService();
    }

    protected void startScheduleProviderService() throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.server.invoke(this.scheduleManagerName, "registerProvider", new Object[]{this.serviceName.toString()}, new String[]{String.class.getName()});
    }

    protected void stopScheduleProviderService() throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            this.server.invoke(this.scheduleManagerName, "unregisterProvider", new Object[]{this.serviceName.toString()}, new String[]{String.class.getName()});
        }
        catch (JMException jme) {
            this.log.error((Object)"Could not unregister the Provider from the Schedule Manager", (Throwable)jme);
        }
    }
}

