/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.ContextTransaction;
import org.apache.catalina.deploy.MessageDestinationRef;

public class NamingResources
implements Serializable {
    private Object container = null;
    private Hashtable entries = new Hashtable();
    private HashMap ejbs = new HashMap();
    private HashMap envs = new HashMap();
    private HashMap localEjbs = new HashMap();
    private HashMap mdrs = new HashMap();
    private HashMap resourceEnvRefs = new HashMap();
    private HashMap resources = new HashMap();
    private HashMap resourceLinks = new HashMap();
    private HashMap services = new HashMap();
    private ContextTransaction transaction = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Object getContainer() {
        return this.container;
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public void setTransaction(ContextTransaction transaction) {
        this.transaction = transaction;
    }

    public ContextTransaction getTransaction() {
        return this.transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjb(ContextEjb ejb) {
        if (this.entries.containsKey(ejb.getName())) {
            return;
        }
        this.entries.put(ejb.getName(), ejb.getType());
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            ejb.setNamingResources(this);
            this.ejbs.put(ejb.getName(), ejb);
        }
        this.support.firePropertyChange("ejb", null, ejb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEnvironment(ContextEnvironment environment) {
        if (this.entries.containsKey(environment.getName())) {
            ContextEnvironment ce = this.findEnvironment(environment.getName());
            ContextResourceLink rl = this.findResourceLink(environment.getName());
            if (ce != null) {
                if (!ce.getOverride()) return;
                this.removeEnvironment(environment.getName());
            } else {
                if (rl == null) return;
                NamingResources global = ServerFactory.getServer().getGlobalNamingResources();
                if (global.findEnvironment(rl.getGlobal()) != null) {
                    if (!global.findEnvironment(rl.getGlobal()).getOverride()) return;
                    this.removeResourceLink(environment.getName());
                }
            }
        }
        this.entries.put(environment.getName(), environment.getType());
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            environment.setNamingResources(this);
            this.envs.put(environment.getName(), environment);
        }
        this.support.firePropertyChange("environment", null, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalEjb(ContextLocalEjb ejb) {
        if (this.entries.containsKey(ejb.getName())) {
            return;
        }
        this.entries.put(ejb.getName(), ejb.getType());
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            ejb.setNamingResources(this);
            this.localEjbs.put(ejb.getName(), ejb);
        }
        this.support.firePropertyChange("localEjb", null, ejb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestinationRef(MessageDestinationRef mdr) {
        if (this.entries.containsKey(mdr.getName())) {
            return;
        }
        this.entries.put(mdr.getName(), mdr.getType());
        HashMap hashMap = this.mdrs;
        synchronized (hashMap) {
            mdr.setNamingResources(this);
            this.mdrs.put(mdr.getName(), mdr);
        }
        this.support.firePropertyChange("messageDestinationRef", null, mdr);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(ContextResource resource) {
        if (this.entries.containsKey(resource.getName())) {
            return;
        }
        this.entries.put(resource.getName(), resource.getType());
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            resource.setNamingResources(this);
            this.resources.put(resource.getName(), resource);
        }
        this.support.firePropertyChange("resource", null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceEnvRef(ContextResourceEnvRef resource) {
        if (this.entries.containsKey(resource.getName())) {
            return;
        }
        this.entries.put(resource.getName(), resource.getType());
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            resource.setNamingResources(this);
            this.resourceEnvRefs.put(resource.getName(), resource);
        }
        this.support.firePropertyChange("resourceEnvRef", null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceLink(ContextResourceLink resourceLink) {
        if (this.entries.containsKey(resourceLink.getName())) {
            return;
        }
        String value = resourceLink.getType();
        if (value == null) {
            value = "";
        }
        this.entries.put(resourceLink.getName(), value);
        HashMap hashMap = this.resourceLinks;
        synchronized (hashMap) {
            resourceLink.setNamingResources(this);
            this.resourceLinks.put(resourceLink.getName(), resourceLink);
        }
        this.support.firePropertyChange("resourceLink", null, resourceLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(ContextService service) {
        if (this.entries.containsKey(service.getName())) {
            return;
        }
        String value = service.getType();
        if (value == null) {
            value = "";
        }
        this.entries.put(service.getName(), value);
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            service.setNamingResources(this);
            this.services.put(service.getName(), service);
        }
        this.support.firePropertyChange("service", null, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb findEjb(String name) {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            return (ContextEjb)this.ejbs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEjb[] findEjbs() {
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            ContextEjb[] results = new ContextEjb[this.ejbs.size()];
            return this.ejbs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment findEnvironment(String name) {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            return (ContextEnvironment)this.envs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEnvironment[] findEnvironments() {
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            ContextEnvironment[] results = new ContextEnvironment[this.envs.size()];
            return this.envs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb findLocalEjb(String name) {
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            return (ContextLocalEjb)this.localEjbs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLocalEjb[] findLocalEjbs() {
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            ContextLocalEjb[] results = new ContextLocalEjb[this.localEjbs.size()];
            return this.localEjbs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestinationRef findMessageDestinationRef(String name) {
        HashMap hashMap = this.mdrs;
        synchronized (hashMap) {
            return (MessageDestinationRef)this.mdrs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestinationRef[] findMessageDestinationRefs() {
        HashMap hashMap = this.mdrs;
        synchronized (hashMap) {
            MessageDestinationRef[] results = new MessageDestinationRef[this.mdrs.size()];
            return this.mdrs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource findResource(String name) {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            return (ContextResource)this.resources.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceLink findResourceLink(String name) {
        HashMap hashMap = this.resourceLinks;
        synchronized (hashMap) {
            return (ContextResourceLink)this.resourceLinks.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceLink[] findResourceLinks() {
        HashMap hashMap = this.resourceLinks;
        synchronized (hashMap) {
            ContextResourceLink[] results = new ContextResourceLink[this.resourceLinks.size()];
            return this.resourceLinks.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResource[] findResources() {
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            ContextResource[] results = new ContextResource[this.resources.size()];
            return this.resources.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceEnvRef findResourceEnvRef(String name) {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            return (ContextResourceEnvRef)this.resourceEnvRefs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextResourceEnvRef[] findResourceEnvRefs() {
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            ContextResourceEnvRef[] results = new ContextResourceEnvRef[this.resourceEnvRefs.size()];
            return this.resourceEnvRefs.values().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextService findService(String name) {
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            return (ContextService)this.services.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextService[] findServices() {
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            ContextService[] results = new ContextService[this.services.size()];
            return this.services.values().toArray(results);
        }
    }

    public boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEjb(String name) {
        this.entries.remove(name);
        ContextEjb ejb = null;
        HashMap hashMap = this.ejbs;
        synchronized (hashMap) {
            ejb = (ContextEjb)this.ejbs.remove(name);
        }
        if (ejb != null) {
            this.support.firePropertyChange("ejb", ejb, null);
            ejb.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvironment(String name) {
        this.entries.remove(name);
        ContextEnvironment environment = null;
        HashMap hashMap = this.envs;
        synchronized (hashMap) {
            environment = (ContextEnvironment)this.envs.remove(name);
        }
        if (environment != null) {
            this.support.firePropertyChange("environment", environment, null);
            environment.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEjb(String name) {
        this.entries.remove(name);
        ContextLocalEjb localEjb = null;
        HashMap hashMap = this.localEjbs;
        synchronized (hashMap) {
            localEjb = (ContextLocalEjb)this.ejbs.remove(name);
        }
        if (localEjb != null) {
            this.support.firePropertyChange("localEjb", localEjb, null);
            localEjb.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestinationRef(String name) {
        this.entries.remove(name);
        MessageDestinationRef mdr = null;
        HashMap hashMap = this.mdrs;
        synchronized (hashMap) {
            mdr = (MessageDestinationRef)this.mdrs.remove(name);
        }
        if (mdr != null) {
            this.support.firePropertyChange("messageDestinationRef", mdr, null);
            mdr.setNamingResources(null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(String name) {
        this.entries.remove(name);
        ContextResource resource = null;
        HashMap hashMap = this.resources;
        synchronized (hashMap) {
            resource = (ContextResource)this.resources.remove(name);
        }
        if (resource != null) {
            this.support.firePropertyChange("resource", resource, null);
            resource.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceEnvRef(String name) {
        this.entries.remove(name);
        String type = null;
        HashMap hashMap = this.resourceEnvRefs;
        synchronized (hashMap) {
            type = (String)this.resourceEnvRefs.remove(name);
        }
        if (type != null) {
            this.support.firePropertyChange("resourceEnvRef", name + ":" + type, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceLink(String name) {
        this.entries.remove(name);
        ContextResourceLink resourceLink = null;
        HashMap hashMap = this.resourceLinks;
        synchronized (hashMap) {
            resourceLink = (ContextResourceLink)this.resourceLinks.remove(name);
        }
        if (resourceLink != null) {
            this.support.firePropertyChange("resourceLink", resourceLink, null);
            resourceLink.setNamingResources(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(String name) {
        this.entries.remove(name);
        ContextService service = null;
        HashMap hashMap = this.services;
        synchronized (hashMap) {
            service = (ContextService)this.services.remove(name);
        }
        if (service != null) {
            this.support.firePropertyChange("service", service, null);
            service.setNamingResources(null);
        }
    }
}

