/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.bean;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.bean.CollectedDataInfo;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.Facility;
import com.clustercontrol.performance.bean.Node;
import com.clustercontrol.performance.bean.Scope;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.util.Repository;
import com.clustercontrol.poller.NotInitializedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeTree
implements Serializable {
    private static final long serialVersionUID = 3172674418733261184L;
    protected static Log m_log = LogFactory.getLog(ScopeTree.class);
    private Hashtable<String, Scope> m_scopeTable;
    private Hashtable<String, Node> m_nodeTable;
    private long m_lastPollingTime;
    private long m_lastCollectTime = 0L;
    private int m_intarvalSec = 0;
    private volatile boolean updateFlag = false;

    public ScopeTree(FacilityTreeItem treeItem, List<CollectorDeviceInfoData> deviceDataList, HashMap<String, ArrayList<String>> platformMap, int intervalSec) {
        m_log.debug((Object)"ScopeTree \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf");
        this.m_scopeTable = new Hashtable();
        this.m_nodeTable = new Hashtable();
        this.m_intarvalSec = intervalSec;
        this.setScopeTree(treeItem, deviceDataList, platformMap);
    }

    public void addScope(String facilityID, String facilityName, String parent) {
        Scope scope = new Scope(facilityID, facilityName);
        Scope parentScope = this.m_scopeTable.get(parent);
        if (parentScope != null) {
            scope.addParents(parentScope);
            parentScope.addChildren(scope);
        }
        this.m_scopeTable.put(facilityID, scope);
    }

    public void addNode(String facilityId, String facilityName, List<CollectorDeviceInfoData> deviceDataList, String parent, HashMap<String, ArrayList<String>> platformMap) {
        Scope parentScope;
        m_log.debug((Object)("addNode facilityId : " + facilityId + ", " + facilityName));
        Node node = this.m_nodeTable.get(facilityId);
        String platformId = null;
        String subPlatformId = null;
        ArrayList<String> platforms = null;
        if (node == null) {
            if (platformMap == null) {
                platformId = Repository.getPlatformId(facilityId);
                subPlatformId = Repository.getSubPlatformId(facilityId);
                m_log.debug((Object)("addNode facilityId : " + facilityId + ", " + platformId + ", " + subPlatformId));
            } else {
                platforms = platformMap.get(facilityId);
                platformId = platforms.get(0);
                subPlatformId = platforms.get(1);
            }
            node = new Node(facilityId, facilityName, platformId, subPlatformId, deviceDataList);
        }
        if ((parentScope = this.m_scopeTable.get(parent)) != null) {
            node.addParents(parentScope);
            parentScope.addChildren(node);
        }
        this.m_nodeTable.put(facilityId, node);
    }

    public boolean contains(String facilityID) {
        Scope scope = this.m_scopeTable.get(facilityID);
        Node node = this.m_nodeTable.get(facilityID);
        return scope != null || node != null;
    }

    public String[] getNodeIDList(String facilityID) {
        Scope scope = this.m_scopeTable.get(facilityID);
        String[] nodeListFaciliyID = null;
        HashSet nodeListSet = new HashSet();
        if (scope != null) {
            scope.getNode(nodeListSet);
            Node[] nodeList = new Node[nodeListSet.size()];
            nodeListSet.toArray(nodeList);
            nodeListFaciliyID = new String[nodeList.length];
            for (int i = 0; i < nodeList.length; ++i) {
                nodeListFaciliyID[i] = nodeList[i].getFacilityId();
            }
        } else {
            Node node = this.m_nodeTable.get(facilityID);
            if (node != null) {
                nodeListFaciliyID = new String[]{node.getFacilityId()};
            } else {
                m_log.debug((Object)("Facility not found : " + facilityID));
                nodeListFaciliyID = new String[]{};
            }
        }
        return nodeListFaciliyID;
    }

    public String[] getSubScopeIDList(String facilityID) {
        Scope scope = this.m_scopeTable.get(facilityID);
        if (scope == null) {
            String message = "Facility not found : " + facilityID;
            throw new EJBException(message);
        }
        return scope.getChildrenID();
    }

    public synchronized long fetchMibValue(String collectorId, String facilityId) throws NotInitializedException {
        String[] nodeFid = this.getNodeIDList(facilityId);
        long lastPollingTime = this.m_lastPollingTime;
        for (int i = 0; i < nodeFid.length; ++i) {
            Node node = this.m_nodeTable.get(nodeFid[i]);
            if (node != null) {
                long lastCollectTime = node.fetchMibValue(collectorId);
                this.m_lastPollingTime = Math.max(this.m_lastPollingTime, lastCollectTime);
                if (!m_log.isDebugEnabled()) continue;
                m_log.debug((Object)("FacilityID : " + nodeFid[i] + "  PreviousCollectTime : " + new Date(lastPollingTime) + "  LastCollectTime : " + new Date(this.m_lastPollingTime)));
                continue;
            }
            String message = "Facility not found : " + nodeFid[i];
            throw new EJBException(message);
        }
        this.updateFlag = this.m_lastPollingTime > lastPollingTime;
        if (this.updateFlag && this.m_lastCollectTime < this.m_lastPollingTime) {
            this.updateFlag = false;
            this.m_lastCollectTime = this.m_lastPollingTime;
        } else {
            long currentTime = System.currentTimeMillis();
            long collectTime = currentTime / (long)this.m_intarvalSec * (long)this.m_intarvalSec;
            this.m_lastCollectTime = this.m_lastCollectTime < collectTime ? collectTime : Math.max(this.m_lastCollectTime, currentTime) + 1L;
        }
        return this.m_lastCollectTime;
    }

    public synchronized CollectedDataInfo getValue(String facilityId, CollectorItemInfo cii) {
        double value = Double.NaN;
        Date d = new Date(this.m_lastCollectTime);
        Facility facility = this.m_scopeTable.get(facilityId);
        if (facility == null) {
            m_log.debug((Object)"Facility is node");
            facility = this.m_nodeTable.get(facilityId);
        }
        if (facility == null) {
            m_log.debug((Object)("Facility not found : " + facility));
            return new CollectedDataInfo(facilityId, cii.getItemCode(), cii.getDisplayName(), d, value);
        }
        value = facility.calcValue(cii);
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("FacilityID : " + facilityId + "  Code : " + cii.getItemCode() + "  DisplayName : " + cii.getDisplayName() + "  Date : " + d + "  updateFlg : " + this.updateFlag));
        }
        return new CollectedDataInfo(facilityId, cii.getItemCode(), cii.getDisplayName(), d, value);
    }

    public synchronized CollectedDataInfo getTempValue(String facilityId, CollectorItemInfo cii) {
        double value = Double.NaN;
        Facility facility = this.m_scopeTable.get(facilityId);
        if (facility == null) {
            facility = this.m_nodeTable.get(facilityId);
        }
        if (facility == null) {
            String message = "Facility not found : " + facilityId;
            throw new EJBException(message);
        }
        value = facility.getCalcValueBuffer(cii);
        CollectedDataInfo ret = this.m_lastCollectTime == 0L ? new CollectedDataInfo(facilityId, cii.getItemCode(), cii.getDisplayName(), new Date(), Double.NaN) : new CollectedDataInfo(facilityId, cii.getItemCode(), cii.getDisplayName(), new Date(this.m_lastCollectTime), value);
        return ret;
    }

    public Facility getFacility(String facilityID) {
        Scope scope = this.m_scopeTable.get(facilityID);
        Node node = this.m_nodeTable.get(facilityID);
        if (scope != null && node == null) {
            return scope;
        }
        if (scope == null && node != null) {
            return node;
        }
        String message = "Facility not found : " + facilityID;
        throw new EJBException(message);
    }

    private void setScopeTree(FacilityTreeItem treeItem, List<CollectorDeviceInfoData> deviceDataList, HashMap<String, ArrayList<String>> platformMap) {
        FacilityInfo info = treeItem.getData();
        if (info.getType() == 0) {
            this.addScope(info.getFacilityId(), info.getFacilityName(), treeItem.getParent().getData().getFacilityId());
        } else if (info.getType() == 1 && info.isValid()) {
            Iterator<CollectorDeviceInfoData> itr = deviceDataList.iterator();
            ArrayList<CollectorDeviceInfoData> nodeDeviceList = new ArrayList<CollectorDeviceInfoData>();
            while (itr.hasNext()) {
                CollectorDeviceInfoData deviceData = itr.next();
                if (!info.getFacilityId().equals(deviceData.getFacilityId())) continue;
                nodeDeviceList.add(deviceData);
            }
            this.addNode(info.getFacilityId(), info.getFacilityName(), nodeDeviceList, treeItem.getParent().getData().getFacilityId(), platformMap);
        }
        FacilityTreeItem[] tmpItem = treeItem.getChildren();
        if (tmpItem.length != 0) {
            for (int i = 0; i < tmpItem.length; ++i) {
                this.setScopeTree(tmpItem[i], deviceDataList, platformMap);
            }
        }
    }

    public boolean isScope(String facilityID) {
        return this.m_scopeTable.get(facilityID) != null;
    }

    public boolean isNode(String facilityID) {
        return this.m_nodeTable.get(facilityID) != null;
    }

    public String[] getAllFacilityIdList() {
        String[] ret = new String[this.m_nodeTable.size() + this.m_scopeTable.size()];
        int i = 0;
        for (Scope scope : this.m_scopeTable.values()) {
            ret[i] = scope.getFacilityId();
            ++i;
        }
        for (Node node : this.m_nodeTable.values()) {
            ret[i] = node.getFacilityId();
            ++i;
        }
        return ret;
    }

    public long getLastCollectTime() {
        return this.m_lastCollectTime;
    }
}

