#!/bin/sh

SU_PROC="/bin/su"
MKDIR_PROC="/bin/mkdir"
TOUCH_PROC="/bin/touch"
CHMOD_PROC="/bin/chmod"
LS_PROC="/bin/ls"
GREP_PROC="/bin/grep"
EXPECT_PROC="/usr/bin/expect"
SSH_PROC="/usr/bin/ssh"
SSHKEYGEN_PROC="/usr/bin/ssh-keygen -t rsa"

AGENT_HOME="/opt/hinemos_agent"
AGENT_PROPERTIES="${AGENT_HOME}/lib/agent/Agent.properties"

# 変数
ip_address=""
root_pass=""
user=""
pass=""

##
## 引数格納
##
while [ $# -gt 0 ] 
do
  case $1 in
    -i)
      shift
      ip_address=$1
      ;;
    -r)
      shift
      root_pass=$1
      ;;
    -u)
      shift
      user=$1
      user_home=`${GREP_PROC} ^${user}: /etc/passwd | awk -F: '{print $6}'`
      ;;
    -p)
      shift
      pass=$1 
      ;;
    *)
      ;;
  esac

  shift 

done


##
## 確認
##

# 入力値の確認
if [ "${ip_address}" = "" ]; then
    echo "転送元IPアドレスを入力して下さい。"
    exit 1
elif [ "${root_pass}" = "" ]; then
    echo "転送元rootユーザのパスワードを入力して下さい。"
    exit 1
elif [ "${user}" = "" ]; then
    echo "ファイル転送実行ユーザ名を入力して下さい。"
    exit 1
elif [ "${pass}" = "" ]; then
    echo "ファイル転送実行ユーザのパスワードを入力して下さい。"
    exit 1
fi

## 転送先
# 転送ユーザの確認(転送先)
if [ "`cat /etc/passwd | ${GREP_PROC} ^${user}:`" = "" ]; then
    echo "${user}は存在しません。"
    exit 1
fi

# Hinemosエージェントの確認
if [ ! -f ${AGENT_PROPERTIES} ]; then
    echo "${HOSTNAME}にHinemosエージェントがインストールされていません。"
    exit 1 
fi


## 転送元
# IPアドレスの確認とパスワードの確認
$EXPECT_PROC -c "
    set timeout 1
    spawn -noecho $SSH_PROC -n ${ip_address} -l root
    expect {
        -re \".*Name or service not known\" { exit 1}
        \"Are you sure\" { send yes\r }
        timeout
    }
    expect root
    send ${root_pass}\r
    expect {
        -re \".*root\" { exit 0 }
        timeout { exit 2 }
    }
" > /dev/null
case $? in
    1)
      echo "IP:${ip_address}  IPアドレスが存在しません。"
      exit 1
      ;;
    2)
      echo "IP:${ip_address}  rootユーザのパスワードが間違っています。"
      exit 1
      ;;
    *)
      break
      ;;
esac

# 転送ユーザの確認とエージェントの確認
$EXPECT_PROC -c "
    set timeout 1
    spawn -noecho $SSH_PROC -n ${ip_address} -l ${user} \"
        ${LS_PROC} ${AGENT_PROPERTIES}
    \"
    expect ${user}    
    send ${pass}\r
    expect {
        -re \".*${AGENT_PROPERTIES}\" { exit 0 }
        -re \".*${LS_PROC}\" { exit 2 }
        timeout { exit 1 }
    }
" > /dev/null
case $? in
    1)
      echo "IP:${ip_address}  ${user}が存在しないか、${user}のパスワードが間違っています。" 
      exit 1
      ;;
    2)
      echo "IP:${ip_address}  Hinemosエージェントがインストールされていません。"
      exit 1
      ;;
    *)
      break
      ;;
esac




##
## 転送先の設定
##

# 転送ユーザの公開鍵を作成する
$SU_PROC - $user -c "
    if [ ! -f ${user_home}/.ssh/id_rsa.pub ]; then
        $EXPECT_PROC -c \"
            spawn -noecho ${SSHKEYGEN_PROC}
            expect Enter
            send \r
            expect Enter
            send \r 
            expect Enter
            send \r
            expect eof
        \"
    fi
"  > /dev/null


# Hinemosエージェントへ転送ユーザの公開鍵を登録する
if [ -f ${AGENT_PROPERTIES} ]; then

    TMP_KEY="${user}.public.key=`cat ${user_home}/.ssh/id_rsa.pub`"
    if [ `${GREP_PROC} "${TMP_KEY}" ${AGENT_PROPERTIES} | wc -l` = 0 ]; then 
        echo $TMP_KEY >> ${AGENT_PROPERTIES}
    fi

else # Hinemosエージェントがインストールされていない場合。
    echo "Hinemosエージェントがインストールされていません。"
    exit 1
fi 


# 転送ユーザのknown_hostsに転送先のホスト鍵を登録する
$SU_PROC - $user -c "
    $EXPECT_PROC -c \"
        set timeout 1
        spawn $SSH_PROC -n ${ip_address} -l ${user}
        expect {
            \\\"Are you sure\\\" { send yes\r }
            timeout
        }
        expect eof
    \"
"  > /dev/null




##
## 転送元の設定
##

# 転送ユーザにauthorized_keysファイルを作成する
$EXPECT_PROC -c "
    set timeout 1
    spawn $SSH_PROC -n ${ip_address} -l ${user} \"
        ${MKDIR_PROC} -m 700 ${user_home}/.ssh
        ${TOUCH_PROC} ${user_home}/.ssh/authorized_keys
        ${CHMOD_PROC} 600 ${user_home}/.ssh/authorized_keys 
    \"
    expect ${user}
    send ${pass}\r
    expect eof
" > /dev/null


# 転送元のAgent.propertiesに転送ユーザのauthorized_keysのパスを登録する
$EXPECT_PROC -c "
    set timeout 1
    spawn -noecho $SSH_PROC -n ${ip_address} -l root \"
        if \[ \`${GREP_PROC} ${user}.authorized.keys.path=${user_home}/.ssh/authorized_keys ${AGENT_PROPERTIES} | wc -l\` = 0 \]; then
            echo ${user}.authorized.keys.path=${user_home}/.ssh/authorized_keys >> ${AGENT_PROPERTIES}
        fi        
    \"
    expect root
    send ${root_pass}\r
    expect eof
" > /dev/null

echo "設定が正常に終了しました。"
exit
