--
-- PostgreSQL database dump
--

BEGIN;

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: hinemos
--

COMMENT ON SCHEMA public IS 'Standard public schema';

SET search_path = public, pg_catalog;
SET default_tablespace = '';
SET default_with_oids = false;


CREATE TABLE cc_acc_lock (
    lock_id character varying(64) NOT NULL
);

ALTER TABLE public.cc_acc_lock OWNER TO hinemos;


CREATE TABLE cc_action_inhibition_info (
    notify_group_id character varying(1024) NOT NULL,
    notify_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    duplication_count bigint NOT NULL,
    last_notify_date timestamp without time zone NOT NULL,
    last_update_date timestamp without time zone NOT NULL,
    total_count bigint NOT NULL
);

ALTER TABLE public.cc_action_inhibition_info OWNER TO hinemos;


CREATE TABLE cc_cal_add_info (
    calendar_id character varying(64) NOT NULL,
    time_from timestamp without time zone NOT NULL,
    time_to timestamp without time zone NOT NULL,
    execute_flg smallint NOT NULL,
    description character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);

ALTER TABLE public.cc_cal_add_info OWNER TO hinemos;

CREATE TABLE cc_cal_info (
    calendar_id character varying(64) NOT NULL,
    calendar_name character varying(256) NOT NULL,
    description character varying(256),
    start_time time without time zone,
    valid_time_from timestamp without time zone NOT NULL,
    valid_time_to timestamp without time zone NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);

ALTER TABLE public.cc_cal_info OWNER TO hinemos;


CREATE TABLE cc_cal_weekday_info (
    calendar_id character varying(64) NOT NULL,
    weekday smallint NOT NULL,
    time_from time without time zone NOT NULL,
    time_to time without time zone NOT NULL,
    description character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);

ALTER TABLE public.cc_cal_weekday_info OWNER TO hinemos;


CREATE TABLE cc_crun_cmd_mst (
    command_id character varying(64) NOT NULL,
    type_id character varying(64),
    order_no smallint NOT NULL,
    name_id character varying(256),
    command_type smallint NOT NULL,
    command character varying(256)
);

ALTER TABLE public.cc_crun_cmd_mst OWNER TO hinemos;


CREATE TABLE cc_crun_cmd_param_mst (
    command_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    param_prefix character varying(64)
);


ALTER TABLE public.cc_crun_cmd_param_mst OWNER TO hinemos;


CREATE TABLE cc_crun_end_mst (
    command_id character varying(64) NOT NULL,
    end_status smallint NOT NULL,
    end_value_from smallint NOT NULL,
    end_value_to smallint NOT NULL
);


ALTER TABLE public.cc_crun_end_mst OWNER TO hinemos;


CREATE TABLE cc_crun_param_mst (
    param_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    param_type smallint NOT NULL
);

ALTER TABLE public.cc_crun_param_mst OWNER TO hinemos;


CREATE TABLE cc_crun_param_select_mst (
    param_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    name_id character varying(256) NOT NULL,
    param_value character varying(4096)
);


ALTER TABLE public.cc_crun_param_select_mst OWNER TO hinemos;


CREATE TABLE cc_crun_session (
    session_id character varying(64) NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    type_id character varying(64) NOT NULL,
    command_id character varying(64),
    facility_id character varying(64) NOT NULL,
    scope_text character varying(256),
    node_cnt smallint NOT NULL,
    wait_cnt smallint NOT NULL,
    running_cnt smallint NOT NULL,
    end_nomal_cnt smallint NOT NULL,
    end_warning_cnt smallint NOT NULL,
    end_abnomal_cnt smallint NOT NULL,
    status smallint NOT NULL
);

ALTER TABLE public.cc_crun_session OWNER TO hinemos;


CREATE TABLE cc_crun_session_detail (
    session_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    facility_name character varying(256),
    message text,
    error_message text,
    status smallint NOT NULL,
    end_status smallint,
    end_value smallint
);

ALTER TABLE public.cc_crun_session_detail OWNER TO hinemos;


CREATE TABLE cc_crun_session_param (
    session_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_value character varying(4096)
);

ALTER TABLE public.cc_crun_session_param OWNER TO hinemos;


CREATE TABLE cc_crun_type_mst (
    type_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_crun_type_mst OWNER TO hinemos;


CREATE TABLE cc_event_log (
    monitor_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    generation_date timestamp without time zone NOT NULL,
    facility_id character varying(64) NOT NULL,
    scope_text character varying(256) NOT NULL,
    application character varying(64) NOT NULL,
    message_id character varying(64) NOT NULL,
    message character varying(256) NOT NULL,
    message_org text,
    priority smallint NOT NULL,
    confirm_flg smallint NOT NULL,
    confirm_date timestamp without time zone,
    confirm_user character varying(64),
    duplication_count bigint NOT NULL,
    output_date timestamp without time zone NOT NULL,
    inhibited_flg smallint NOT NULL
);

ALTER TABLE public.cc_event_log OWNER TO hinemos;


CREATE TABLE cc_event_multi_info (
    monitor_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    output_date timestamp without time zone NOT NULL,
    multi_id character varying(64) NOT NULL,
    duplication_count smallint NOT NULL
);

ALTER TABLE public.cc_event_multi_info OWNER TO hinemos;


CREATE TABLE cc_job_command_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    start_command character varying(1024),
    stop_command character varying(1024),
    effective_user character varying(64),
    error_end_flg smallint NOT NULL,
    error_end_value smallint NOT NULL,
    argument_job_id character varying(64),
    argument character varying(1024)
);

ALTER TABLE public.cc_job_command_info OWNER TO hinemos;


CREATE TABLE cc_job_command_mst (
    job_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    start_command character varying(1024),
    stop_command character varying(1024),
    effective_user character varying(64),
    error_end_flg smallint NOT NULL,
    error_end_value smallint NOT NULL,
    argument_job_id character varying(64),
    argument character varying(1024)
);

ALTER TABLE public.cc_job_command_mst OWNER TO hinemos;


CREATE TABLE cc_job_end_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    end_status smallint NOT NULL,
    end_value smallint NOT NULL,
    end_value_from smallint NOT NULL,
    end_value_to smallint NOT NULL
);

ALTER TABLE public.cc_job_end_info OWNER TO hinemos;


CREATE TABLE cc_job_end_mst (
    job_id character varying(64) NOT NULL,
    end_status smallint NOT NULL,
    end_value smallint NOT NULL,
    end_value_from smallint NOT NULL,
    end_value_to smallint NOT NULL
);

ALTER TABLE public.cc_job_end_mst OWNER TO hinemos;


CREATE TABLE cc_job_file_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    src_facility_id character varying(64) NOT NULL,
    dest_facility_id character varying(64) NOT NULL,
    src_file character varying(4096) NOT NULL,
    src_work_dir character varying(4096) NOT NULL,
    dest_directory character varying(4096) NOT NULL,
    dest_work_dir character varying(4096) NOT NULL,
    compression_flg smallint NOT NULL,
    check_flg smallint NOT NULL,
    effective_user character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_file_info OWNER TO hinemos;


CREATE TABLE cc_job_file_mst (
    job_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    src_facility_id character varying(64) NOT NULL,
    dest_facility_id character varying(64) NOT NULL,
    src_file character varying(4096) NOT NULL,
    src_work_dir character varying(4096) NOT NULL,
    dest_directory character varying(4096) NOT NULL,
    dest_work_dir character varying(4096) NOT NULL,
    compression_flg smallint NOT NULL,
    check_flg smallint NOT NULL,
    effective_user character varying(64) NOT NULL
);

ALTER TABLE public.cc_job_file_mst OWNER TO hinemos;


CREATE TABLE cc_job_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    job_name character varying(64) NOT NULL,
    description character varying(256) NOT NULL,
    job_type smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_job_info OWNER TO hinemos;


CREATE TABLE cc_job_mst (
    job_id character varying(64) NOT NULL,
    job_name character varying(64) NOT NULL,
    description character varying(256) NOT NULL,
    job_type smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);

ALTER TABLE public.cc_job_mst OWNER TO hinemos;


CREATE TABLE cc_job_notice_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    notice_type smallint NOT NULL,
    priority smallint NOT NULL,
    notify_group_id character varying(1024)
);


ALTER TABLE public.cc_job_notice_info OWNER TO hinemos;


CREATE TABLE cc_job_notice_mst (
    job_id character varying(64) NOT NULL,
    notice_type smallint NOT NULL,
    priority smallint NOT NULL,
    notify_group_id character varying(1024)
);


ALTER TABLE public.cc_job_notice_mst OWNER TO hinemos;


CREATE TABLE cc_job_param_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_type smallint NOT NULL,
    description character varying(256),
    value character varying(1024)
);

ALTER TABLE public.cc_job_param_info OWNER TO hinemos;


CREATE TABLE cc_job_param_mst (
    job_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_type smallint NOT NULL,
    description character varying(256),
    value character varying(1024)
);

ALTER TABLE public.cc_job_param_mst OWNER TO hinemos;


CREATE TABLE cc_job_relation_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    parent_job_id character varying(64) NOT NULL
);

ALTER TABLE public.cc_job_relation_info OWNER TO hinemos;


CREATE TABLE cc_job_relation_mst (
    job_id character varying(64) NOT NULL,
    parent_job_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_relation_mst OWNER TO hinemos;


CREATE TABLE cc_job_session (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    schedule_date timestamp without time zone,
    operation_flg smallint NOT NULL,
    trigger_type smallint NOT NULL,
    trigger_info character varying(256) NOT NULL
);


ALTER TABLE public.cc_job_session OWNER TO hinemos;


CREATE TABLE cc_job_session_job (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    scope_text character varying(256),
    status smallint NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    end_value smallint,
    end_status smallint,
    result character varying(1024),
    end_staus_check_flg smallint,
    delay_notify_flg smallint
);


ALTER TABLE public.cc_job_session_job OWNER TO hinemos;


CREATE TABLE cc_job_session_node (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    node_name character varying(256),
    status smallint NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    end_value smallint,
    message text,
    agent_check smallint,
    check_date timestamp without time zone,
    retry_count smallint,
    result character varying(1024),
    status_buffer smallint
);


ALTER TABLE public.cc_job_session_node OWNER TO hinemos;


CREATE TABLE cc_job_start_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    condition_type smallint NOT NULL,
    suspend smallint NOT NULL,
    skip smallint NOT NULL,
    skip_end_status smallint NOT NULL,
    skip_end_value smallint NOT NULL,
    unmatch_end_flg smallint NOT NULL,
    unmatch_end_status smallint NOT NULL,
    unmatch_end_value smallint NOT NULL,
    calendar smallint NOT NULL,
    calendar_id character varying(64),
    calendar_end_value smallint NOT NULL,
    start_delay smallint NOT NULL,
    start_delay_session smallint NOT NULL,
    start_delay_session_value smallint NOT NULL,
    start_delay_time smallint NOT NULL,
    start_delay_time_value time without time zone,
    start_delay_condition_type smallint NOT NULL,
    start_delay_notify smallint NOT NULL,
    start_delay_notify_priority smallint NOT NULL,
    start_delay_operation smallint NOT NULL,
    start_delay_operation_type smallint NOT NULL,
    start_delay_operation_end_value smallint NOT NULL,
    end_delay smallint NOT NULL,
    end_delay_session smallint NOT NULL,
    end_delay_session_value smallint NOT NULL,
    end_delay_job smallint NOT NULL,
    end_delay_job_value smallint NOT NULL,
    end_delay_time smallint NOT NULL,
    end_delay_time_value time without time zone,
    end_delay_condition_type smallint NOT NULL,
    end_delay_notify smallint NOT NULL,
    end_delay_notify_priority smallint NOT NULL,
    end_delay_operation smallint NOT NULL,
    end_delay_operation_type smallint NOT NULL,
    end_delay_operation_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_info OWNER TO hinemos;


CREATE TABLE cc_job_start_job_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    target_job_id character varying(64) NOT NULL,
    target_job_type smallint NOT NULL,
    target_job_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_job_info OWNER TO hinemos;


CREATE TABLE cc_job_start_job_mst (
    job_id character varying(64) NOT NULL,
    target_job_id character varying(64) NOT NULL,
    target_job_type smallint NOT NULL,
    target_job_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_job_mst OWNER TO hinemos;


CREATE TABLE cc_job_start_mst (
    job_id character varying(64) NOT NULL,
    condition_type smallint NOT NULL,
    suspend smallint NOT NULL,
    skip smallint NOT NULL,
    skip_end_status smallint NOT NULL,
    skip_end_value smallint NOT NULL,
    unmatch_end_flg smallint NOT NULL,
    unmatch_end_status smallint NOT NULL,
    unmatch_end_value smallint NOT NULL,
    calendar smallint NOT NULL,
    calendar_id character varying(64),
    calendar_end_value smallint NOT NULL,
    start_delay smallint NOT NULL,
    start_delay_session smallint NOT NULL,
    start_delay_session_value smallint NOT NULL,
    start_delay_time smallint NOT NULL,
    start_delay_time_value time without time zone,
    start_delay_condition_type smallint NOT NULL,
    start_delay_notify smallint NOT NULL,
    start_delay_notify_priority smallint NOT NULL,
    start_delay_operation smallint NOT NULL,
    start_delay_operation_type smallint NOT NULL,
    start_delay_operation_end_value smallint NOT NULL,
    end_delay smallint NOT NULL,
    end_delay_session smallint NOT NULL,
    end_delay_session_value smallint NOT NULL,
    end_delay_job smallint NOT NULL,
    end_delay_job_value smallint NOT NULL,
    end_delay_time smallint NOT NULL,
    end_delay_time_value time without time zone,
    end_delay_condition_type smallint NOT NULL,
    end_delay_notify smallint NOT NULL,
    end_delay_notify_priority smallint NOT NULL,
    end_delay_operation smallint NOT NULL,
    end_delay_operation_type smallint NOT NULL,
    end_delay_operation_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_mst OWNER TO hinemos;


CREATE TABLE cc_job_start_time_info (
    session_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    start_time time without time zone NOT NULL
);


ALTER TABLE public.cc_job_start_time_info OWNER TO hinemos;


CREATE TABLE cc_job_start_time_mst (
    job_id character varying(64) NOT NULL,
    start_time time without time zone NOT NULL
);


ALTER TABLE public.cc_job_start_time_mst OWNER TO hinemos;


CREATE TABLE cc_log_transfer_file_info (
    transfer_id character varying(64) NOT NULL,
    file_path character varying(4096) NOT NULL,
    run_interval smallint,
    existence_flg smallint,
    valid_flg smallint NOT NULL
);


ALTER TABLE public.cc_log_transfer_file_info OWNER TO hinemos;


CREATE TABLE cc_log_transfer_info (
    transfer_id character varying(64) NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    valid_flg smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_log_transfer_info OWNER TO hinemos;


CREATE TABLE cc_mail_template_info (
    mail_template_id character varying(64) NOT NULL,
    description character varying(256),
    subject character varying(256),
    body text,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_mail_template_info OWNER TO hinemos;


CREATE TABLE cc_monitor_agent_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    check_job_agent smallint,
    check_log_agent smallint
);


ALTER TABLE public.cc_monitor_agent_info OWNER TO hinemos;


CREATE TABLE cc_monitor_http_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    request_url character varying(2083) NOT NULL,
    url_replace smallint,
    proxy_set smallint,
    proxy_host character varying(64),
    proxy_port smallint,
    timeout smallint
);


ALTER TABLE public.cc_monitor_http_info OWNER TO hinemos;


CREATE TABLE cc_monitor_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    monitor_type smallint NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    run_interval smallint,
    calendar_id character varying(64),
    monitor_block smallint,
    determination_id character varying(64),
    failure_priority smallint,
    notify_group_id character varying(1024),
    application character varying(64),
    failure_message_id character varying(64),
    failure_message character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64),
    timeout smallint
);


ALTER TABLE public.cc_monitor_info OWNER TO hinemos;


CREATE TABLE cc_monitor_numeric_value_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    threshold_upper_limit double precision NOT NULL,
    threshold_lower_limit double precision NOT NULL,
    message_id character varying(64),
    message character varying(256)
);



ALTER TABLE public.cc_monitor_numeric_value_info OWNER TO hinemos;



CREATE TABLE cc_monitor_perf_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    collector_id character varying(256),
    item_code character varying(256),
    device_index bigint,
    device_name character varying(256) NOT NULL,
    display_name character varying(256)
);


ALTER TABLE public.cc_monitor_perf_info OWNER TO hinemos;


CREATE TABLE cc_monitor_ping_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    run_count smallint,
    run_interval smallint,
    timeout smallint
);


ALTER TABLE public.cc_monitor_ping_info OWNER TO hinemos;


CREATE TABLE cc_monitor_port_info(
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    port_number integer,
    run_count smallint,
    run_interval smallint,
    timeout smallint,
    service_id character varying(64)
);


ALTER TABLE public.cc_monitor_port_info OWNER TO hinemos;


CREATE TABLE cc_monitor_process_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    command character varying(256) NOT NULL,
    param character varying(256)
);


ALTER TABLE public.cc_monitor_process_info OWNER TO hinemos;


CREATE TABLE cc_monitor_protocol_mst(
    service_id character varying(64) NOT NULL,
    service_name character varying(64) NOT NULL,
    description character varying(256),
    default_port_number integer,
    class_name character varying(256)
);


ALTER TABLE public.cc_monitor_protocol_mst OWNER TO hinemos;


CREATE TABLE cc_monitor_snmp_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    community_name character varying(64) NOT NULL,
    snmp_port integer NOT NULL,
    snmp_oid character varying(1024) NOT NULL,
    snmp_version character varying(64) NOT NULL,
    convert_flg smallint NOT NULL
);


ALTER TABLE public.cc_monitor_snmp_info OWNER TO hinemos;


CREATE TABLE cc_monitor_snmp_value (
    monitor_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    value double precision NOT NULL,
    get_date timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_monitor_snmp_value OWNER TO hinemos;


CREATE TABLE cc_monitor_sql_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    connection_url character varying(256) NOT NULL,
    connection_user character varying(64) NOT NULL,
    connection_password character varying(64) NOT NULL,
    query character varying(1024) NOT NULL,
    jdbc_driver character varying(256) NOT NULL
);


ALTER TABLE public.cc_monitor_sql_info OWNER TO hinemos;


CREATE TABLE cc_monitor_string_value_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    description character varying(256),
    process_type smallint NOT NULL,
    pattern character varying(1024) NOT NULL,
    priority smallint NOT NULL,
    message_id character varying(64),
    message character varying(256),
    notify_group_id character varying(1024),
    valid_flg smallint NOT NULL
);

ALTER TABLE public.cc_monitor_string_value_info OWNER TO hinemos;


CREATE TABLE cc_monitor_truth_value_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    truth_value smallint NOT NULL,
    message_id character varying(64),
    message character varying(256)
);


ALTER TABLE public.cc_monitor_truth_value_info OWNER TO hinemos;


CREATE TABLE cc_notify_relation_info (
    notify_group_id character varying(1024) NOT NULL,
    notify_id character varying(64) NOT NULL,
    notify_type smallint,
    notify_flg smallint
);


ALTER TABLE public.cc_notify_relation_info OWNER TO hinemos;


CREATE TABLE cc_notify_event_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    event_normal_flg smallint NOT NULL,
    event_normal_state smallint NOT NULL,
    event_inhibition_flg smallint NOT NULL,
    event_inhibition_state smallint
);


ALTER TABLE public.cc_notify_event_info OWNER TO hinemos;


CREATE TABLE cc_notify_info (
    notify_id character varying(64) NOT NULL,
    description character varying(256),
    notify_type smallint,
    inhibition_flg smallint NOT NULL,
    inhibition_frequency smallint,
    inhibition_period smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64),
    valid_flg smallint
);


ALTER TABLE public.cc_notify_info OWNER TO hinemos;


CREATE TABLE cc_notify_job_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    job_run smallint NOT NULL,
    job_id character varying(64),
    job_inhibition_flg smallint NOT NULL,
    job_failure_priority smallint,
    job_exec_facility_flg smallint,
    job_exec_facility character varying(64)
);


ALTER TABLE public.cc_notify_job_info OWNER TO hinemos;


CREATE TABLE cc_notify_log_escalate_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    escalate_flg smallint NOT NULL,
    escalate_inhibition_flg smallint NOT NULL,
    escalate_message character varying(1024),
    syslog_priority smallint,
    syslog_facility smallint,
    escalate_facility_flg smallint,
    escalate_facility character varying(64),
    escalate_port integer
);


ALTER TABLE public.cc_notify_log_escalate_info OWNER TO hinemos;


CREATE TABLE cc_notify_mail_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    mail_template_id character varying(64),
    mail_flg smallint NOT NULL,
    mail_inhibition_flg smallint NOT NULL,
    mail_address character varying(1024)
);


ALTER TABLE public.cc_notify_mail_info OWNER TO hinemos;


CREATE TABLE cc_notify_status_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    status_flg smallint NOT NULL,
    status_inhibition_flg smallint NOT NULL,
    status_valid_period smallint,
    status_invalid_flg smallint,
    status_update_priority smallint
);


ALTER TABLE public.cc_notify_status_info OWNER TO hinemos;


CREATE TABLE cc_priority_info (
    judgment_id character varying(64) NOT NULL,
    description character varying(256),
    pattern_01 smallint,
    pattern_02 smallint,
    pattern_03 smallint,
    pattern_04 smallint,
    pattern_05 smallint,
    pattern_06 smallint,
    pattern_07 smallint,
    pattern_08 smallint,
    pattern_09 smallint,
    pattern_10 smallint,
    pattern_11 smallint,
    pattern_12 smallint,
    pattern_13 smallint,
    pattern_14 smallint,
    pattern_15 smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_priority_info OWNER TO hinemos;


CREATE TABLE cc_snmp_trap_info (
    monitor_id character varying(64) NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    community_name character varying(64),
    notify_group_id character varying(1024),
    application character varying(64),
    valid_flg smallint NOT NULL,
    calendar_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64),
    check_mode smallint
);


ALTER TABLE public.cc_snmp_trap_info OWNER TO hinemos;


CREATE TABLE cc_snmp_trap_notify_info (
    monitor_id character varying(64) NOT NULL,
    notify_id character varying(64) NOT NULL,
    notify_type smallint,
    notify_flg smallint
);

ALTER TABLE public.cc_snmp_trap_notify_info OWNER TO hinemos;


CREATE TABLE cc_snmp_trap_mib_mst (
    mib character varying(64) NOT NULL,
    order_no smallint,
    description character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_snmp_trap_mib_mst OWNER TO hinemos;


CREATE TABLE cc_snmp_trap_mst (
    mib character varying(1024) NOT NULL,
    trap_oid character varying(1024) NOT NULL,
    generic_id smallint NOT NULL,
    specific_id integer NOT NULL,
    uei text,
    logmsg text,
    descr text,
    priority smallint
);


ALTER TABLE public.cc_snmp_trap_mst OWNER TO hinemos;


CREATE TABLE cc_snmp_trap_oid_info (
    monitor_id character varying(64) NOT NULL,
    mib character varying(1024) NOT NULL,
    trap_oid character varying(1024) NOT NULL,
    generic_id smallint NOT NULL,
    specific_id integer NOT NULL,
    valid_flg smallint,
    priority smallint,
    logmsg text,
    descr text
);


ALTER TABLE public.cc_snmp_trap_oid_info OWNER TO hinemos;


CREATE TABLE cc_status_info (
    facility_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    application character varying(64) NOT NULL,
    message_id character varying(64) NOT NULL,
    message character varying(256) NOT NULL,
    priority smallint NOT NULL,
    generation_date timestamp without time zone NOT NULL,
    output_date timestamp without time zone NOT NULL,
    expiration_flg smallint,
    expiration_date timestamp without time zone
);


ALTER TABLE public.cc_status_info OWNER TO hinemos;


CREATE TABLE cc_syslog_monitor_rule (
    order_no smallint NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    pattern character varying(1024),
    process_type smallint NOT NULL,
    priority smallint NOT NULL,
    monitor_id character varying(64),
    application character varying(64),
    message_id character varying(64),
    message character varying(256),
    notify_group_id character varying(1024),
    calendar_id character varying(64),
    valid_flg smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_syslog_monitor_rule OWNER TO hinemos;


CREATE TABLE cc_system_notify_event_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    event_normal_flg smallint NOT NULL,
    event_normal_state smallint NOT NULL,
    event_inhibition_flg smallint NOT NULL,
    event_inhibition_state smallint,
    mail_flg smallint NOT NULL,
    mail_address character varying(1024)
);


ALTER TABLE public.cc_system_notify_event_info OWNER TO hinemos;


CREATE TABLE cc_system_notify_info (
    notify_id character varying(64) NOT NULL,
    description character varying(256),
    status_flg smallint NOT NULL,
    status_valid_period smallint,
    status_invalid_flg smallint,
    status_update_priority smallint,
    event_flg smallint NOT NULL,
    inhibition_flg smallint NOT NULL,
    inhibition_frequency smallint,
    inhibition_period smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    mail_template_id character varying(64)
);


ALTER TABLE public.cc_system_notify_info OWNER TO hinemos;





CREATE TABLE jms_message_log (
    messageid integer NOT NULL,
    destination character varying(255) NOT NULL,
    txid integer,
    txop character(1),
    lateclone character(1),
    messageblob bytea
);


ALTER TABLE public.jms_message_log OWNER TO hinemos;


CREATE TABLE jms_reference_log (
    messageid integer NOT NULL,
    destination character varying(256) NOT NULL,
    txid integer,
    txop character(1),
    redelivered character(1),
    redelivers integer
);


ALTER TABLE public.jms_reference_log OWNER TO hinemos;


CREATE TABLE jms_transaction_log (
    txid integer
);


ALTER TABLE public.jms_transaction_log OWNER TO hinemos;


CREATE TABLE qrtz_blob_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    blob_data bytea
);


ALTER TABLE public.qrtz_blob_triggers OWNER TO hinemos;


CREATE TABLE qrtz_calendars (
    calendar_name character varying(80) NOT NULL,
    calendar bytea NOT NULL
);


ALTER TABLE public.qrtz_calendars OWNER TO hinemos;


CREATE TABLE qrtz_cron_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    cron_expression character varying(80) NOT NULL,
    time_zone_id character varying(80)
);


ALTER TABLE public.qrtz_cron_triggers OWNER TO hinemos;


CREATE TABLE qrtz_fired_triggers (
    entry_id character varying(95) NOT NULL,
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    is_volatile boolean NOT NULL,
    instance_name character varying(80) NOT NULL,
    fired_time bigint NOT NULL,
    state character varying(16) NOT NULL,
    job_name character varying(80),
    job_group character varying(80),
    is_stateful boolean,
    requests_recovery boolean
);


ALTER TABLE public.qrtz_fired_triggers OWNER TO hinemos;


CREATE TABLE qrtz_job_details (
    job_name character varying(80) NOT NULL,
    job_group character varying(80) NOT NULL,
    description character varying(120),
    job_class_name character varying(128) NOT NULL,
    is_durable boolean NOT NULL,
    is_volatile boolean NOT NULL,
    is_stateful boolean NOT NULL,
    requests_recovery boolean NOT NULL,
    job_data bytea
);


ALTER TABLE public.qrtz_job_details OWNER TO hinemos;


CREATE TABLE qrtz_job_listeners (
    job_name character varying(80) NOT NULL,
    job_group character varying(80) NOT NULL,
    job_listener character varying(80) NOT NULL
);


ALTER TABLE public.qrtz_job_listeners OWNER TO hinemos;


CREATE TABLE qrtz_locks (
    lock_name character varying(40) NOT NULL
);


ALTER TABLE public.qrtz_locks OWNER TO hinemos;


CREATE TABLE qrtz_paused_trigger_grps (
    trigger_group character varying(80) NOT NULL
);


ALTER TABLE public.qrtz_paused_trigger_grps OWNER TO hinemos;


CREATE TABLE qrtz_scheduler_state (
    instance_name character varying(80) NOT NULL,
    last_checkin_time bigint NOT NULL,
    checkin_interval bigint NOT NULL,
    recoverer character varying(80)
);


ALTER TABLE public.qrtz_scheduler_state OWNER TO hinemos;


CREATE TABLE qrtz_simple_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    repeat_count bigint NOT NULL,
    repeat_interval bigint NOT NULL,
    times_triggered bigint NOT NULL
);


ALTER TABLE public.qrtz_simple_triggers OWNER TO hinemos;


CREATE TABLE qrtz_trigger_listeners (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    trigger_listener character varying(80) NOT NULL
);


ALTER TABLE public.qrtz_trigger_listeners OWNER TO hinemos;


CREATE TABLE qrtz_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    job_name character varying(80) NOT NULL,
    job_group character varying(80) NOT NULL,
    is_volatile boolean NOT NULL,
    description character varying(120),
    next_fire_time bigint,
    prev_fire_time bigint,
    trigger_state character varying(16) NOT NULL,
    trigger_type character varying(8) NOT NULL,
    start_time bigint NOT NULL,
    end_time bigint,
    calendar_name character varying(80),
    misfire_instr smallint
);


ALTER TABLE public.qrtz_triggers OWNER TO hinemos;


CREATE TABLE maintenance_type_mst (
    type_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    order_no smallint NOT NULL
);

ALTER TABLE public.maintenance_type_mst OWNER TO hinemos;

ALTER TABLE ONLY maintenance_type_mst
    ADD CONSTRAINT p_key_maintenance_type_mst PRIMARY KEY (type_id);


CREATE TABLE maintenance_keep_mst (
    keep_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    order_no smallint NOT NULL
);

ALTER TABLE public.maintenance_keep_mst OWNER TO hinemos;


ALTER TABLE ONLY maintenance_keep_mst
    ADD CONSTRAINT p_key_maintenance_keep_mst PRIMARY KEY (keep_id);


CREATE TABLE maintenance_info (

    maintenance_id character varying(64) NOT NULL,
    description character varying(256),
	type_id character varying(64) NOT NULL,
	keep_id character varying(64),
    calendar_id character varying(64),
    schedule_date timestamp without time zone,
    notify_group_id character varying(1024),
    application character varying(64),
    valid_flg smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(256),
    update_user character varying(256)
    
);


ALTER TABLE public.maintenance_info OWNER TO hinemos;


ALTER TABLE ONLY maintenance_info
    ADD CONSTRAINT p_key_maintenance_info PRIMARY KEY (maintenance_id);
    

ALTER TABLE ONLY maintenance_info
    ADD CONSTRAINT ref_maintenance_type_mst FOREIGN KEY (type_id) REFERENCES maintenance_type_mst(type_id);






CREATE TABLE cc_calculated_data (
	collectorid character varying(256) NOT NULL,
    item_code character varying(64) NOT NULL,
	display_name character varying(256) NOT NULL,
	date_time timestamp without time zone NOT NULL,
	facilityid character varying(64) NOT NULL,
	value double precision
);

ALTER TABLE public.cc_calculated_data OWNER TO hinemos;

CREATE TABLE cc_collector_calc_method_mst (
	calc_method character varying(256) NOT NULL,
	class_name character varying(256),
	expression text
);

ALTER TABLE public.cc_collector_calc_method_mst OWNER TO hinemos;

CREATE TABLE cc_collector_category_mst (
	category_code character varying(64) NOT NULL,
	category_name character varying(256)
);

ALTER TABLE public.cc_collector_category_mst OWNER TO hinemos;

CREATE TABLE cc_collector_device_info (
	collectorid character varying(256) NOT NULL,
	facilityid character varying(64) NOT NULL,
	display_name character varying(256) NOT NULL,
	device_name character varying(256) NOT NULL,
	index bigint,
	device_id character varying(64),
	device_type character varying(256)
);

ALTER TABLE public.cc_collector_device_info OWNER TO hinemos;

CREATE TABLE cc_collector_item (
	collectorid character varying(256) NOT NULL,
	item_code character varying(64) NOT NULL,
	display_name character varying(256) NOT NULL
);

ALTER TABLE public.cc_collector_item OWNER TO hinemos;

CREATE TABLE cc_collector_item_calc_method_mst (
	collect_method character varying(64) NOT NULL,
	platform_id character varying(64) NOT NULL,
	sub_platform_id character varying(64) NOT NULL,
	item_code character varying(64) NOT NULL,
	calc_method character varying(256) NOT NULL
);

ALTER TABLE public.cc_collector_item_calc_method_mst OWNER TO hinemos;

CREATE TABLE cc_monitor_process_method_mst (
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    collect_method character varying(64) NOT NULL
    
);

ALTER TABLE public.cc_monitor_process_method_mst OWNER TO hinemos;

CREATE TABLE cc_collector_item_code_mst (
	item_code character varying(64) NOT NULL,
	category_code character varying(64) NOT NULL,
	parent_item_code character varying(256),
	item_name character varying(256) NOT NULL,
	measure character varying(64),
	device_support smallint NOT NULL,
	device_type character varying(64),
	graph_range smallint NOT NULL
);

ALTER TABLE public.cc_collector_item_code_mst OWNER TO hinemos;

CREATE TABLE cc_collector_platform_mst (
    platform_id character varying(64) NOT NULL,
    platform_name character varying(256) NOT NULL,
    order_no smallint NOT NULL
);

ALTER TABLE public.cc_collector_platform_mst OWNER TO hinemos;

CREATE TABLE cc_collector_profile (
	collectorid character varying(256) NOT NULL,
	collector_type smallint,
	label character varying(1024),
	scheduled_start_date timestamp without time zone,
	scheduled_stop_date timestamp without time zone,
	start_date timestamp without time zone,
	stop_date timestamp without time zone,
	target_facilityid character varying(64),
	scope_path character varying(1024),
	interval_sec integer,
	period_min integer,
	presave_period integer
);

ALTER TABLE public.cc_collector_profile OWNER TO hinemos;

CREATE TABLE cc_collector_scope_relation (
	collectorid character varying(256) NOT NULL,
	facilityid character varying(64) NOT NULL,
	parent_facilityid character varying(64) NOT NULL
);

ALTER TABLE public.cc_collector_scope_relation OWNER TO hinemos;

CREATE TABLE cc_collector_scope_snap (
	collectorid character varying(256) NOT NULL,
	facilityid character varying(64) NOT NULL,
	platform_id character varying(64) NOT NULL,
	sub_platform_id character varying(64) NOT NULL,
	facility_name character varying(256),
	facility_type character varying(16)
);

ALTER TABLE public.cc_collector_scope_snap OWNER TO hinemos;

CREATE TABLE cc_collector_polling_mst (
	collect_method character varying(64) NOT NULL,
	platform_id character varying(64) NOT NULL,
	sub_platform_id character varying(64) NOT NULL,
	item_code character varying(64) NOT NULL,
	variable_id character varying (64) NOT NULL,
	entry_key character varying(1024) NOT NULL,
	value_type character varying(64) NOT NULL,
	polling_target character varying(1024) NOT NULL,
	failure_value character varying(256)
);

ALTER TABLE public.cc_collector_polling_mst OWNER TO hinemos;

CREATE TABLE cc_monitor_process_polling_mst (
	collect_method character varying(64) NOT NULL,
	platform_id character varying(64) NOT NULL,
	sub_platform_id character varying(64) NOT NULL,
	variable_id character varying (64) NOT NULL,
	entry_key character varying(1024) NOT NULL,
	polling_target character varying(1024) NOT NULL
);

ALTER TABLE public.cc_monitor_process_polling_mst OWNER TO hinemos;

CREATE TABLE cc_collector_status (
	collectorid character varying(256) NOT NULL,
	run_status smallint,
	error_status smallint,
	end_status smallint,
	count bigint,
	last_collect_date timestamp without time zone
) WITH (FILLFACTOR = 90);

ALTER TABLE public.cc_collector_status OWNER TO hinemos;

CREATE TABLE cc_device_type_mst (
	device_type character varying(64) NOT NULL,
	device_type_name character varying(256)
);

ALTER TABLE public.cc_device_type_mst OWNER TO hinemos;


CREATE TABLE cc_snmp_value_type_mst (
	value_type character varying(64) NOT NULL
);

ALTER TABLE public.cc_snmp_value_type_mst OWNER TO hinemos;



CREATE TABLE cc_vm_solution_mst (
    vm_solution_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    platform_id character varying(64) NOT NULL,
    vm_solution_name character varying(256) NOT NULL
);

ALTER TABLE public.cc_vm_solution_mst OWNER TO hinemos;


CREATE TABLE cc_vm_method_mst (
    vm_solution_id character varying(64) NOT NULL,
    proc_type character varying(64) NOT NULL,
    class_name character varying(256) NOT NULL
);


ALTER TABLE public.cc_vm_method_mst OWNER TO hinemos;


CREATE TABLE cc_vm_protocol_mst (
    vm_solution_id character varying(64) NOT NULL,
    protocol character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_vm_protocol_mst OWNER TO hinemos;


CREATE TABLE cc_vm_operation_detail (
    session_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    scope_text character varying(256),
    node_type character varying(64),
    command_id character varying(64),
    status smallint,
    start_date timestamp without time zone,
    end_status smallint,
    end_date timestamp without time zone,
    end_value integer,
    message text
);


ALTER TABLE public.cc_vm_operation_detail OWNER TO hinemos;


CREATE TABLE cc_collector_category_collect_mst (
	platform_id character varying(64) NOT NULL,
	sub_platform_id character varying(64) NOT NULL,
	category_code character varying(64) NOT NULL,
	collect_method character varying(64) NOT NULL
);

ALTER TABLE public.cc_collector_category_collect_mst OWNER TO hinemos;





---------------------------------------------------------------
-- MASTER DATA : COPY FROM STDIN 
---------------------------------------------------------------

COPY cc_acc_lock (lock_id) FROM stdin;
REPOSITORY
JOB
CRUN
MONITOR
MONITOR_SQL
MONITOR_PROCESS
MONITOR_PING
MONITOR_SNMP
MONITOR_AGENT
MONITOR_SYSLOG
ACCESS
CALENDER
NOTIFY
PERFORMANCE
PRIORITY_JUDGMENT
LOG_TRANSFER
MONITOR_SNMPTRAP
MAINTENANCE
\.



COPY cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) FROM stdin;
ADD_USER	USER	0	add.user	1	/opt/hinemos/lib/cr/useradd.sh
DELETE_USER	USER	2	delete.user	0	/usr/sbin/userdel -r
MODIFY_USER	USER	1	modify.user	1	/opt/hinemos/lib/cr/usermod.sh
REBOOT_LINUX	START_STOP	0	reboot.linux	0	/sbin/reboot
SHUTDOWN_LINUX	START_STOP	1	shutdown.linux	0	/sbin/poweroff
START_APACHE	START_STOP	2	start.apache	0	/etc/init.d/httpd start
STOP_APACHE	START_STOP	3	stop.apache	0	/etc/init.d/httpd stop
COPY_FILE	FILE	0	copy.file	1	/opt/hinemos/lib/cr/cp.sh
MAKE_DIRECTORY	FILE	1	make.directory	1	/opt/hinemos/lib/cr/mkdir.sh
REMOVE_FILE	FILE	2	remove.file.directory	1	/opt/hinemos/lib/cr/rm.sh
RPM_INSTALL	INSTALL	0	rpm.installation	1	/opt/hinemos/lib/cr/rpminstall.sh
AGENT_INSTALL	AGENT	0	agent.installation	1	/opt/hinemos/lib/cr/agent_install.sh
FILEJOB_SETTING	AGENT	1	setting.file.transfer	1	/opt/hinemos/lib/cr/file_transfer_setting.sh
\.



COPY cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) FROM stdin;
ADD_USER	UID	0	-u
ADD_USER	PASSWORD	2	-p
ADD_USER	GROUP_NAME	3	-g
ADD_USER	SECONDARY_GROUP_NAME	4	-G
ADD_USER	LOGIN_SHELL	5	-s
ADD_USER	HOME_DIRECTORY	6	-d
ADD_USER	USER_NAME	1	\N
MODIFY_USER	PASSWORD	1	-p
MODIFY_USER	USER_NAME	0	\N
MODIFY_USER	LOGIN_SHELL	4	-s
MODIFY_USER	GROUP_NAME	2	-g
MODIFY_USER	SECONDARY_GROUP_NAME	3	-G
DELETE_USER	USER_NAME	0	\N
RPM_INSTALL	FILE	0	\N
COPY_FILE	SOURCE_FILE	0	\N
COPY_FILE	DESTINATION	1	-d
COPY_FILE	FILE_PERMISSION	4	-m
COPY_FILE	GROUP_NAME	3	-g
COPY_FILE	USER_NAME	2	-u
REMOVE_FILE	FILE_DIRECTORY	0	\N
REMOVE_FILE	USER_NAME	1	-u
MAKE_DIRECTORY	DIRECTORY_NAME	0	\N
MAKE_DIRECTORY	USER_NAME	1	-u
MAKE_DIRECTORY	GROUP_NAME	2	-g
MAKE_DIRECTORY	DIRECTORY_PERMISSION	3	-m
AGENT_INSTALL	JRE_LICENSE	6	-j
AGENT_INSTALL	AGENT_PLACE	5	-w
AGENT_INSTALL	AGENT_PATH	4	-a
AGENT_INSTALL	MANAGER_ROOT_PASSWORD	3	-p
AGENT_INSTALL	MANAGER_ADDRESS	1	-m
AGENT_INSTALL	MANAGER_IP	2	-i
FILEJOB_SETTING	TRANSFER_IP	0	-i
FILEJOB_SETTING	ROOT_PASSWORD	1	-r
FILEJOB_SETTING	FILE_TRANSFER_USER	2	-u
FILEJOB_SETTING	TRANSFER_PASSWORD	3	-p
\.


COPY cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) FROM stdin;
COPY_FILE	0	0	0
COPY_FILE	1	1	9
REMOVE_FILE	0	0	0
MAKE_DIRECTORY	0	0	0
MAKE_DIRECTORY	1	1	9
RPM_INSTALL	0	0	0
REBOOT_LINUX	0	0	0
SHUTDOWN_LINUX	0	0	0
START_APACHE	0	0	0
STOP_APACHE	0	0	0
ADD_USER	0	0	0
ADD_USER	1	1	2
MODIFY_USER	0	0	0
MODIFY_USER	1	1	2
DELETE_USER	0	0	0
RPM_INSTALL	1	1	9
AGENT_INSTALL	0	0	0
AGENT_INSTALL	1	1	9
FILEJOB_SETTING	0	0	0
FILEJOB_SETTING	1	1	9
\.


COPY cc_crun_param_mst (param_id, name_id, param_type) FROM stdin;
SOURCE_FILE	source.file	0
USER_NAME	user.name	0
GROUP_NAME	group.name	0
DIRECTORY_NAME	directory.name	0
FILE	file	0
FILE_DIRECTORY	file.directory	0
DESTINATION	destination	0
DIRECTORY_PERMISSION	file.access.permission	2
FILE_PERMISSION	file.access.permission	2
UID	uid	0
PASSWORD	password	1
SECONDARY_GROUP_NAME	secondary.group.name	0
LOGIN_SHELL	login.shell	2
HOME_DIRECTORY	home.directory	0
MANAGER_IP	manager.ip.address	0
MANAGER_ROOT_PASSWORD	manager.root.password	1
AGENT_PATH	agent.path	0
AGENT_PLACE	agent.place	0
JRE_LICENSE	jre.license	2
COLLECTIVERUN_MEAN	collectiverun.mean	2
TRANSFER_IP	transfer.ip.address	0
ROOT_PASSWORD	transfer.root.password	1
FILE_TRANSFER_USER	file.transfer.user	0
TRANSFER_PASSWORD	file.transfer.password	1
MANAGER_ADDRESS	manager.hinemos.address	0
\.


COPY cc_crun_param_select_mst (param_id, order_no, name_id, param_value) FROM stdin;
LOGIN_SHELL	0	/bin/sh	/bin/sh
LOGIN_SHELL	1	/bin/bash	/bin/bash
LOGIN_SHELL	2	/bin/ksh	/bin/ksh
LOGIN_SHELL	3	/bin/tcsh	/bin/tcsh
LOGIN_SHELL	4	/bin/csh	/bin/csh
DIRECTORY_PERMISSION	0	rwx------	700
DIRECTORY_PERMISSION	1	rwxrwx---	770
DIRECTORY_PERMISSION	2	rwxr-x---	750
DIRECTORY_PERMISSION	3	rwxr-xr-x	755
DIRECTORY_PERMISSION	4	r-x------	500
DIRECTORY_PERMISSION	5	r-xr-x---	550
DIRECTORY_PERMISSION	6	r-xr-xr-x	555
FILE_PERMISSION	0	rwx------	700
FILE_PERMISSION	1	rwxrwx---	770
FILE_PERMISSION	2	rwxr-x---	750
FILE_PERMISSION	3	rwxr-xr-x	755
FILE_PERMISSION	4	rw-------	600
FILE_PERMISSION	5	rw-rw----	660
FILE_PERMISSION	6	rw-r-----	640
FILE_PERMISSION	7	rw-r--r--	644
FILE_PERMISSION	8	r--------	400
FILE_PERMISSION	9	r--r-----	440
FILE_PERMISSION	10	r--r--r--	444
JRE_LICENSE	0	YES	yes
JRE_LICENSE	1	NO	no
\.



COPY cc_crun_type_mst (type_id, name_id, order_no) FROM stdin;
FILE	filesystem.management	0
INSTALL	installation.management	1
START_STOP	start.stop.management	2
USER	user.management	3
AGENT	agent.management	4
\.



COPY cc_monitor_protocol_mst (service_id , service_name, description, default_port_number, class_name) FROM stdin;
001	TCP	TCP connection establishment(3-way handshake)	\N	com.clustercontrol.port.util.ReachAddressTCP
\.



COPY cc_priority_info (judgment_id, description, pattern_01, pattern_02, pattern_03, pattern_04, pattern_05, pattern_06, pattern_07, pattern_08, pattern_09, pattern_10, pattern_11, pattern_12, pattern_13, pattern_14, pattern_15, reg_date, update_date, reg_user, update_user) FROM stdin;
DEFAULT	\N	3	1	2	1	2	1	0	0	0	0	0	0	0	0	1	\N	2006-06-07 14:58:31.156	\N	hinemos
\.



COPY qrtz_cron_triggers (trigger_name, trigger_group, cron_expression, time_zone_id) FROM stdin;
CollectorRunController	PERF_COLLECT	42 7 5 * * ? *	Asia/Tokyo
JobRunManagement	JOB_MANAGEMENT	0 */1 * * * ? *	Asia/Tokyo
CollectiveRunController	CRUN_MANAGEMENT	*/30 * * * * ? *	Asia/Tokyo
MonitorController	MON	0 */5 * * * ? *	Asia/Tokyo
\.


COPY qrtz_job_details (job_name, job_group, description, job_class_name, is_durable, is_volatile, is_stateful, requests_recovery, job_data) FROM stdin;
MonitorController	MON	\N	org.quartz.jobs.ee.ejb.EJBInvokerJob	t	f	f	f	\\254\\355\\000\\005sr\\000\\025org.quartz.JobDataMap\\237\\260\\203\\350\\277\\251\\260\\313\\002\\000\\001Z\\000\\023allowsTransientDataxr\\000\\035org.quartz.utils.DirtyFlagMap\\023\\346.\\255(v\\012\\316\\002\\000\\002Z\\000\\005dirtyL\\000\\003mapt\\000\\017Ljava/util/Map;xp\\001sr\\000\\021java.util.HashMap\\005\\007\\332\\301\\303\\026`\\321\\003\\000\\002F\\000\\012loadFactorI\\000\\011thresholdxp?@\\000\\000\\000\\000\\000\\014w\\010\\000\\000\\000\\020\\000\\000\\000\\002t\\000\\003ejbt\\000\\021MonitorControllert\\000\\006methodt\\000\\014manageStatusx\\000
CollectiveRunController	CRUN_MANAGEMENT	\N	org.quartz.jobs.ee.ejb.EJBInvokerJob	t	f	f	f	\\254\\355\\000\\005sr\\000\\025org.quartz.JobDataMap\\237\\260\\203\\350\\277\\251\\260\\313\\002\\000\\001Z\\000\\023allowsTransientDataxr\\000\\035org.quartz.utils.DirtyFlagMap\\023\\346.\\255(v\\012\\316\\002\\000\\002Z\\000\\005dirtyL\\000\\003mapt\\000\\017Ljava/util/Map;xp\\001sr\\000\\021java.util.HashMap\\005\\007\\332\\301\\303\\026`\\321\\003\\000\\002F\\000\\012loadFactorI\\000\\011thresholdxp?@\\000\\000\\000\\000\\000\\014w\\010\\000\\000\\000\\020\\000\\000\\000\\003t\\000\\003ejbt\\000\\027CollectiveRunControllert\\000\\004argsur\\000\\023[Ljava.lang.Object;\\220\\316X\\237\\020s)l\\002\\000\\000xp\\000\\000\\000\\000t\\000\\006methodt\\000\\017checkEndSessionx\\000
JobRunManagement	JOB_MANAGEMENT	\N	org.quartz.jobs.ee.ejb.EJBInvokerJob	t	f	f	f	\\254\\355\\000\\005sr\\000\\025org.quartz.JobDataMap\\237\\260\\203\\350\\277\\251\\260\\313\\002\\000\\001Z\\000\\023allowsTransientDataxr\\000\\035org.quartz.utils.DirtyFlagMap\\023\\346.\\255(v\\012\\316\\002\\000\\002Z\\000\\005dirtyL\\000\\003mapt\\000\\017Ljava/util/Map;xp\\001sr\\000\\021java.util.HashMap\\005\\007\\332\\301\\303\\026`\\321\\003\\000\\002F\\000\\012loadFactorI\\000\\011thresholdxp?@\\000\\000\\000\\000\\000\\014w\\010\\000\\000\\000\\020\\000\\000\\000\\003t\\000\\003ejbt\\000\\020JobRunManagementt\\000\\004argsur\\000\\023[Ljava.lang.Object;\\220\\316X\\237\\020s)l\\002\\000\\000xp\\000\\000\\000\\000t\\000\\006methodt\\000\\003runx\\000
CollectorRunController	PERF_COLLECT	\N	org.quartz.jobs.ee.ejb.EJBInvokerJob	t	f	f	f	\\254\\355\\000\\005sr\\000\\025org.quartz.JobDataMap\\237\\260\\203\\350\\277\\251\\260\\313\\002\\000\\001Z\\000\\023allowsTransientDataxr\\000\\035org.quartz.utils.DirtyFlagMap\\023\\346.\\255(v\\012\\316\\002\\000\\002Z\\000\\005dirtyL\\000\\003mapt\\000\\017Ljava/util/Map;xp\\001sr\\000\\021java.util.HashMap\\005\\007\\332\\301\\303\\026`\\321\\003\\000\\002F\\000\\012loadFactorI\\000\\011thresholdxp?@\\000\\000\\000\\000\\000\\014w\\010\\000\\000\\000\\020\\000\\000\\000\\002t\\000\\003ejbt\\000\\026CollectorRunControllert\\000\\006methodt\\000\\023managePresavePeriodx\\000
\.


COPY qrtz_locks (lock_name) FROM stdin;
TRIGGER_ACCESS
JOB_ACCESS
CALENDAR_ACCESS
STATE_ACCESS
MISFIRE_ACCESS
\.


COPY qrtz_scheduler_state (instance_name, last_checkin_time, checkin_interval, recoverer) FROM stdin;
NON_CLUSTERED	1141382690372	20000	\N
\.


COPY qrtz_triggers (trigger_name, trigger_group, job_name, job_group, is_volatile, description, next_fire_time, prev_fire_time, trigger_state, trigger_type, start_time, end_time, calendar_name, misfire_instr) FROM stdin;
CollectiveRunController	CRUN_MANAGEMENT	CollectiveRunController	CRUN_MANAGEMENT	f	\N	1156219530000	1156219500000	WAITING	CRON	0	0	\N	0
JobRunManagement	JOB_MANAGEMENT	JobRunManagement	JOB_MANAGEMENT	f	\N	1156219560000	1156219500000	WAITING	CRON	0	0	\N	0
MonitorController	MON	MonitorController	MON	f	\N	1156219800000	1156219500000	WAITING	CRON	0	0	\N	0
CollectorRunController	PERF_COLLECT	CollectorRunController	PERF_COLLECT	f	\N	1157343007000	1157342407000	WAITING	CRON	0	0	\N	0
\.


COPY maintenance_type_mst (type_id, name_id, order_no) FROM stdin;
DELETE_EVENT_LOG	maintenance.delete_event_log	0
DELETE_JOB_HISTORY	maintenance.delete_job_history	1
DELETE_CRUN_HISTORY	maintenance.delete_crun_history	2
\.



COPY maintenance_keep_mst (keep_id, name_id, order_no) FROM stdin;
ONE_WEEK	maintenance.keep.one_week	1
TWO_WEEKS	maintenance.keep.two_weeks	2
ONE_MONTH	maintenance.keep.one_month	3
TWO_MONTHS	maintenance.keep.two_months	4
THREE_MONTHS	maintenance.keep.three_months	5
SIX_MONTHS	maintenance.keep.six_months	6
ONE_YEAR	maintenance.keep.one_year	7
\.



COPY cc_collector_platform_mst (platform_id, platform_name, order_no) FROM stdin;
LINUX	Linux	0
SOLARIS	Solaris	10
WINDOWS	Windows	20
NW_EQUIPMENT	Network Equipment	100
OTHER	Other	1000
VMWARE	VMWare	110
\.


COPY cc_device_type_mst (device_type, device_type_name) FROM stdin;
disk	Disk
nic	Network Interface Card
filesystem	File System
\.

COPY cc_snmp_value_type_mst (value_type) FROM stdin;
Integer32
Counter32
Gauge32
TimeTicks
Counter64
String
Uint64
Uint16
Uint8
\.

COPY cc_collector_calc_method_mst (calc_method, class_name, expression) FROM stdin;
DividedBy100	com.clustercontrol.performance.operator.DividedBy100	
DividedBy1000	com.clustercontrol.performance.operator.DividedBy1000	
InvPercentage	com.clustercontrol.performance.operator.InvPercentage	
InvPercentage12	com.clustercontrol.performance.operator.InvPercentage12	
InvPercentage22	com.clustercontrol.performance.operator.InvPercentage22	
InvPercentage31	com.clustercontrol.performance.operator.InvPercentage31	
InvPercentageOfTotal	com.clustercontrol.performance.operator.InvPercentageOfTotal	
InvTimeMeanPercentage	com.clustercontrol.performance.operator.InvTimeMeanPercentage	
Non	com.clustercontrol.performance.operator.Non	
Percentage	com.clustercontrol.performance.operator.Percentage	
PercentageDiff	com.clustercontrol.performance.operator.PercentageDiff	
PercentageDiffAdd	com.clustercontrol.performance.operator.PercentageDiffAdd	
PercentageOfTotal	com.clustercontrol.performance.operator.PercentageOfTotal	
Sum	com.clustercontrol.performance.operator.Sum	
SumPerTotal	com.clustercontrol.performance.operator.SumPerTotal	
TimeMean	com.clustercontrol.performance.operator.TimeMean	
TimeMeanKbyte	com.clustercontrol.performance.operator.TimeMeanKbyte	
TimeMeanKbyteDiff	com.clustercontrol.performance.operator.TimeMeanKbyteDiff	
TimeMeanPerSec	com.clustercontrol.performance.operator.TimeMeanPerSec	
TimeMeanPerTotal	com.clustercontrol.performance.operator.TimeMeanPerTotal	
TimeMeanSum	com.clustercontrol.performance.operator.TimeMeanSum	
\.

COPY cc_collector_category_mst (category_code, category_name) FROM stdin;
C000_CPU	CPU
C001_MEM	メモリ
C002_DSK	ディスク
C003_NET	ネットワーク
C004_FS	ファイルシステム
\.

COPY cc_collector_item_code_mst (item_code, category_code, parent_item_code, item_name, measure, device_support, device_type, graph_range) FROM stdin;
CPU0100_CPU_UTIL	C000_CPU	\N	CPU使用率	%	0		1
CPU0101_CPU_UTIL_USR	C000_CPU	CPU0100_CPU_UTIL	CPU使用率(ユーザ)	%	0		1
CPU0102_CPU_UTIL_SYS	C000_CPU	CPU0100_CPU_UTIL	CPU使用率(システム)	%	0		1
CPU0103_CPU_UTIL_NCE	C000_CPU	CPU0100_CPU_UTIL	CPU使用率(Niceプロセス)	%	0		1
CPU0104_CPU_UTIL_IOW	C000_CPU	CPU0100_CPU_UTIL	CPU使用率(入出力待機)	%	0		1
CPU0200_INTERRUPT_RATE	C000_CPU	\N	インタラプトレート	回/s	0		0
CPU0300_CONTEXT_SWITCH	C000_CPU	\N	コンテキストスイッチ	回/s	0		0
CPU0400_LOAD_AVE_1M	C000_CPU	\N	ロードアベレージ1分平均	個/s	0		0
CPU0500_LOAD_AVE_5M	C000_CPU	\N	ロードアベレージ5分平均	個/s	0		0
CPU0600_LOAD_AVE_15M	C000_CPU	\N	ロードアベレージ15分平均	個/s	0		0
CPU0700_CPU_MHZ	C000_CPU	\N	CPU使用量	Mhz	0		0
CPU0800_CPU_READY	C000_CPU	\N	CPU不足量	msec	0		0
MEM0100_MEM_UTIL	C001_MEM	\N	メモリ使用率	%	0		1
MEM0101_MEM_UTIL_SWAP	C001_MEM	MEM0100_MEM_UTIL	メモリ使用率(スワップ)	%	0		1
MEM0102_MEM_UTIL_PHYS	C001_MEM	MEM0100_MEM_UTIL	メモリ使用率(実メモリ)	%	0		1
MEM0200_SWAP_SPACE	C001_MEM	\N	スワップ領域中のメモリ使用率	%	0		1
MEM0300_PHYS_UTIL	C001_MEM	\N	実メモリ中のメモリ使用率	%	0		1
MEM0301_PHYS_UTIL_USR	C001_MEM	MEM0300_PHYS_UTIL	実メモリ中のメモリ使用率(ユーザ)	%	0		1
MEM0302_PHYS_UTIL_BUF	C001_MEM	MEM0300_PHYS_UTIL	実メモリ中のメモリ使用率(バッファ)	%	0		1
MEM0303_PHYS_UTIL_CAC	C001_MEM	MEM0300_PHYS_UTIL	実メモリ中のメモリ使用率(キャッシュ)	%	0		1
MEM0400_SWAP_IO	C001_MEM	\N	スワップI/O	kB/s	0		0
MEM0401_SWAP_IO_IN	C001_MEM	MEM0400_SWAP_IO	スワップI/O(イン)	kB/s	0		0
MEM0402_SWAP_IO_OUT	C001_MEM	MEM0400_SWAP_IO	スワップI/O(アウト)	kB/s	0		0
MEM0500_MEM_MB	C001_MEM	\N	メモリ使用量	MB	0		0
DSK0100_DVC_IO_CNT	C002_DSK	\N	デバイス別ディスクI/O回数	回/s	1	disk	0
DSK0101_DVC_IO_CNT_IN	C002_DSK	DSK0100_DVC_IO_CNT	デバイス別ディスクI/O回数(読み取り)	回/s	1	disk	0
DSK0102_DVC_IO_CNT_OUT	C002_DSK	DSK0100_DVC_IO_CNT	デバイス別ディスクI/O回数(書き込み)	回/s	1	disk	0
DSK0200_DVC_IO_BYTE	C002_DSK	\N	デバイス別ディスクI/O量	byte/s	1	disk	0
DSK0201_DVC_IO_BYTE_IN	C002_DSK	DSK0200_DVC_IO_BYTE	デバイス別ディスクI/O量(読み取り)	byte/s	1	disk	0
DSK0202_DVC_IO_BYTE_OUT	C002_DSK	DSK0200_DVC_IO_BYTE	デバイス別ディスクI/O量(書き込み)	byte/s	1	disk	0
NET0100_PACKET	C003_NET	\N	パケット数合計	個/s	0		0
NET0101_PACKET_RCV	C003_NET	NET0100_PACKET	パケット数合計（受信）	個/s	0		0
NET0102_PACKET_SNT	C003_NET	NET0100_PACKET	パケット数合計（送信）	個/s	0		0
NET0300_ERR_PCK	C003_NET	\N	エラーパケット数合計	個/s	0		0
NET0301_ERR_PCK_RCV	C003_NET	NET0300_ERR_PCK	エラーパケット数合計（受信）	個/s	0		0
NET0302_ERR_PCK_SNT	C003_NET	NET0300_ERR_PCK	エラーパケット数合計（送信）	個/s	0		0
NET0200_DVC_PCK	C003_NET	\N	デバイス別パケット数	個/s	1	nic	0
NET0201_DVC_PCK_RCV	C003_NET	NET0200_DVC_PCK	デバイス別パケット数（受信）	個/s	1	nic	0
NET0202_DVC_PCK_SNT	C003_NET	NET0200_DVC_PCK	デバイス別パケット数（送信）	個/s	1	nic	0
NET0400_DVC_ERR_PCK	C003_NET	\N	デバイス別エラーパケット数	個/s	1	nic	0
NET0401_DVC_ERR_PCK_RCV	C003_NET	NET0400_DVC_ERR_PCK	デバイス別エラーパケット数（受信）	個/s	1	nic	0
NET0402_DVC_ERR_PCK_SNT	C003_NET	NET0400_DVC_ERR_PCK	デバイス別エラーパケット数（送信）	個/s	1	nic	0
NET0500_BYTE	C003_NET	\N	ネットワーク情報量	byte/s	0		0
NET0501_BYTE_RCV	C003_NET	NET0500_BYTE	ネットワーク情報量（受信）	byte/s	0		0
NET0502_BYTE_SNT	C003_NET	NET0500_BYTE	ネットワーク情報量（送信）	byte/s	0		0
NET0600_DVC_BYTE	C003_NET	\N	デバイス別ネットワーク情報量	byte/s	1	nic	0
NET0601_DVC_BYTE_RCV	C003_NET	NET0600_DVC_BYTE	デバイス別ネットワーク情報量（受信）	byte/s	1	nic	0
NET0602_DVC_BYTE_SNT	C003_NET	NET0600_DVC_BYTE	デバイス別ネットワーク情報量（送信）	byte/s	1	nic	0
FS_0100_DVC_UTIL	C004_FS	\N	ファイルシステム使用率	%	1	filesystem	1
\.

COPY cc_collector_polling_mst (collect_method, platform_id, sub_platform_id, item_code, variable_id , entry_key, polling_target, failure_value, value_type) FROM stdin;
SNMP	LINUX		CPU0100_CPU_UTIL	var0	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	LINUX		CPU0100_CPU_UTIL	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	LINUX		CPU0100_CPU_UTIL	var2	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	LINUX		CPU0100_CPU_UTIL	var3	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	LINUX		CPU0100_CPU_UTIL	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var0	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var1	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var2	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var3	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	LINUX		CPU0101_CPU_UTIL_USR	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var0	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var2	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var3	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var0	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var2	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var3	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var0	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var2	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var3	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	var4	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	LINUX		CPU0200_INTERRUPT_RATE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		CPU0200_INTERRUPT_RATE	var1	.1.3.6.1.4.1.2021.11.59.0	.1.3.6.1.4.1.2021.11.59	\N	Counter32
SNMP	LINUX		CPU0300_CONTEXT_SWITCH	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		CPU0300_CONTEXT_SWITCH	var1	.1.3.6.1.4.1.2021.11.60.0	.1.3.6.1.4.1.2021.11.60	\N	Counter32
SNMP	LINUX		CPU0400_LOAD_AVE_1M	var0	.1.3.6.1.4.1.2021.10.1.5.1	.1.3.6.1.4.1.2021.10.1.5	\N	Integer32
SNMP	LINUX		CPU0500_LOAD_AVE_5M	var0	.1.3.6.1.4.1.2021.10.1.5.2	.1.3.6.1.4.1.2021.10.1.5	\N	Integer32
SNMP	LINUX		CPU0600_LOAD_AVE_15M	var0	.1.3.6.1.4.1.2021.10.1.5.3	.1.3.6.1.4.1.2021.10.1.5	\N	Integer32
SNMP	LINUX		MEM0100_MEM_UTIL	var0	.1.3.6.1.4.1.2021.4.11.0	.1.3.6.1.4.1.2021.4.11	\N	Integer32
SNMP	LINUX		MEM0100_MEM_UTIL	var1	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	LINUX		MEM0100_MEM_UTIL	var2	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	var0	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	var2	.1.3.6.1.4.1.2021.4.4.0	.1.3.6.1.4.1.2021.4.4	\N	Integer32
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	var0	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	var1	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	var2	.1.3.6.1.4.1.2021.4.6.0	.1.3.6.1.4.1.2021.4.6	\N	Integer32
SNMP	LINUX		MEM0200_SWAP_SPACE	var0	.1.3.6.1.4.1.2021.4.4.0	.1.3.6.1.4.1.2021.4.4	\N	Integer32
SNMP	LINUX		MEM0200_SWAP_SPACE	var1	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	LINUX		MEM0300_PHYS_UTIL	var0	.1.3.6.1.4.1.2021.4.6.0	.1.3.6.1.4.1.2021.4.6	\N	Integer32
SNMP	LINUX		MEM0300_PHYS_UTIL	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var0	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var1	.1.3.6.1.4.1.2021.4.6.0	.1.3.6.1.4.1.2021.4.6	\N	Integer32
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var2	.1.3.6.1.4.1.2021.4.14.0	.1.3.6.1.4.1.2021.4.14	\N	Integer32
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	var3	.1.3.6.1.4.1.2021.4.15.0	.1.3.6.1.4.1.2021.4.15	\N	Integer32
SNMP	LINUX		MEM0302_PHYS_UTIL_BUF	var0	.1.3.6.1.4.1.2021.4.14.0	.1.3.6.1.4.1.2021.4.14	\N	Integer32
SNMP	LINUX		MEM0302_PHYS_UTIL_BUF	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	LINUX		MEM0303_PHYS_UTIL_CAC	var0	.1.3.6.1.4.1.2021.4.15.0	.1.3.6.1.4.1.2021.4.15	\N	Integer32
SNMP	LINUX		MEM0303_PHYS_UTIL_CAC	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	LINUX		MEM0400_SWAP_IO	var0	.1.3.6.1.4.1.2021.11.3.0	.1.3.6.1.4.1.2021.11.3	\N	Integer32
SNMP	LINUX		MEM0400_SWAP_IO	var1	.1.3.6.1.4.1.2021.11.4.0	.1.3.6.1.4.1.2021.11.4	\N	Integer32
SNMP	LINUX		MEM0401_SWAP_IO_IN	var0	.1.3.6.1.4.1.2021.11.3.0	.1.3.6.1.4.1.2021.11.3	\N	Integer32
SNMP	LINUX		MEM0402_SWAP_IO_OUT	var0	.1.3.6.1.4.1.2021.11.4.0	.1.3.6.1.4.1.2021.11.4	\N	Integer32
SNMP	LINUX		DSK0100_DVC_IO_CNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		DSK0100_DVC_IO_CNT	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	.1.3.6.1.4.1.2021.13.15.1.1.5	\N	Counter32
SNMP	LINUX		DSK0100_DVC_IO_CNT	var2	.1.3.6.1.4.1.2021.13.15.1.1.6.?	.1.3.6.1.4.1.2021.13.15.1.1.6	\N	Counter32
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	.1.3.6.1.4.1.2021.13.15.1.1.5	\N	Counter32
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.6.?	.1.3.6.1.4.1.2021.13.15.1.1.6	\N	Counter32
SNMP	LINUX		DSK0200_DVC_IO_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		DSK0200_DVC_IO_BYTE	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	.1.3.6.1.4.1.2021.13.15.1.1.3	\N	Counter32
SNMP	LINUX		DSK0200_DVC_IO_BYTE	var2	.1.3.6.1.4.1.2021.13.15.1.1.4.?	.1.3.6.1.4.1.2021.13.15.1.1.4	\N	Counter32
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	.1.3.6.1.4.1.2021.13.15.1.1.3	\N	Counter32
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.4.?	.1.3.6.1.4.1.2021.13.15.1.1.4	\N	Counter32
SNMP	LINUX		NET0100_PACKET	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0100_PACKET	var1	.1.3.6.1.2.1.2.2.1.11.*	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	LINUX		NET0100_PACKET	var2	.1.3.6.1.2.1.2.2.1.17.*	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	LINUX		NET0101_PACKET_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0101_PACKET_RCV	var1	.1.3.6.1.2.1.2.2.1.11.*	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	LINUX		NET0102_PACKET_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0102_PACKET_SNT	var1	.1.3.6.1.2.1.2.2.1.17.*	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	LINUX		NET0300_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0300_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.*	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	LINUX		NET0300_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.*	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	LINUX		NET0301_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0301_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.*	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	LINUX		NET0302_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0302_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.*	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	LINUX		NET0200_DVC_PCK	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0200_DVC_PCK	var1	.1.3.6.1.2.1.2.2.1.11.?	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	LINUX		NET0200_DVC_PCK	var2	.1.3.6.1.2.1.2.2.1.17.?	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	LINUX		NET0201_DVC_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0201_DVC_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.11.?	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	LINUX		NET0202_DVC_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0202_DVC_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.17.?	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	LINUX		NET0400_DVC_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0400_DVC_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.?	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	LINUX		NET0400_DVC_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.?	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.?	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.?	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	LINUX		NET0500_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0500_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.*	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	LINUX		NET0500_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.*	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	LINUX		NET0501_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0501_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.*	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	LINUX		NET0502_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0502_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.*	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	LINUX		NET0600_DVC_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0600_DVC_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.?	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	LINUX		NET0600_DVC_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.?	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	LINUX		NET0601_DVC_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0601_DVC_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.?	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	LINUX		NET0602_DVC_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	LINUX		NET0602_DVC_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.?	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	LINUX		FS_0100_DVC_UTIL	var0	.1.3.6.1.2.1.25.2.3.1.6.?	.1.3.6.1.2.1.25.2.3.1.6	\N	Integer32
SNMP	LINUX		FS_0100_DVC_UTIL	var1	.1.3.6.1.2.1.25.2.3.1.5.?	.1.3.6.1.2.1.25.2.3.1.5	\N	Integer32
SNMP	SOLARIS		CPU0100_CPU_UTIL	var0	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	SOLARIS		CPU0100_CPU_UTIL	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	SOLARIS		CPU0100_CPU_UTIL	var2	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	SOLARIS		CPU0100_CPU_UTIL	var3	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	SOLARIS		CPU0100_CPU_UTIL	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	SOLARIS		CPU0101_CPU_UTIL_USR	var0	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	SOLARIS		CPU0101_CPU_UTIL_USR	var1	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	SOLARIS		CPU0101_CPU_UTIL_USR	var2	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	SOLARIS		CPU0101_CPU_UTIL_USR	var3	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	SOLARIS		CPU0101_CPU_UTIL_USR	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	SOLARIS		CPU0102_CPU_UTIL_SYS	var0	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	SOLARIS		CPU0102_CPU_UTIL_SYS	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	SOLARIS		CPU0102_CPU_UTIL_SYS	var2	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	SOLARIS		CPU0102_CPU_UTIL_SYS	var3	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	SOLARIS		CPU0102_CPU_UTIL_SYS	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	SOLARIS		CPU0103_CPU_UTIL_NCE	var0	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	SOLARIS		CPU0103_CPU_UTIL_NCE	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	SOLARIS		CPU0103_CPU_UTIL_NCE	var2	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	SOLARIS		CPU0103_CPU_UTIL_NCE	var3	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	SOLARIS		CPU0103_CPU_UTIL_NCE	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	SOLARIS		CPU0104_CPU_UTIL_IOW	var0	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	SOLARIS		CPU0104_CPU_UTIL_IOW	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	SOLARIS		CPU0104_CPU_UTIL_IOW	var2	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	SOLARIS		CPU0104_CPU_UTIL_IOW	var3	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	SOLARIS		CPU0104_CPU_UTIL_IOW	var4	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	SOLARIS		CPU0200_INTERRUPT_RATE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		CPU0200_INTERRUPT_RATE	var1	.1.3.6.1.4.1.2021.11.59.0	.1.3.6.1.4.1.2021.11.59	\N	Counter32
SNMP	SOLARIS		CPU0300_CONTEXT_SWITCH	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		CPU0300_CONTEXT_SWITCH	var1	.1.3.6.1.4.1.2021.11.60.0	.1.3.6.1.4.1.2021.11.60	\N	Counter32
SNMP	SOLARIS		CPU0400_LOAD_AVE_1M	var0	.1.3.6.1.4.1.2021.10.1.5.1	.1.3.6.1.4.1.2021.10.1.5	\N	Integer32
SNMP	SOLARIS		CPU0500_LOAD_AVE_5M	var0	.1.3.6.1.4.1.2021.10.1.5.2	.1.3.6.1.4.1.2021.10.1.5	\N	Integer32
SNMP	SOLARIS		CPU0600_LOAD_AVE_15M	var0	.1.3.6.1.4.1.2021.10.1.5.3	.1.3.6.1.4.1.2021.10.1.5	\N	Integer32
SNMP	SOLARIS		MEM0100_MEM_UTIL	var0	.1.3.6.1.4.1.2021.4.11.0	.1.3.6.1.4.1.2021.4.11	\N	Integer32
SNMP	SOLARIS		MEM0100_MEM_UTIL	var1	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	SOLARIS		MEM0100_MEM_UTIL	var2	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	SOLARIS		MEM0101_MEM_UTIL_SWAP	var0	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	SOLARIS		MEM0101_MEM_UTIL_SWAP	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	SOLARIS		MEM0101_MEM_UTIL_SWAP	var2	.1.3.6.1.4.1.2021.4.4.0	.1.3.6.1.4.1.2021.4.4	\N	Integer32
SNMP	SOLARIS		MEM0102_MEM_UTIL_PHYS	var0	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	SOLARIS		MEM0102_MEM_UTIL_PHYS	var1	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	SOLARIS		MEM0102_MEM_UTIL_PHYS	var2	.1.3.6.1.4.1.2021.4.6.0	.1.3.6.1.4.1.2021.4.6	\N	Integer32
SNMP	SOLARIS		MEM0200_SWAP_SPACE	var0	.1.3.6.1.4.1.2021.4.4.0	.1.3.6.1.4.1.2021.4.4	\N	Integer32
SNMP	SOLARIS		MEM0200_SWAP_SPACE	var1	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	SOLARIS		MEM0300_PHYS_UTIL	var0	.1.3.6.1.4.1.2021.4.6.0	.1.3.6.1.4.1.2021.4.6	\N	Integer32
SNMP	SOLARIS		MEM0300_PHYS_UTIL	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	SOLARIS		MEM0301_PHYS_UTIL_USR	var0	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	SOLARIS		MEM0301_PHYS_UTIL_USR	var1	.1.3.6.1.4.1.2021.4.6.0	.1.3.6.1.4.1.2021.4.6	\N	Integer32
SNMP	SOLARIS		MEM0301_PHYS_UTIL_USR	var2	.1.3.6.1.4.1.2021.4.14.0	.1.3.6.1.4.1.2021.4.14	\N	Integer32
SNMP	SOLARIS		MEM0301_PHYS_UTIL_USR	var3	.1.3.6.1.4.1.2021.4.15.0	.1.3.6.1.4.1.2021.4.15	\N	Integer32
SNMP	SOLARIS		MEM0302_PHYS_UTIL_BUF	var0	.1.3.6.1.4.1.2021.4.14.0	.1.3.6.1.4.1.2021.4.14	\N	Integer32
SNMP	SOLARIS		MEM0302_PHYS_UTIL_BUF	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	SOLARIS		MEM0303_PHYS_UTIL_CAC	var0	.1.3.6.1.4.1.2021.4.15.0	.1.3.6.1.4.1.2021.4.15	\N	Integer32
SNMP	SOLARIS		MEM0303_PHYS_UTIL_CAC	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	SOLARIS		MEM0400_SWAP_IO	var0	.1.3.6.1.4.1.2021.11.3.0	.1.3.6.1.4.1.2021.11.3	\N	Integer32
SNMP	SOLARIS		MEM0400_SWAP_IO	var1	.1.3.6.1.4.1.2021.11.4.0	.1.3.6.1.4.1.2021.11.4	\N	Integer32
SNMP	SOLARIS		MEM0401_SWAP_IO_IN	var0	.1.3.6.1.4.1.2021.11.3.0	.1.3.6.1.4.1.2021.11.3	\N	Integer32
SNMP	SOLARIS		MEM0402_SWAP_IO_OUT	var0	.1.3.6.1.4.1.2021.11.4.0	.1.3.6.1.4.1.2021.11.4	\N	Integer32
SNMP	SOLARIS		DSK0100_DVC_IO_CNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		DSK0100_DVC_IO_CNT	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	.1.3.6.1.4.1.2021.13.15.1.1.5	\N	Counter32
SNMP	SOLARIS		DSK0100_DVC_IO_CNT	var2	.1.3.6.1.4.1.2021.13.15.1.1.6.?	.1.3.6.1.4.1.2021.13.15.1.1.6	\N	Counter32
SNMP	SOLARIS		DSK0101_DVC_IO_CNT_IN	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		DSK0101_DVC_IO_CNT_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	.1.3.6.1.4.1.2021.13.15.1.1.5	\N	Counter32
SNMP	SOLARIS		DSK0102_DVC_IO_CNT_OUT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		DSK0102_DVC_IO_CNT_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.6.?	.1.3.6.1.4.1.2021.13.15.1.1.6	\N	Counter32
SNMP	SOLARIS		DSK0200_DVC_IO_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		DSK0200_DVC_IO_BYTE	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	.1.3.6.1.4.1.2021.13.15.1.1.3	\N	Counter32
SNMP	SOLARIS		DSK0200_DVC_IO_BYTE	var2	.1.3.6.1.4.1.2021.13.15.1.1.4.?	.1.3.6.1.4.1.2021.13.15.1.1.4	\N	Counter32
SNMP	SOLARIS		DSK0201_DVC_IO_BYTE_IN	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		DSK0201_DVC_IO_BYTE_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	.1.3.6.1.4.1.2021.13.15.1.1.3	\N	Counter32
SNMP	SOLARIS		DSK0202_DVC_IO_BYTE_OUT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		DSK0202_DVC_IO_BYTE_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.4.?	.1.3.6.1.4.1.2021.13.15.1.1.4	\N	Counter32
SNMP	SOLARIS		NET0100_PACKET	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0100_PACKET	var1	.1.3.6.1.2.1.2.2.1.11.*	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	SOLARIS		NET0100_PACKET	var2	.1.3.6.1.2.1.2.2.1.17.*	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	SOLARIS		NET0101_PACKET_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0101_PACKET_RCV	var1	.1.3.6.1.2.1.2.2.1.11.*	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	SOLARIS		NET0102_PACKET_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0102_PACKET_SNT	var1	.1.3.6.1.2.1.2.2.1.17.*	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	SOLARIS		NET0300_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0300_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.*	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	SOLARIS		NET0300_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.*	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	SOLARIS		NET0301_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0301_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.*	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	SOLARIS		NET0302_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0302_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.*	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	SOLARIS		NET0200_DVC_PCK	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0200_DVC_PCK	var1	.1.3.6.1.2.1.2.2.1.11.?	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	SOLARIS		NET0200_DVC_PCK	var2	.1.3.6.1.2.1.2.2.1.17.?	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	SOLARIS		NET0201_DVC_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0201_DVC_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.11.?	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	SOLARIS		NET0202_DVC_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0202_DVC_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.17.?	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	SOLARIS		NET0400_DVC_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0400_DVC_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.?	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	SOLARIS		NET0400_DVC_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.?	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	SOLARIS		NET0401_DVC_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0401_DVC_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.?	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	SOLARIS		NET0402_DVC_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0402_DVC_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.?	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	SOLARIS		NET0500_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0500_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.*	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	SOLARIS		NET0500_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.*	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	SOLARIS		NET0501_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0501_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.*	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	SOLARIS		NET0502_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0502_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.*	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	SOLARIS		NET0600_DVC_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0600_DVC_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.?	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	SOLARIS		NET0600_DVC_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.?	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	SOLARIS		NET0601_DVC_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0601_DVC_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.?	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	SOLARIS		NET0602_DVC_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	SOLARIS		NET0602_DVC_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.?	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	SOLARIS		FS_0100_DVC_UTIL	var0	.1.3.6.1.2.1.25.2.3.1.6.?	.1.3.6.1.2.1.25.2.3.1.6	\N	Integer32
SNMP	SOLARIS		FS_0100_DVC_UTIL	var1	.1.3.6.1.2.1.25.2.3.1.5.?	.1.3.6.1.2.1.25.2.3.1.5	\N	Integer32
SNMP	WINDOWS		CPU0100_CPU_UTIL	var0	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	WINDOWS		CPU0100_CPU_UTIL	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	WINDOWS		CPU0100_CPU_UTIL	var2	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	WINDOWS		CPU0100_CPU_UTIL	var3	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	WINDOWS		CPU0100_CPU_UTIL	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var0	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var1	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var2	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var3	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var0	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var2	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var3	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	var0	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	var2	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	var3	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	var4	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	var0	.1.3.6.1.4.1.2021.11.54.0	.1.3.6.1.4.1.2021.11.54	\N	Counter32
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	var1	.1.3.6.1.4.1.2021.11.50.0	.1.3.6.1.4.1.2021.11.50	\N	Counter32
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	var2	.1.3.6.1.4.1.2021.11.51.0	.1.3.6.1.4.1.2021.11.51	0	Counter32
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	var3	.1.3.6.1.4.1.2021.11.52.0	.1.3.6.1.4.1.2021.11.52	\N	Counter32
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	var4	.1.3.6.1.4.1.2021.11.53.0	.1.3.6.1.4.1.2021.11.53	\N	Counter32
SNMP	WINDOWS		CPU0200_INTERRUPT_RATE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		CPU0200_INTERRUPT_RATE	var1	.1.3.6.1.4.1.2021.11.59.0	.1.3.6.1.4.1.2021.11.59	\N	Counter32
SNMP	WINDOWS		CPU0300_CONTEXT_SWITCH	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		CPU0300_CONTEXT_SWITCH	var1	.1.3.6.1.4.1.2021.11.60.0	.1.3.6.1.4.1.2021.11.60	\N	Counter32
SNMP	WINDOWS		MEM0100_MEM_UTIL	var0	.1.3.6.1.4.1.2021.4.11.0	.1.3.6.1.4.1.2021.4.11	\N	Integer32
SNMP	WINDOWS		MEM0100_MEM_UTIL	var1	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	WINDOWS		MEM0100_MEM_UTIL	var2	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	var0	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	var2	.1.3.6.1.4.1.2021.4.4.0	.1.3.6.1.4.1.2021.4.4	\N	Integer32
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	var0	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	var1	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	var2	.1.3.6.1.4.1.2021.4.6.0	.1.3.6.1.4.1.2021.4.6	\N	Integer32
SNMP	WINDOWS		MEM0200_SWAP_SPACE	var0	.1.3.6.1.4.1.2021.4.4.0	.1.3.6.1.4.1.2021.4.4	\N	Integer32
SNMP	WINDOWS		MEM0200_SWAP_SPACE	var1	.1.3.6.1.4.1.2021.4.3.0	.1.3.6.1.4.1.2021.4.3	\N	Integer32
SNMP	WINDOWS		MEM0300_PHYS_UTIL	var0	.1.3.6.1.4.1.2021.4.6.0	.1.3.6.1.4.1.2021.4.6	\N	Integer32
SNMP	WINDOWS		MEM0300_PHYS_UTIL	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var0	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var1	.1.3.6.1.4.1.2021.4.6.0	.1.3.6.1.4.1.2021.4.6	\N	Integer32
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var2	.1.3.6.1.4.1.2021.4.14.0	.1.3.6.1.4.1.2021.4.14	\N	Integer32
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	var3	.1.3.6.1.4.1.2021.4.15.0	.1.3.6.1.4.1.2021.4.15	\N	Integer32
SNMP	WINDOWS		MEM0302_PHYS_UTIL_BUF	var0	.1.3.6.1.4.1.2021.4.14.0	.1.3.6.1.4.1.2021.4.14	\N	Integer32
SNMP	WINDOWS		MEM0302_PHYS_UTIL_BUF	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	WINDOWS		MEM0303_PHYS_UTIL_CAC	var0	.1.3.6.1.4.1.2021.4.15.0	.1.3.6.1.4.1.2021.4.15	\N	Integer32
SNMP	WINDOWS		MEM0303_PHYS_UTIL_CAC	var1	.1.3.6.1.4.1.2021.4.5.0	.1.3.6.1.4.1.2021.4.5	\N	Integer32
SNMP	WINDOWS		MEM0400_SWAP_IO	var0	.1.3.6.1.4.1.2021.11.3.0	.1.3.6.1.4.1.2021.11.3	\N	Integer32
SNMP	WINDOWS		MEM0400_SWAP_IO	var1	.1.3.6.1.4.1.2021.11.4.0	.1.3.6.1.4.1.2021.11.4	\N	Integer32
SNMP	WINDOWS		MEM0401_SWAP_IO_IN	var0	.1.3.6.1.4.1.2021.11.3.0	.1.3.6.1.4.1.2021.11.3	\N	Integer32
SNMP	WINDOWS		MEM0402_SWAP_IO_OUT	var0	.1.3.6.1.4.1.2021.11.4.0	.1.3.6.1.4.1.2021.11.4	\N	Integer32
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	.1.3.6.1.4.1.2021.13.15.1.1.5	\N	Counter32
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	var2	.1.3.6.1.4.1.2021.13.15.1.1.6.?	.1.3.6.1.4.1.2021.13.15.1.1.6	\N	Counter32
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.5.?	.1.3.6.1.4.1.2021.13.15.1.1.5	\N	Counter32
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.6.?	.1.3.6.1.4.1.2021.13.15.1.1.6	\N	Counter32
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	.1.3.6.1.4.1.2021.13.15.1.1.3	\N	Counter32
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	var2	.1.3.6.1.4.1.2021.13.15.1.1.4.?	.1.3.6.1.4.1.2021.13.15.1.1.4	\N	Counter32
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	var1	.1.3.6.1.4.1.2021.13.15.1.1.3.?	.1.3.6.1.4.1.2021.13.15.1.1.3	\N	Counter32
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	var1	.1.3.6.1.4.1.2021.13.15.1.1.4.?	.1.3.6.1.4.1.2021.13.15.1.1.4	\N	Counter32
SNMP	WINDOWS		NET0100_PACKET	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0100_PACKET	var1	.1.3.6.1.2.1.2.2.1.11.*	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	WINDOWS		NET0100_PACKET	var2	.1.3.6.1.2.1.2.2.1.17.*	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	WINDOWS		NET0101_PACKET_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0101_PACKET_RCV	var1	.1.3.6.1.2.1.2.2.1.11.*	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	WINDOWS		NET0102_PACKET_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0102_PACKET_SNT	var1	.1.3.6.1.2.1.2.2.1.17.*	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	WINDOWS		NET0300_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0300_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.*	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	WINDOWS		NET0300_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.*	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	WINDOWS		NET0301_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0301_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.*	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	WINDOWS		NET0302_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0302_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.*	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	WINDOWS		NET0200_DVC_PCK	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0200_DVC_PCK	var1	.1.3.6.1.2.1.2.2.1.11.?	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	WINDOWS		NET0200_DVC_PCK	var2	.1.3.6.1.2.1.2.2.1.17.?	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.11.?	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.17.?	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.?	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.?	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.?	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.?	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	WINDOWS		NET0500_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0500_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.*	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	WINDOWS		NET0500_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.*	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	WINDOWS		NET0501_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0501_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.*	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	WINDOWS		NET0502_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0502_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.*	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	WINDOWS		NET0600_DVC_BYTE	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0600_DVC_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.?	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	WINDOWS		NET0600_DVC_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.?	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.?	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	var0	.1.3.6.1.2.1.25.1.1.0	.1.3.6.1.2.1.25.1.1	\N	TimeTicks
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.?	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	WINDOWS		FS_0100_DVC_UTIL	var0	.1.3.6.1.2.1.25.2.3.1.6.?	.1.3.6.1.2.1.25.2.3.1.6	\N	Integer32
SNMP	WINDOWS		FS_0100_DVC_UTIL	var1	.1.3.6.1.2.1.25.2.3.1.5.?	.1.3.6.1.2.1.25.2.3.1.5	\N	Integer32
SNMP	NW_EQUIPMENT		NET0100_PACKET	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0100_PACKET	var1	.1.3.6.1.2.1.2.2.1.11.*	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	NW_EQUIPMENT		NET0100_PACKET	var2	.1.3.6.1.2.1.2.2.1.17.*	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	NW_EQUIPMENT		NET0101_PACKET_RCV	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0101_PACKET_RCV	var1	.1.3.6.1.2.1.2.2.1.11.*	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	NW_EQUIPMENT		NET0102_PACKET_SNT	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0102_PACKET_SNT	var1	.1.3.6.1.2.1.2.2.1.17.*	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.*	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.*	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	NW_EQUIPMENT		NET0301_ERR_PCK_RCV	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0301_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.*	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	NW_EQUIPMENT		NET0302_ERR_PCK_SNT	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0302_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.*	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	var1	.1.3.6.1.2.1.2.2.1.11.?	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	var2	.1.3.6.1.2.1.2.2.1.17.?	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.11.?	.1.3.6.1.2.1.2.2.1.11	\N	Counter32
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.17.?	.1.3.6.1.2.1.2.2.1.17	\N	Counter32
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	var1	.1.3.6.1.2.1.2.2.1.14.?	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	var2	.1.3.6.1.2.1.2.2.1.20.?	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	var1	.1.3.6.1.2.1.2.2.1.14.?	.1.3.6.1.2.1.2.2.1.14	\N	Counter32
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	var1	.1.3.6.1.2.1.2.2.1.20.?	.1.3.6.1.2.1.2.2.1.20	\N	Counter32
SNMP	NW_EQUIPMENT		NET0500_BYTE	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0500_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.*	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	NW_EQUIPMENT		NET0500_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.*	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	NW_EQUIPMENT		NET0501_BYTE_RCV	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0501_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.*	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	NW_EQUIPMENT		NET0502_BYTE_SNT	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0502_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.*	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	var1	.1.3.6.1.2.1.2.2.1.10.?	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	var2	.1.3.6.1.2.1.2.2.1.16.?	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	var1	.1.3.6.1.2.1.2.2.1.10.?	.1.3.6.1.2.1.2.2.1.10	\N	Counter32
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	var0	.1.3.6.1.2.1.1.3.0	.1.3.6.1.2.1.1.3	\N	TimeTicks
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	var1	.1.3.6.1.2.1.2.2.1.16.?	.1.3.6.1.2.1.2.2.1.16	\N	Counter32
WBEM	LINUX		CPU0100_CPU_UTIL	var0	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N	Uint64
WBEM	LINUX		CPU0100_CPU_UTIL	var1	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Linux_OperatingSystemStatisticalData.CPUUserTime	\N	Uint64
WBEM	LINUX		CPU0100_CPU_UTIL	var2	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N	Uint64
WBEM	LINUX		CPU0100_CPU_UTIL	var3	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N	Uint64
WBEM	LINUX		CPU0100_CPU_UTIL	var4			0	Uint64
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var0	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Linux_OperatingSystemStatisticalData.CPUUserTime	\N	Uint64
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var1	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N	Uint64
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var2	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N	Uint64
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var3	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N	Uint64
WBEM	LINUX		CPU0101_CPU_UTIL_USR	var4			0	Uint64
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var0	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N	Uint64
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var1	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Linux_OperatingSystemStatisticalData.CPUUserTime	\N	Uint64
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var2	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N	Uint64
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var3	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N	Uint64
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	var4			0	Uint64
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var0			0	Uint64
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var1	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N	Uint64
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var2	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Linux_OperatingSystemStatisticalData.CPUUserTime	\N	Uint64
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var3	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N	Uint64
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	var4	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N	Uint64
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var0	Linux_OperatingSystemStatisticalData.CPUWaitTime.0	Linux_OperatingSystemStatisticalData.CPUWaitTime	\N	Uint64
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var1	Linux_OperatingSystemStatisticalData.CPUUserTime.0	Linux_OperatingSystemStatisticalData.CPUUserTime	\N	Uint64
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var2	Linux_OperatingSystemStatisticalData.CPUSystemTime.0	Linux_OperatingSystemStatisticalData.CPUSystemTime	\N	Uint64
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var3	Linux_OperatingSystemStatisticalData.CPUIdleTime.0	Linux_OperatingSystemStatisticalData.CPUIdleTime	\N	Uint64
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	var4			0	Uint64
WBEM	LINUX		MEM0100_MEM_UTIL	var0	PG_OperatingSystem.FreePhysicalMemory.0	PG_OperatingSystem.FreePhysicalMemory	\N	Uint64
WBEM	LINUX		MEM0100_MEM_UTIL	var1	PG_OperatingSystem.FreeVirtualMemory.0	PG_OperatingSystem.FreeVirtualMemory	\N	Uint64
WBEM	LINUX		MEM0100_MEM_UTIL	var2	PG_OperatingSystem.TotalVisibleMemorySize.0	PG_OperatingSystem.TotalVisibleMemorySize	\N	Uint64
WBEM	LINUX		MEM0100_MEM_UTIL	var3	PG_OperatingSystem.TotalSwapSpaceSize.0	PG_OperatingSystem.TotalSwapSpaceSize	\N	Uint64
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	var0	PG_OperatingSystem.TotalSwapSpaceSize.0	PG_OperatingSystem.TotalSwapSpaceSize	\N	Uint64
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	var1	PG_OperatingSystem.TotalVisibleMemorySize.0	PG_OperatingSystem.TotalVisibleMemorySize	\N	Uint64
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	var2	PG_OperatingSystem.FreeVirtualMemory.0	PG_OperatingSystem.FreeVirtualMemory	\N	Uint64
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	var0	PG_OperatingSystem.TotalVisibleMemorySize.0	PG_OperatingSystem.TotalVisibleMemorySize	\N	Uint64
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	var1	PG_OperatingSystem.TotalSwapSpaceSize.0	PG_OperatingSystem.TotalSwapSpaceSize	\N	Uint64
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	var2	PG_OperatingSystem.FreePhysicalMemory.0	PG_OperatingSystem.FreePhysicalMemory	\N	Uint64
WBEM	LINUX		MEM0200_SWAP_SPACE	var0	PG_OperatingSystem.FreeVirtualMemory.0	PG_OperatingSystem.FreeVirtualMemory	\N	Uint64
WBEM	LINUX		MEM0200_SWAP_SPACE	var1	PG_OperatingSystem.TotalSwapSpaceSize.0	PG_OperatingSystem.TotalSwapSpaceSize	\N	Uint64
WBEM	LINUX		MEM0300_PHYS_UTIL	var0	PG_OperatingSystem.FreePhysicalMemory.0	PG_OperatingSystem.FreePhysicalMemory	\N	Uint64
WBEM	LINUX		MEM0300_PHYS_UTIL	var1	PG_OperatingSystem.TotalVisibleMemorySize.0	PG_OperatingSystem.TotalVisibleMemorySize	\N	Uint64
WBEM	LINUX		MEM0400_SWAP_IO	var0	Linux_OperatingSystem.TotalSwapSpaceSize.0	Linux_OperatingSystem.TotalSwapSpaceSize	\N	Uint64
WBEM	LINUX		DSK0100_DVC_IO_CNT	key	Linux_BlockStorageStatisticalData.ElementName.?	Linux_BlockStorageStatisticalData.ElementName	\N	String
WBEM	LINUX		DSK0100_DVC_IO_CNT	var0	PG_OperatingSystem.SystemUpTime.0	PG_OperatingSystem.SystemUpTime	\N	Uint64
WBEM	LINUX		DSK0100_DVC_IO_CNT	var1	Linux_BlockStorageStatisticalData.TotalIOs.?	Linux_BlockStorageStatisticalData.TotalIOs	\N	Uint64
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	key	Linux_BlockStorageStatisticalData.ElementName.?	Linux_BlockStorageStatisticalData.ElementName	\N	String
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	var0	PG_OperatingSystem.SystemUpTime.0	PG_OperatingSystem.SystemUpTime	\N	Uint64
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	var1	Linux_BlockStorageStatisticalData.ReadIOs.?	Linux_BlockStorageStatisticalData.ReadIOs	\N	Uint64
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	key	Linux_BlockStorageStatisticalData.ElementName.?	Linux_BlockStorageStatisticalData.ElementName	\N	String
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	var0	PG_OperatingSystem.SystemUpTime.0	PG_OperatingSystem.SystemUpTime	\N	Uint64
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	var1	Linux_BlockStorageStatisticalData.WriteIOs.?	Linux_BlockStorageStatisticalData.WriteIOs	\N	Uint64
WBEM	LINUX		DSK0200_DVC_IO_BYTE	key	Linux_BlockStorageStatisticalData.ElementName.?	Linux_BlockStorageStatisticalData.ElementName	\N	String
WBEM	LINUX		DSK0200_DVC_IO_BYTE	var0	PG_OperatingSystem.SystemUpTime.0	PG_OperatingSystem.SystemUpTime	\N	Uint64
WBEM	LINUX		DSK0200_DVC_IO_BYTE	var1	Linux_BlockStorageStatisticalData.KBytesTransfered.?	Linux_BlockStorageStatisticalData.KBytesTransfered	\N	Uint64
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	key	Linux_BlockStorageStatisticalData.ElementName.?	Linux_BlockStorageStatisticalData.ElementName	\N	String
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	var0	PG_OperatingSystem.SystemUpTime.0	PG_OperatingSystem.SystemUpTime	\N	Uint64
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	var1	Linux_BlockStorageStatisticalData.KBytesRead.?	Linux_BlockStorageStatisticalData.KBytesRead	\N	Uint64
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	key	Linux_BlockStorageStatisticalData.ElementName.?	Linux_BlockStorageStatisticalData.ElementName	\N	String
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	var0	PG_OperatingSystem.SystemUpTime.0	PG_OperatingSystem.SystemUpTime	\N	Uint64
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	var1	Linux_BlockStorageStatisticalData.KBytesTransfered.?	Linux_BlockStorageStatisticalData.KBytesTransfered	\N	Uint64
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	var2	Linux_BlockStorageStatisticalData.KBytesRead.?	Linux_BlockStorageStatisticalData.KBytesRead	\N	Uint64
WBEM	LINUX		FS_0100_DVC_UTIL	key	Linux_Ext3FileSystem.Root.?	Linux_Ext3FileSystem.Root	\N	String
WBEM	LINUX		FS_0100_DVC_UTIL	var0	Linux_Ext3FileSystem.AvailableSpace.?	Linux_Ext3FileSystem.AvailableSpace	\N	Uint64
WBEM	LINUX		FS_0100_DVC_UTIL	var1	Linux_Ext3FileSystem.FileSystemSize.?	Linux_Ext3FileSystem.FileSystemSize	\N	Uint64
\.

COPY cc_collector_item_calc_method_mst (collect_method, platform_id, sub_platform_id, item_code, calc_method) FROM stdin;
SNMP	LINUX		CPU0100_CPU_UTIL	InvPercentageOfTotal
SNMP	LINUX		CPU0101_CPU_UTIL_USR	PercentageOfTotal
SNMP	LINUX		CPU0102_CPU_UTIL_SYS	PercentageOfTotal
SNMP	LINUX		CPU0103_CPU_UTIL_NCE	PercentageOfTotal
SNMP	LINUX		CPU0104_CPU_UTIL_IOW	PercentageOfTotal
SNMP	LINUX		CPU0200_INTERRUPT_RATE	TimeMean
SNMP	LINUX		CPU0300_CONTEXT_SWITCH	TimeMean
SNMP	LINUX		CPU0400_LOAD_AVE_1M	DividedBy100
SNMP	LINUX		CPU0500_LOAD_AVE_5M	DividedBy100
SNMP	LINUX		CPU0600_LOAD_AVE_15M	DividedBy100
SNMP	LINUX		MEM0100_MEM_UTIL	InvPercentage12
SNMP	LINUX		MEM0101_MEM_UTIL_SWAP	PercentageDiffAdd
SNMP	LINUX		MEM0102_MEM_UTIL_PHYS	PercentageDiffAdd
SNMP	LINUX		MEM0200_SWAP_SPACE	InvPercentage
SNMP	LINUX		MEM0300_PHYS_UTIL	InvPercentage
SNMP	LINUX		MEM0301_PHYS_UTIL_USR	InvPercentage31
SNMP	LINUX		MEM0302_PHYS_UTIL_BUF	Percentage
SNMP	LINUX		MEM0303_PHYS_UTIL_CAC	Percentage
SNMP	LINUX		MEM0400_SWAP_IO	Sum
SNMP	LINUX		MEM0401_SWAP_IO_IN	Non
SNMP	LINUX		MEM0402_SWAP_IO_OUT	Non
SNMP	LINUX		DSK0100_DVC_IO_CNT	TimeMeanSum
SNMP	LINUX		DSK0101_DVC_IO_CNT_IN	TimeMean
SNMP	LINUX		DSK0102_DVC_IO_CNT_OUT	TimeMean
SNMP	LINUX		DSK0200_DVC_IO_BYTE	TimeMeanSum
SNMP	LINUX		DSK0201_DVC_IO_BYTE_IN	TimeMean
SNMP	LINUX		DSK0202_DVC_IO_BYTE_OUT	TimeMean
SNMP	LINUX		NET0100_PACKET	TimeMeanPerTotal
SNMP	LINUX		NET0101_PACKET_RCV	TimeMeanPerTotal
SNMP	LINUX		NET0102_PACKET_SNT	TimeMeanPerTotal
SNMP	LINUX		NET0300_ERR_PCK	TimeMeanPerTotal
SNMP	LINUX		NET0301_ERR_PCK_RCV	TimeMeanPerTotal
SNMP	LINUX		NET0302_ERR_PCK_SNT	TimeMeanPerTotal
SNMP	LINUX		NET0200_DVC_PCK	TimeMeanSum
SNMP	LINUX		NET0201_DVC_PCK_RCV	TimeMean
SNMP	LINUX		NET0202_DVC_PCK_SNT	TimeMean
SNMP	LINUX		NET0400_DVC_ERR_PCK	TimeMeanSum
SNMP	LINUX		NET0401_DVC_ERR_PCK_RCV	TimeMean
SNMP	LINUX		NET0402_DVC_ERR_PCK_SNT	TimeMean
SNMP	LINUX		NET0500_BYTE	TimeMeanPerTotal
SNMP	LINUX		NET0501_BYTE_RCV	TimeMeanPerTotal
SNMP	LINUX		NET0502_BYTE_SNT	TimeMeanPerTotal
SNMP	LINUX		NET0600_DVC_BYTE	TimeMeanSum
SNMP	LINUX		NET0601_DVC_BYTE_RCV	TimeMean
SNMP	LINUX		NET0602_DVC_BYTE_SNT	TimeMean
SNMP	LINUX		FS_0100_DVC_UTIL	Percentage
SNMP	SOLARIS		CPU0100_CPU_UTIL	InvPercentageOfTotal
SNMP	SOLARIS		CPU0101_CPU_UTIL_USR	PercentageOfTotal
SNMP	SOLARIS		CPU0102_CPU_UTIL_SYS	PercentageOfTotal
SNMP	SOLARIS		CPU0103_CPU_UTIL_NCE	PercentageOfTotal
SNMP	SOLARIS		CPU0104_CPU_UTIL_IOW	PercentageOfTotal
SNMP	SOLARIS		CPU0200_INTERRUPT_RATE	TimeMean
SNMP	SOLARIS		CPU0300_CONTEXT_SWITCH	TimeMean
SNMP	SOLARIS		CPU0400_LOAD_AVE_1M	DividedBy100
SNMP	SOLARIS		CPU0500_LOAD_AVE_5M	DividedBy100
SNMP	SOLARIS		CPU0600_LOAD_AVE_15M	DividedBy100
SNMP	SOLARIS		MEM0100_MEM_UTIL	InvPercentage12
SNMP	SOLARIS		MEM0101_MEM_UTIL_SWAP	PercentageDiffAdd
SNMP	SOLARIS		MEM0102_MEM_UTIL_PHYS	PercentageDiffAdd
SNMP	SOLARIS		MEM0200_SWAP_SPACE	InvPercentage
SNMP	SOLARIS		MEM0300_PHYS_UTIL	InvPercentage
SNMP	SOLARIS		MEM0301_PHYS_UTIL_USR	InvPercentage31
SNMP	SOLARIS		MEM0302_PHYS_UTIL_BUF	Percentage
SNMP	SOLARIS		MEM0303_PHYS_UTIL_CAC	Percentage
SNMP	SOLARIS		MEM0400_SWAP_IO	Sum
SNMP	SOLARIS		MEM0401_SWAP_IO_IN	Non
SNMP	SOLARIS		MEM0402_SWAP_IO_OUT	Non
SNMP	SOLARIS		DSK0100_DVC_IO_CNT	TimeMeanSum
SNMP	SOLARIS		DSK0101_DVC_IO_CNT_IN	TimeMean
SNMP	SOLARIS		DSK0102_DVC_IO_CNT_OUT	TimeMean
SNMP	SOLARIS		DSK0200_DVC_IO_BYTE	TimeMeanSum
SNMP	SOLARIS		DSK0201_DVC_IO_BYTE_IN	TimeMean
SNMP	SOLARIS		DSK0202_DVC_IO_BYTE_OUT	TimeMean
SNMP	SOLARIS		NET0100_PACKET	TimeMeanPerTotal
SNMP	SOLARIS		NET0101_PACKET_RCV	TimeMeanPerTotal
SNMP	SOLARIS		NET0102_PACKET_SNT	TimeMeanPerTotal
SNMP	SOLARIS		NET0300_ERR_PCK	TimeMeanPerTotal
SNMP	SOLARIS		NET0301_ERR_PCK_RCV	TimeMeanPerTotal
SNMP	SOLARIS		NET0302_ERR_PCK_SNT	TimeMeanPerTotal
SNMP	SOLARIS		NET0200_DVC_PCK	TimeMeanSum
SNMP	SOLARIS		NET0201_DVC_PCK_RCV	TimeMean
SNMP	SOLARIS		NET0202_DVC_PCK_SNT	TimeMean
SNMP	SOLARIS		NET0400_DVC_ERR_PCK	TimeMeanSum
SNMP	SOLARIS		NET0401_DVC_ERR_PCK_RCV	TimeMean
SNMP	SOLARIS		NET0402_DVC_ERR_PCK_SNT	TimeMean
SNMP	SOLARIS		NET0500_BYTE	TimeMeanPerTotal
SNMP	SOLARIS		NET0501_BYTE_RCV	TimeMeanPerTotal
SNMP	SOLARIS		NET0502_BYTE_SNT	TimeMeanPerTotal
SNMP	SOLARIS		NET0600_DVC_BYTE	TimeMeanSum
SNMP	SOLARIS		NET0601_DVC_BYTE_RCV	TimeMean
SNMP	SOLARIS		NET0602_DVC_BYTE_SNT	TimeMean
SNMP	SOLARIS		FS_0100_DVC_UTIL	Percentage
SNMP	WINDOWS		CPU0100_CPU_UTIL	InvPercentageOfTotal
SNMP	WINDOWS		CPU0101_CPU_UTIL_USR	PercentageOfTotal
SNMP	WINDOWS		CPU0102_CPU_UTIL_SYS	PercentageOfTotal
SNMP	WINDOWS		CPU0103_CPU_UTIL_NCE	PercentageOfTotal
SNMP	WINDOWS		CPU0104_CPU_UTIL_IOW	PercentageOfTotal
SNMP	WINDOWS		CPU0200_INTERRUPT_RATE	TimeMean
SNMP	WINDOWS		CPU0300_CONTEXT_SWITCH	TimeMean
SNMP	WINDOWS		MEM0100_MEM_UTIL	InvPercentage12
SNMP	WINDOWS		MEM0101_MEM_UTIL_SWAP	PercentageDiffAdd
SNMP	WINDOWS		MEM0102_MEM_UTIL_PHYS	PercentageDiffAdd
SNMP	WINDOWS		MEM0200_SWAP_SPACE	InvPercentage
SNMP	WINDOWS		MEM0300_PHYS_UTIL	InvPercentage
SNMP	WINDOWS		MEM0301_PHYS_UTIL_USR	InvPercentage31
SNMP	WINDOWS		MEM0302_PHYS_UTIL_BUF	Percentage
SNMP	WINDOWS		MEM0303_PHYS_UTIL_CAC	Percentage
SNMP	WINDOWS		MEM0400_SWAP_IO	Sum
SNMP	WINDOWS		MEM0401_SWAP_IO_IN	Non
SNMP	WINDOWS		MEM0402_SWAP_IO_OUT	Non
SNMP	WINDOWS		DSK0100_DVC_IO_CNT	TimeMeanSum
SNMP	WINDOWS		DSK0101_DVC_IO_CNT_IN	TimeMean
SNMP	WINDOWS		DSK0102_DVC_IO_CNT_OUT	TimeMean
SNMP	WINDOWS		DSK0200_DVC_IO_BYTE	TimeMeanSum
SNMP	WINDOWS		DSK0201_DVC_IO_BYTE_IN	TimeMean
SNMP	WINDOWS		DSK0202_DVC_IO_BYTE_OUT	TimeMean
SNMP	WINDOWS		NET0100_PACKET	TimeMeanPerTotal
SNMP	WINDOWS		NET0101_PACKET_RCV	TimeMeanPerTotal
SNMP	WINDOWS		NET0102_PACKET_SNT	TimeMeanPerTotal
SNMP	WINDOWS		NET0300_ERR_PCK	TimeMeanPerTotal
SNMP	WINDOWS		NET0301_ERR_PCK_RCV	TimeMeanPerTotal
SNMP	WINDOWS		NET0302_ERR_PCK_SNT	TimeMeanPerTotal
SNMP	WINDOWS		NET0200_DVC_PCK	TimeMeanSum
SNMP	WINDOWS		NET0201_DVC_PCK_RCV	TimeMean
SNMP	WINDOWS		NET0202_DVC_PCK_SNT	TimeMean
SNMP	WINDOWS		NET0400_DVC_ERR_PCK	TimeMeanSum
SNMP	WINDOWS		NET0401_DVC_ERR_PCK_RCV	TimeMean
SNMP	WINDOWS		NET0402_DVC_ERR_PCK_SNT	TimeMean
SNMP	WINDOWS		NET0500_BYTE	TimeMeanPerTotal
SNMP	WINDOWS		NET0501_BYTE_RCV	TimeMeanPerTotal
SNMP	WINDOWS		NET0502_BYTE_SNT	TimeMeanPerTotal
SNMP	WINDOWS		NET0600_DVC_BYTE	TimeMeanSum
SNMP	WINDOWS		NET0601_DVC_BYTE_RCV	TimeMean
SNMP	WINDOWS		NET0602_DVC_BYTE_SNT	TimeMean
SNMP	WINDOWS		FS_0100_DVC_UTIL	Percentage
SNMP	NW_EQUIPMENT		NET0100_PACKET	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0101_PACKET_RCV	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0102_PACKET_SNT	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0300_ERR_PCK	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0301_ERR_PCK_RCV	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0302_ERR_PCK_SNT	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0200_DVC_PCK	TimeMeanSum
SNMP	NW_EQUIPMENT		NET0201_DVC_PCK_RCV	TimeMean
SNMP	NW_EQUIPMENT		NET0202_DVC_PCK_SNT	TimeMean
SNMP	NW_EQUIPMENT		NET0400_DVC_ERR_PCK	TimeMeanSum
SNMP	NW_EQUIPMENT		NET0401_DVC_ERR_PCK_RCV	TimeMean
SNMP	NW_EQUIPMENT		NET0402_DVC_ERR_PCK_SNT	TimeMean
SNMP	NW_EQUIPMENT		NET0500_BYTE	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0501_BYTE_RCV	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0502_BYTE_SNT	TimeMeanPerTotal
SNMP	NW_EQUIPMENT		NET0600_DVC_BYTE	TimeMeanSum
SNMP	NW_EQUIPMENT		NET0601_DVC_BYTE_RCV	TimeMean
SNMP	NW_EQUIPMENT		NET0602_DVC_BYTE_SNT	TimeMean
WBEM	LINUX		CPU0100_CPU_UTIL	InvPercentageOfTotal
WBEM	LINUX		CPU0101_CPU_UTIL_USR	PercentageOfTotal
WBEM	LINUX		CPU0102_CPU_UTIL_SYS	PercentageOfTotal
WBEM	LINUX		CPU0103_CPU_UTIL_NCE	PercentageOfTotal
WBEM	LINUX		CPU0104_CPU_UTIL_IOW	PercentageOfTotal
WBEM	LINUX		MEM0100_MEM_UTIL	InvPercentage22
WBEM	LINUX		MEM0101_MEM_UTIL_SWAP	PercentageDiffAdd
WBEM	LINUX		MEM0102_MEM_UTIL_PHYS	PercentageDiffAdd
WBEM	LINUX		MEM0200_SWAP_SPACE	InvPercentage
WBEM	LINUX		MEM0300_PHYS_UTIL	InvPercentage
WBEM	LINUX		MEM0400_SWAP_IO	Non
WBEM	LINUX		DSK0100_DVC_IO_CNT	TimeMeanPerSec
WBEM	LINUX		DSK0101_DVC_IO_CNT_IN	TimeMeanPerSec
WBEM	LINUX		DSK0102_DVC_IO_CNT_OUT	TimeMeanPerSec
WBEM	LINUX		DSK0200_DVC_IO_BYTE	TimeMeanKbyte
WBEM	LINUX		DSK0201_DVC_IO_BYTE_IN	TimeMeanKbyte
WBEM	LINUX		DSK0202_DVC_IO_BYTE_OUT	TimeMeanKbyteDiff
WBEM	LINUX		FS_0100_DVC_UTIL	InvPercentage
\.

COPY cc_monitor_process_method_mst (platform_id, sub_platform_id, collect_method) FROM stdin;
LINUX		SNMP
SOLARIS		SNMP
WINDOWS		SNMP
NW_EQUIPMENT		SNMP
OTHER		SNMP
\.

COPY cc_monitor_process_polling_mst (collect_method, platform_id, sub_platform_id, variable_id, entry_key, polling_target) FROM stdin;
SNMP	LINUX		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	LINUX		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	LINUX		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	SOLARIS		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	SOLARIS		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	SOLARIS		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	WINDOWS		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	WINDOWS		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	WINDOWS		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	NW_EQUIPMENT		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	NW_EQUIPMENT		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	NW_EQUIPMENT		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
SNMP	OTHER		path	.1.3.6.1.2.1.25.4.2.1.4.*	.1.3.6.1.2.1.25.4.2.1.4
SNMP	OTHER		param	.1.3.6.1.2.1.25.4.2.1.5.*	.1.3.6.1.2.1.25.4.2.1.5
SNMP	OTHER		name	.1.3.6.1.2.1.25.4.2.1.2.*	.1.3.6.1.2.1.25.4.2.1.2
WBEM	LINUX		param	Linux_UnixProcess.Parameters.*	Linux_UnixProcess.Parameters
\.

COPY cc_collector_category_collect_mst (platform_id, sub_platform_id, category_code, collect_method) FROM stdin;
LINUX		C000_CPU	SNMP
LINUX		C001_MEM	SNMP
LINUX		C002_DSK	SNMP
LINUX		C003_NET	SNMP
LINUX		C004_FS	SNMP
SOLARIS		C000_CPU	SNMP
SOLARIS		C001_MEM	SNMP
SOLARIS		C002_DSK	SNMP
SOLARIS		C003_NET	SNMP
SOLARIS		C004_FS	SNMP
WINDOWS		C000_CPU	SNMP
WINDOWS		C001_MEM	SNMP
WINDOWS		C002_DSK	SNMP
WINDOWS		C003_NET	SNMP
WINDOWS		C004_FS	SNMP
NW_EQUIPMENT		C003_NET	SNMP
\.



---------------------------------------------------------------
-- ADD TABLE CONSTRAINT
---------------------------------------------------------------

ALTER TABLE ONLY jms_message_log
    ADD CONSTRAINT jms_message_log_pkey PRIMARY KEY (messageid, destination);

ALTER TABLE ONLY jms_reference_log
    ADD CONSTRAINT jms_reference_log_pkey PRIMARY KEY (messageid, destination);

ALTER TABLE ONLY cc_acc_lock
    ADD CONSTRAINT p_key_cc_acc_lock PRIMARY KEY (lock_id);

ALTER TABLE ONLY cc_action_inhibition_info
    ADD CONSTRAINT p_key_cc_action_inhibition_info PRIMARY KEY (notify_group_id, notify_id, facility_id);

ALTER TABLE ONLY cc_cal_add_info
    ADD CONSTRAINT p_key_cc_cal_add_info PRIMARY KEY (calendar_id, time_from, time_to);

ALTER TABLE ONLY cc_cal_info
    ADD CONSTRAINT p_key_cc_cal_info PRIMARY KEY (calendar_id);

ALTER TABLE ONLY cc_cal_weekday_info
    ADD CONSTRAINT p_key_cc_cal_weekday_info PRIMARY KEY (calendar_id, weekday, time_from, time_to);

ALTER TABLE ONLY cc_crun_cmd_mst
    ADD CONSTRAINT p_key_cc_crun_cmd_mst PRIMARY KEY (command_id);

ALTER TABLE ONLY cc_crun_cmd_param_mst
    ADD CONSTRAINT p_key_cc_crun_cmd_param_mst PRIMARY KEY (command_id, param_id);

ALTER TABLE ONLY cc_crun_end_mst
    ADD CONSTRAINT p_key_cc_crun_end_mst PRIMARY KEY (command_id, end_status);

ALTER TABLE ONLY cc_crun_param_mst
    ADD CONSTRAINT p_key_cc_crun_param_mst PRIMARY KEY (param_id);

ALTER TABLE ONLY cc_crun_param_select_mst
    ADD CONSTRAINT p_key_cc_crun_param_select_mst PRIMARY KEY (param_id, order_no);

ALTER TABLE ONLY cc_crun_session
    ADD CONSTRAINT p_key_cc_crun_session PRIMARY KEY (session_id);

ALTER TABLE ONLY cc_crun_session_detail
    ADD CONSTRAINT p_key_cc_crun_session_detail PRIMARY KEY (session_id, facility_id);

ALTER TABLE ONLY cc_crun_session_param
    ADD CONSTRAINT p_key_cc_crun_session_param PRIMARY KEY (session_id, param_id);

ALTER TABLE ONLY cc_crun_type_mst
    ADD CONSTRAINT p_key_cc_crun_type_mst PRIMARY KEY (type_id);

ALTER TABLE ONLY cc_event_log
    ADD CONSTRAINT p_key_cc_event_log PRIMARY KEY (monitor_id, plugin_id, output_date, facility_id);

ALTER TABLE ONLY cc_event_multi_info
    ADD CONSTRAINT p_key_cc_event_multi_info PRIMARY KEY (monitor_id, plugin_id, output_date, facility_id, multi_id);

ALTER TABLE ONLY cc_job_command_info
    ADD CONSTRAINT p_key_cc_job_command_info PRIMARY KEY (session_id, job_id);

ALTER TABLE ONLY cc_job_command_mst
    ADD CONSTRAINT p_key_cc_job_command_mst PRIMARY KEY (job_id);

ALTER TABLE ONLY cc_job_end_info
    ADD CONSTRAINT p_key_cc_job_end_info PRIMARY KEY (session_id, job_id, end_status);

ALTER TABLE ONLY cc_job_end_mst
    ADD CONSTRAINT p_key_cc_job_end_mst PRIMARY KEY (job_id, end_status);

ALTER TABLE ONLY cc_job_file_info
    ADD CONSTRAINT p_key_cc_job_file_info PRIMARY KEY (session_id, job_id);

ALTER TABLE ONLY cc_job_file_mst
    ADD CONSTRAINT p_key_cc_job_file_mst PRIMARY KEY (job_id);

ALTER TABLE ONLY cc_job_info
    ADD CONSTRAINT p_key_cc_job_info PRIMARY KEY (session_id, job_id);

ALTER TABLE ONLY cc_job_mst
    ADD CONSTRAINT p_key_cc_job_mst PRIMARY KEY (job_id);

ALTER TABLE ONLY cc_job_notice_info
    ADD CONSTRAINT p_key_cc_job_notice_info PRIMARY KEY (session_id, job_id, notice_type);

ALTER TABLE ONLY cc_job_notice_mst
    ADD CONSTRAINT p_key_cc_job_notice_mst PRIMARY KEY (job_id, notice_type);

ALTER TABLE ONLY cc_job_param_info
    ADD CONSTRAINT p_key_cc_job_param_info PRIMARY KEY (session_id, job_id, param_id);

ALTER TABLE ONLY cc_job_param_mst
    ADD CONSTRAINT p_key_cc_job_param_mst PRIMARY KEY (job_id, param_id);

ALTER TABLE ONLY cc_job_relation_info
    ADD CONSTRAINT p_key_cc_job_relation_info PRIMARY KEY (session_id, job_id, parent_job_id);

ALTER TABLE ONLY cc_job_relation_mst
    ADD CONSTRAINT p_key_cc_job_relation_mst PRIMARY KEY (job_id, parent_job_id);

ALTER TABLE ONLY cc_job_session
    ADD CONSTRAINT p_key_cc_job_session PRIMARY KEY (session_id);

ALTER TABLE ONLY cc_job_session_job
    ADD CONSTRAINT p_key_cc_job_session_job PRIMARY KEY (session_id, job_id);

ALTER TABLE ONLY cc_job_session_node
    ADD CONSTRAINT p_key_cc_job_session_node PRIMARY KEY (session_id, job_id, facility_id);

ALTER TABLE ONLY cc_job_start_info
    ADD CONSTRAINT p_key_cc_job_start_info PRIMARY KEY (session_id, job_id);

ALTER TABLE ONLY cc_job_start_job_info
    ADD CONSTRAINT p_key_cc_job_start_job_info PRIMARY KEY (session_id, job_id, target_job_id, target_job_type, target_job_end_value);

ALTER TABLE ONLY cc_job_start_job_mst
    ADD CONSTRAINT p_key_cc_job_start_job_mst PRIMARY KEY (job_id, target_job_id, target_job_type, target_job_end_value);

ALTER TABLE ONLY cc_job_start_mst
    ADD CONSTRAINT p_key_cc_job_start_mst PRIMARY KEY (job_id);

ALTER TABLE ONLY cc_job_start_time_info
    ADD CONSTRAINT p_key_cc_job_start_time_info PRIMARY KEY (session_id, job_id);

ALTER TABLE ONLY cc_job_start_time_mst
    ADD CONSTRAINT p_key_cc_job_start_time_mst PRIMARY KEY (job_id);

ALTER TABLE ONLY cc_log_transfer_file_info
    ADD CONSTRAINT p_key_cc_log_transfer_file_info PRIMARY KEY (transfer_id, file_path);

ALTER TABLE ONLY cc_log_transfer_info
    ADD CONSTRAINT p_key_cc_log_transfer_info PRIMARY KEY (transfer_id);

ALTER TABLE ONLY cc_mail_template_info
    ADD CONSTRAINT p_key_cc_mail_template_info PRIMARY KEY (mail_template_id);

ALTER TABLE ONLY cc_monitor_agent_info
    ADD CONSTRAINT p_key_cc_monitor_agent_info PRIMARY KEY (monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_http_info
    ADD CONSTRAINT p_key_cc_monitor_http_info PRIMARY KEY (monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_info
    ADD CONSTRAINT p_key_cc_monitor_info PRIMARY KEY (monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_notify_relation_info
    ADD CONSTRAINT p_key_cc_notify_relation_info PRIMARY KEY (notify_group_id, notify_id);

ALTER TABLE ONLY cc_monitor_numeric_value_info
    ADD CONSTRAINT p_key_cc_monitor_numeric_value_info PRIMARY KEY (monitor_type_id, monitor_id, priority);

ALTER TABLE ONLY cc_monitor_perf_info
    ADD CONSTRAINT p_key_cc_monitor_perf_info PRIMARY KEY (monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_ping_info
    ADD CONSTRAINT p_key_cc_monitor_ping_info PRIMARY KEY (monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_port_info
    ADD CONSTRAINT p_key_cc_monitor_port_info PRIMARY KEY (monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_process_info
    ADD CONSTRAINT p_key_cc_monitor_process_info PRIMARY KEY (monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_protocol_mst
    ADD CONSTRAINT p_key_cc_monitor_protocol_mst PRIMARY KEY (service_id);

ALTER TABLE ONLY cc_monitor_snmp_info
    ADD CONSTRAINT p_key_cc_monitor_snmp_info PRIMARY KEY (monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_snmp_value
    ADD CONSTRAINT p_key_cc_monitor_snmp_value PRIMARY KEY (monitor_id, facility_id);

ALTER TABLE ONLY cc_monitor_sql_info
    ADD CONSTRAINT p_key_cc_monitor_sql_info PRIMARY KEY (monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_string_value_info
    ADD CONSTRAINT p_key_cc_monitor_string_value_info PRIMARY KEY (monitor_type_id, monitor_id, order_no);

ALTER TABLE ONLY cc_monitor_truth_value_info
    ADD CONSTRAINT p_key_cc_monitor_truth_value_info PRIMARY KEY (monitor_type_id, monitor_id, priority, truth_value);

ALTER TABLE ONLY cc_notify_event_info
    ADD CONSTRAINT p_key_cc_notify_event_info PRIMARY KEY (notify_id, priority);

ALTER TABLE ONLY cc_notify_info
    ADD CONSTRAINT p_key_cc_notify_info PRIMARY KEY (notify_id);

ALTER TABLE ONLY cc_notify_job_info
    ADD CONSTRAINT p_key_cc_notify_job_info PRIMARY KEY (notify_id, priority);

ALTER TABLE ONLY cc_notify_log_escalate_info
    ADD CONSTRAINT p_key_cc_notify_log_escalate_info PRIMARY KEY (notify_id, priority);

ALTER TABLE ONLY cc_notify_mail_info
    ADD CONSTRAINT p_key_cc_notify_mail_info PRIMARY KEY (notify_id, priority);

ALTER TABLE ONLY cc_notify_status_info
    ADD CONSTRAINT p_key_cc_notify_status_info PRIMARY KEY (notify_id, priority);

ALTER TABLE ONLY cc_priority_info
    ADD CONSTRAINT p_key_cc_priority_info PRIMARY KEY (judgment_id);

ALTER TABLE ONLY cc_snmp_trap_info
    ADD CONSTRAINT p_key_cc_snmp_trap_info PRIMARY KEY (monitor_id);

ALTER TABLE ONLY cc_snmp_trap_mib_mst
    ADD CONSTRAINT p_key_cc_snmp_trap_mib_mst PRIMARY KEY (mib);

ALTER TABLE ONLY cc_snmp_trap_mst
    ADD CONSTRAINT p_key_cc_snmp_trap_mst PRIMARY KEY (mib, trap_oid, generic_id, specific_id);

ALTER TABLE ONLY cc_snmp_trap_oid_info
    ADD CONSTRAINT p_key_cc_snmp_trap_oid_info PRIMARY KEY (monitor_id, mib, trap_oid, generic_id, specific_id);

ALTER TABLE ONLY cc_status_info
    ADD CONSTRAINT p_key_cc_status_info PRIMARY KEY (facility_id, monitor_id, plugin_id);

ALTER TABLE ONLY cc_syslog_monitor_rule
    ADD CONSTRAINT p_key_cc_syslog_monitor_rule PRIMARY KEY (order_no);

ALTER TABLE ONLY cc_system_notify_event_info
    ADD CONSTRAINT p_key_cc_system_notify_event_info PRIMARY KEY (notify_id, priority);

ALTER TABLE ONLY cc_system_notify_info
    ADD CONSTRAINT p_key_cc_system_notify_info PRIMARY KEY (notify_id);

ALTER TABLE ONLY qrtz_blob_triggers
    ADD CONSTRAINT qrtz_blob_triggers_pkey PRIMARY KEY (trigger_name, trigger_group);

ALTER TABLE ONLY qrtz_calendars
    ADD CONSTRAINT qrtz_calendars_pkey PRIMARY KEY (calendar_name);

ALTER TABLE ONLY qrtz_cron_triggers
    ADD CONSTRAINT qrtz_cron_triggers_pkey PRIMARY KEY (trigger_name, trigger_group);

ALTER TABLE ONLY qrtz_fired_triggers
    ADD CONSTRAINT qrtz_fired_triggers_pkey PRIMARY KEY (entry_id);

ALTER TABLE ONLY qrtz_job_details
    ADD CONSTRAINT qrtz_job_details_pkey PRIMARY KEY (job_name, job_group);

ALTER TABLE ONLY qrtz_job_listeners
    ADD CONSTRAINT qrtz_job_listeners_pkey PRIMARY KEY (job_name, job_group, job_listener);

ALTER TABLE ONLY qrtz_locks
    ADD CONSTRAINT qrtz_locks_pkey PRIMARY KEY (lock_name);

ALTER TABLE ONLY qrtz_paused_trigger_grps
    ADD CONSTRAINT qrtz_paused_trigger_grps_pkey PRIMARY KEY (trigger_group);

ALTER TABLE ONLY qrtz_scheduler_state
    ADD CONSTRAINT qrtz_scheduler_state_pkey PRIMARY KEY (instance_name);

ALTER TABLE ONLY qrtz_simple_triggers
    ADD CONSTRAINT qrtz_simple_triggers_pkey PRIMARY KEY (trigger_name, trigger_group);

ALTER TABLE ONLY qrtz_trigger_listeners
    ADD CONSTRAINT qrtz_trigger_listeners_pkey PRIMARY KEY (trigger_name, trigger_group, trigger_listener);

ALTER TABLE ONLY qrtz_triggers
    ADD CONSTRAINT qrtz_triggers_pkey PRIMARY KEY (trigger_name, trigger_group);





ALTER TABLE ONLY cc_calculated_data
	ADD CONSTRAINT p_key_cc_calculated_data PRIMARY KEY (collectorid, item_code, display_name, date_time, facilityid);

ALTER TABLE ONLY cc_collector_calc_method_mst
	ADD CONSTRAINT p_key_cc_collector_calc_method_mst PRIMARY KEY (calc_method);

ALTER TABLE ONLY cc_collector_category_mst
	ADD CONSTRAINT p_key_cc_collector_category_mst PRIMARY KEY (category_code);

ALTER TABLE ONLY cc_collector_device_info
	ADD CONSTRAINT p_key_cc_collector_device_info PRIMARY KEY (collectorid, facilityid, display_name);

ALTER TABLE ONLY cc_collector_item
	ADD CONSTRAINT p_key_cc_collector_item PRIMARY KEY (collectorid, item_code, display_name);

ALTER TABLE ONLY cc_collector_item_calc_method_mst
	ADD CONSTRAINT p_key_cc_collector_item_calc_method_mst PRIMARY KEY (collect_method, platform_id, sub_platform_id, item_code);

ALTER TABLE ONLY cc_collector_item_code_mst
	ADD CONSTRAINT p_key_cc_collector_item_code_mst PRIMARY KEY (item_code);

ALTER TABLE ONLY cc_collector_platform_mst
	ADD CONSTRAINT p_key_cc_collector_platform_mst PRIMARY KEY (platform_id);

ALTER TABLE ONLY cc_collector_profile
	ADD CONSTRAINT p_key_cc_collector_profile PRIMARY KEY (collectorid);

ALTER TABLE ONLY cc_collector_scope_relation
	ADD CONSTRAINT p_key_cc_collector_scope_relation PRIMARY KEY (collectorid, facilityid, parent_facilityid);

ALTER TABLE ONLY cc_collector_scope_snap
	ADD CONSTRAINT p_key_cc_collector_scope_snap PRIMARY KEY (collectorid, facilityid);

ALTER TABLE ONLY cc_collector_polling_mst
	ADD CONSTRAINT p_key_cc_collector_polling_mst PRIMARY KEY (collect_method, platform_id, sub_platform_id, item_code, variable_id);

ALTER TABLE ONLY cc_collector_status
	ADD CONSTRAINT p_key_cc_collector_status PRIMARY KEY (collectorid);

ALTER TABLE ONLY cc_device_type_mst
	ADD CONSTRAINT p_key_cc_device_type_mst PRIMARY KEY (device_type);

ALTER TABLE ONLY cc_snmp_value_type_mst
	ADD CONSTRAINT p_key_cc_snmp_value_type_mst PRIMARY KEY (value_type);

ALTER TABLE ONLY cc_collector_category_collect_mst
	ADD CONSTRAINT p_key_cc_collector_category_collect_mst PRIMARY KEY (platform_id, sub_platform_id, category_code);






CREATE INDEX idx_cc_calculated_data_2 on cc_calculated_data(date_time, collectorid, facilityid);

CREATE INDEX idx_cc_calculated_data_3 on cc_calculated_data(collectorid, date_time);

CREATE INDEX idx_cc_event_log_3 on cc_event_log (output_date);

CREATE INDEX idx_cc_event_log_4 on cc_event_log (confirm_flg, priority, facility_id, output_date);

CREATE INDEX idx_cc_event_log_5 on cc_event_log (monitor_id, plugin_id, facility_id, inhibited_flg, generation_date);

CREATE INDEX idx_cc_job_relation_info_1 ON cc_job_relation_info USING btree (session_id, parent_job_id);

CREATE INDEX idx_cc_job_relation_mst_1 ON cc_job_relation_mst USING btree (parent_job_id);

CREATE INDEX idx_cc_job_session_job_1 ON cc_job_session_job USING btree (status);

CREATE INDEX idx_qrtz_ft_job_group ON qrtz_fired_triggers USING btree (job_group);

CREATE INDEX idx_qrtz_ft_job_name ON qrtz_fired_triggers USING btree (job_name);

CREATE INDEX idx_qrtz_ft_trig_group ON qrtz_fired_triggers USING btree (trigger_group);

CREATE INDEX idx_qrtz_ft_trig_inst_name ON qrtz_fired_triggers USING btree (instance_name);

CREATE INDEX idx_qrtz_ft_trig_n_g ON qrtz_fired_triggers USING btree (trigger_name, trigger_group);

CREATE INDEX idx_qrtz_ft_trig_name ON qrtz_fired_triggers USING btree (trigger_name);

CREATE INDEX idx_qrtz_t_next_fire_time ON qrtz_triggers USING btree (next_fire_time);

CREATE INDEX idx_qrtz_t_nf_st ON qrtz_triggers USING btree (trigger_state, next_fire_time);

CREATE INDEX idx_qrtz_t_state ON qrtz_triggers USING btree (trigger_state);


ALTER TABLE ONLY qrtz_job_listeners
    ADD CONSTRAINT "$1" FOREIGN KEY (job_name, job_group) REFERENCES qrtz_job_details(job_name, job_group);

ALTER TABLE ONLY qrtz_triggers
    ADD CONSTRAINT "$1" FOREIGN KEY (job_name, job_group) REFERENCES qrtz_job_details(job_name, job_group);

ALTER TABLE ONLY qrtz_simple_triggers
    ADD CONSTRAINT "$1" FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers(trigger_name, trigger_group);

ALTER TABLE ONLY qrtz_cron_triggers
    ADD CONSTRAINT "$1" FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers(trigger_name, trigger_group);

ALTER TABLE ONLY qrtz_blob_triggers
    ADD CONSTRAINT "$1" FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers(trigger_name, trigger_group);

ALTER TABLE ONLY qrtz_trigger_listeners
    ADD CONSTRAINT "$1" FOREIGN KEY (trigger_name, trigger_group) REFERENCES qrtz_triggers(trigger_name, trigger_group);

ALTER TABLE ONLY cc_action_inhibition_info
	ADD CONSTRAINT refcc_action_inhibition_info1 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id);

ALTER TABLE ONLY cc_cal_weekday_info
    ADD CONSTRAINT refcc_cal_info1 FOREIGN KEY (calendar_id) REFERENCES cc_cal_info(calendar_id);

ALTER TABLE ONLY cc_cal_add_info
    ADD CONSTRAINT refcc_cal_info2 FOREIGN KEY (calendar_id) REFERENCES cc_cal_info(calendar_id);

ALTER TABLE ONLY cc_crun_end_mst
    ADD CONSTRAINT refcc_crun_cmd_mst41 FOREIGN KEY (command_id) REFERENCES cc_crun_cmd_mst(command_id);

ALTER TABLE ONLY cc_crun_cmd_param_mst
    ADD CONSTRAINT refcc_crun_cmd_mst51 FOREIGN KEY (command_id) REFERENCES cc_crun_cmd_mst(command_id);

ALTER TABLE ONLY cc_crun_cmd_param_mst
    ADD CONSTRAINT refcc_crun_param_mst61 FOREIGN KEY (param_id) REFERENCES cc_crun_param_mst(param_id);

ALTER TABLE ONLY cc_crun_param_select_mst
    ADD CONSTRAINT refcc_crun_param_mst71 FOREIGN KEY (param_id) REFERENCES cc_crun_param_mst(param_id);

ALTER TABLE ONLY cc_crun_session_param
    ADD CONSTRAINT refcc_crun_session131 FOREIGN KEY (session_id) REFERENCES cc_crun_session(session_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_crun_session_detail
    ADD CONSTRAINT refcc_crun_session81 FOREIGN KEY (session_id) REFERENCES cc_crun_session(session_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_crun_cmd_mst
    ADD CONSTRAINT refcc_crun_type_mst14 FOREIGN KEY (type_id) REFERENCES cc_crun_type_mst(type_id);

ALTER TABLE ONLY cc_event_multi_info
    ADD CONSTRAINT refcc_event_log1 FOREIGN KEY (monitor_id, plugin_id, output_date, facility_id) REFERENCES cc_event_log(monitor_id, plugin_id, output_date, facility_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_notice_info
    ADD CONSTRAINT refcc_job_info10 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_start_job_info
    ADD CONSTRAINT refcc_job_info12 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_start_time_info
    ADD CONSTRAINT refcc_job_info13 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_command_info
    ADD CONSTRAINT refcc_job_info14 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_file_info
    ADD CONSTRAINT refcc_job_info15 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_param_info
    ADD CONSTRAINT refcc_job_info17 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_end_info
    ADD CONSTRAINT refcc_job_info9 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_start_info
    ADD CONSTRAINT refcc_job_info23 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_info(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_param_mst
    ADD CONSTRAINT refcc_job_mst10 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);

ALTER TABLE ONLY cc_job_end_mst
    ADD CONSTRAINT refcc_job_mst2 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);

ALTER TABLE ONLY cc_job_notice_mst
    ADD CONSTRAINT refcc_job_mst3 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);

ALTER TABLE ONLY cc_job_start_mst
    ADD CONSTRAINT refcc_job_mst4 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);

ALTER TABLE ONLY cc_job_start_job_mst
    ADD CONSTRAINT refcc_job_mst5 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);

ALTER TABLE ONLY cc_job_start_time_mst
    ADD CONSTRAINT refcc_job_mst6 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);

ALTER TABLE ONLY cc_job_command_mst
    ADD CONSTRAINT refcc_job_mst7 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);

ALTER TABLE ONLY cc_job_relation_mst
    ADD CONSTRAINT refcc_job_mst8 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);

ALTER TABLE ONLY cc_job_file_mst
    ADD CONSTRAINT refcc_job_mst9 FOREIGN KEY (job_id) REFERENCES cc_job_mst(job_id);

ALTER TABLE ONLY cc_job_session_job
    ADD CONSTRAINT refcc_job_session16 FOREIGN KEY (session_id) REFERENCES cc_job_session(session_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_session_node
    ADD CONSTRAINT refcc_job_session_job19 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_session_job(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_info
    ADD CONSTRAINT refcc_job_session_job20 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_session_job(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_job_relation_info
    ADD CONSTRAINT refcc_job_session_job22 FOREIGN KEY (session_id, job_id) REFERENCES cc_job_session_job(session_id, job_id) ON DELETE CASCADE;

ALTER TABLE ONLY cc_log_transfer_file_info
    ADD CONSTRAINT refcc_log_transfer_info1 FOREIGN KEY (transfer_id) REFERENCES cc_log_transfer_info(transfer_id);

ALTER TABLE ONLY cc_monitor_truth_value_info
    ADD CONSTRAINT refcc_monitor_info1 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_numeric_value_info
    ADD CONSTRAINT refcc_monitor_info2 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_process_info
    ADD CONSTRAINT refcc_monitor_info3 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_sql_info
    ADD CONSTRAINT refcc_monitor_info4 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_ping_info
    ADD CONSTRAINT refcc_monitor_info5 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_snmp_info
    ADD CONSTRAINT refcc_monitor_info6 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_string_value_info
    ADD CONSTRAINT refcc_monitor_info7 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_http_info
    ADD CONSTRAINT refcc_monitor_info8 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_perf_info
    ADD CONSTRAINT refcc_monitor_info9 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_port_info
    ADD CONSTRAINT refcc_monitor_info10 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_monitor_agent_info
    ADD CONSTRAINT refcc_monitor_info11 FOREIGN KEY (monitor_type_id, monitor_id) REFERENCES cc_monitor_info(monitor_type_id, monitor_id);

ALTER TABLE ONLY cc_snmp_trap_oid_info
    ADD CONSTRAINT refcc_snmp_trap_info1 FOREIGN KEY (monitor_id) REFERENCES cc_snmp_trap_info(monitor_id);

ALTER TABLE ONLY cc_snmp_trap_mst
    ADD CONSTRAINT refcc_snmp_trap_mib_mst1 FOREIGN KEY (mib) REFERENCES cc_snmp_trap_mib_mst(mib);

ALTER TABLE ONLY cc_snmp_trap_oid_info
    ADD CONSTRAINT refcc_snmp_trap_mst1 FOREIGN KEY (mib, trap_oid, generic_id, specific_id) REFERENCES cc_snmp_trap_mst(mib, trap_oid, generic_id, specific_id);

ALTER TABLE ONLY cc_system_notify_event_info
    ADD CONSTRAINT refcc_system_notify_info1 FOREIGN KEY (notify_id) REFERENCES cc_system_notify_info(notify_id);

--ALTER TABLE ONLY maintenance_info ADD CONSTRAINT ref_maintenance_info FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id);

ALTER TABLE ONLY cc_monitor_port_info
    ADD CONSTRAINT refcc_monitor_protocol_mst1 FOREIGN KEY (service_id) REFERENCES cc_monitor_protocol_mst(service_id);

ALTER TABLE ONLY cc_notify_mail_info
    ADD CONSTRAINT refcc_mail_template_info1 FOREIGN KEY (mail_template_id) REFERENCES cc_mail_template_info(mail_template_id);

ALTER TABLE ONLY cc_system_notify_info
    ADD CONSTRAINT refcc_mail_template_info2 FOREIGN KEY (mail_template_id) REFERENCES cc_mail_template_info(mail_template_id);





-- ALTER TABLE ONLY cc_calculated_data
--     ADD CONSTRAINT refcc_calculated_data1 FOREIGN KEY (collectorid) REFERENCES cc_collector_profile(collectorid);
-- ALTER TABLE ONLY cc_calculated_data
--     ADD CONSTRAINT refcc_calculated_data2 FOREIGN KEY (item_code) REFERENCES cc_collector_item_code_mst(item_code);

ALTER TABLE ONLY cc_collector_device_info
    ADD CONSTRAINT refcc_collector_device_info1 FOREIGN KEY (collectorid) REFERENCES cc_collector_profile(collectorid);
ALTER TABLE ONLY cc_collector_device_info
    ADD CONSTRAINT refcc_collector_device_info2 FOREIGN KEY (collectorid, facilityid) REFERENCES cc_collector_scope_snap(collectorid, facilityid);

ALTER TABLE ONLY cc_collector_item
    ADD CONSTRAINT refcc_collector_item1 FOREIGN KEY (collectorid) REFERENCES cc_collector_profile(collectorid);
ALTER TABLE ONLY cc_collector_item
    ADD CONSTRAINT refcc_collector_item2 FOREIGN KEY (item_code) REFERENCES cc_collector_item_code_mst(item_code);

ALTER TABLE ONLY cc_collector_item_calc_method_mst
    ADD CONSTRAINT refcc_collector_item_calc_method_mst1 FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);
ALTER TABLE ONLY cc_collector_item_calc_method_mst
    ADD CONSTRAINT refcc_collector_item_calc_method_mst2 FOREIGN KEY (item_code) REFERENCES cc_collector_item_code_mst(item_code);
ALTER TABLE ONLY cc_collector_item_calc_method_mst
    ADD CONSTRAINT refcc_collector_item_calc_method_mst3 FOREIGN KEY (calc_method) REFERENCES cc_collector_calc_method_mst(calc_method);

ALTER TABLE ONLY cc_collector_item_code_mst
    ADD CONSTRAINT refcc_collector_item_code_mst1 FOREIGN KEY (category_code) REFERENCES cc_collector_category_mst(category_code);

ALTER TABLE ONLY cc_collector_scope_relation
    ADD CONSTRAINT refcc_collector_scope_relation1 FOREIGN KEY (collectorid) REFERENCES cc_collector_profile(collectorid);
ALTER TABLE ONLY cc_collector_scope_relation
    ADD CONSTRAINT refcc_collector_scope_relation2 FOREIGN KEY (collectorid, facilityid) REFERENCES cc_collector_scope_snap(collectorid, facilityid);

ALTER TABLE ONLY cc_collector_scope_snap
    ADD CONSTRAINT refcc_collector_scope_snap1 FOREIGN KEY (collectorid) REFERENCES cc_collector_profile(collectorid);

ALTER TABLE ONLY cc_collector_polling_mst
    ADD CONSTRAINT refcc_collector_polling_mst1 FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);
ALTER TABLE ONLY cc_collector_polling_mst
    ADD CONSTRAINT refcc_collector_polling_mst2 FOREIGN KEY (item_code) REFERENCES cc_collector_item_code_mst(item_code);
ALTER TABLE ONLY cc_collector_polling_mst
    ADD CONSTRAINT refcc_collector_polling_mst3 FOREIGN KEY (value_type) REFERENCES cc_snmp_value_type_mst(value_type);

ALTER TABLE ONLY cc_collector_status
    ADD CONSTRAINT refcc_collector_status1 FOREIGN KEY (collectorid) REFERENCES cc_collector_profile(collectorid);

ALTER TABLE ONLY cc_collector_category_collect_mst
    ADD CONSTRAINT refcc_collector_category_collect_mst1 FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);
ALTER TABLE ONLY cc_collector_category_collect_mst
    ADD CONSTRAINT refcc_collector_category_collect_mst2 FOREIGN KEY (category_code) REFERENCES cc_collector_category_mst(category_code);

ALTER TABLE ONLY cc_monitor_process_method_mst
	ADD CONSTRAINT p_key_cc_monitor_process_method_mst PRIMARY KEY (platform_id, sub_platform_id);
ALTER TABLE ONLY cc_monitor_process_method_mst
    ADD CONSTRAINT refcc_monitor_process_method_mst1 FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);

ALTER TABLE ONLY cc_monitor_process_polling_mst
	ADD CONSTRAINT p_key_cc_monitor_process_polling_mst PRIMARY KEY (collect_method, platform_id, sub_platform_id, variable_id);
ALTER TABLE ONLY cc_monitor_process_polling_mst
    ADD CONSTRAINT refcc_monitor_process_polling_mst1 FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);

ALTER TABLE ONLY cc_vm_solution_mst
    ADD CONSTRAINT cc_vm_solution_mst_pkey PRIMARY KEY (vm_solution_id);
ALTER TABLE ONLY cc_vm_solution_mst
    ADD CONSTRAINT cc_vm_solution_mst_platform_id_fkey FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);

ALTER TABLE ONLY cc_vm_method_mst
    ADD CONSTRAINT cc_vm_method_mst_pkey PRIMARY KEY (vm_solution_id, proc_type);
ALTER TABLE ONLY cc_vm_method_mst
    ADD CONSTRAINT cc_vm_method_mst_vm_solution_id_fkey FOREIGN KEY (vm_solution_id) REFERENCES cc_vm_solution_mst(vm_solution_id);

ALTER TABLE ONLY cc_vm_protocol_mst
    ADD CONSTRAINT cc_vm_protocol_mst_pkey PRIMARY KEY (vm_solution_id, protocol);
ALTER TABLE ONLY cc_vm_protocol_mst
    ADD CONSTRAINT cc_vm_protocol_mst_vm_solution_id_fkey FOREIGN KEY (vm_solution_id) REFERENCES cc_vm_solution_mst(vm_solution_id);

ALTER TABLE ONLY cc_vm_operation_detail
    ADD CONSTRAINT cc_vm_operation_detail_pkey PRIMARY KEY (session_id, facility_id);








REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM hinemos;
GRANT ALL ON SCHEMA public TO hinemos;
GRANT ALL ON SCHEMA public TO PUBLIC;

END;

