/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.Agent;
import com.clustercontrol.repository.message.UpdateRepositoryInfo;
import java.io.Serializable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;

public class UpdateRepositoryInfoReceiveTopic
implements MessageListener,
ExceptionListener {
    private static final String TOPIC_CON_FACTORY = "ConnectionFactory";
    private static final long RETRY_INTERVAL = 10000L;
    private TopicConnectionFactory m_factory;
    protected TopicConnection m_con;
    protected Topic m_topic;
    protected TopicSession m_session;
    protected TopicSubscriber m_subscriber;
    protected Agent m_agent;
    private Properties m_props;
    private boolean m_errFlg = false;
    protected Timer m_timer = new Timer(true);

    public UpdateRepositoryInfoReceiveTopic(Agent agent, Properties props) {
        this.m_props = props;
        this.m_agent = agent;
        this.initial();
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            Serializable obj;
            ObjectMessage objectMessage = (ObjectMessage)message;
            try {
                obj = objectMessage.getObject();
            }
            catch (JMSException e) {
                return;
            }
            if (!(obj instanceof UpdateRepositoryInfo)) {
                return;
            }
        } else {
            return;
        }
        this.m_agent.setFacility();
    }

    public void onException(JMSException arg0) {
        this.setErrFlg(true);
        this.terminate();
    }

    private synchronized void setErrFlg(boolean errFlg) {
        if (!this.m_errFlg && errFlg) {
            this.m_timer.schedule((TimerTask)new ReSetupTask(), 10000L, 10000L);
        }
        this.m_errFlg = errFlg;
    }

    private synchronized boolean reInitial() {
        boolean ret = false;
        this.terminate();
        if (this.initial()) {
            ret = true;
            this.setErrFlg(false);
        }
        return ret;
    }

    public void terminate() {
        this.terminateSumscriber();
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private void terminateSumscriber() {
        try {
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initial() {
        InitialContext con = null;
        try {
            con = new InitialContext(this.m_props);
            this.m_factory = (TopicConnectionFactory)con.lookup(TOPIC_CON_FACTORY);
            this.m_con = this.m_factory.createTopicConnection();
            this.m_session = this.m_con.createTopicSession(false, 1);
            this.m_topic = (Topic)con.lookup("topic/clustercontrol/Repository/update");
            this.m_con.setExceptionListener((ExceptionListener)this);
            this.m_con.start();
            this.initialTopic();
        }
        catch (Exception e) {
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e1) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialTopic() {
        this.terminateSumscriber();
        try {
            this.m_subscriber = this.m_session.createSubscriber(this.m_topic);
            this.m_subscriber.setMessageListener((MessageListener)this);
        }
        catch (Exception e) {
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    protected class ReSetupTask
    extends TimerTask {
        protected ReSetupTask() {
        }

        public void run() {
            if (UpdateRepositoryInfoReceiveTopic.this.reInitial()) {
                this.cancel();
            }
        }
    }
}

