/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefine;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TextCellEditor;

public class TimePropertyDefine
extends PropertyDefine
implements Serializable {
    private static final long serialVersionUID = 4970684702759585048L;

    public TimePropertyDefine() {
        this.m_cellEditor = new TextCellEditor();
    }

    public String getColumnText(Object value) {
        if (value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            return formatter.format((Date)value);
        }
        return "";
    }

    public Object getValue(Property element) {
        Object value = element.getValue();
        if (value instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            return formatter.format((Date)value);
        }
        return "";
    }

    public void modify(Property element, Object value) {
        boolean check = false;
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date date = null;
        try {
            date = formatter.parse((String)value);
            check = true;
        }
        catch (ParseException e) {
            formatter = new SimpleDateFormat("HH:mm");
            try {
                date = formatter.parse((String)value);
                check = true;
            }
            catch (ParseException e1) {
                // empty catch block
            }
        }
        if (check) {
            element.setValue(date);
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString("message.hinemos.1"), (String)Messages.getString("message.hinemos.6"));
        }
    }

    public void initEditer() {
    }
}

