/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logagent;

import com.clustercontrol.logagent.ReceiveTopic;
import com.clustercontrol.logagent.SendQueue;
import com.clustercontrol.logagent.TransferLogManager;
import com.clustercontrol.logagent.UpdateRepositoryInfoReceiveTopic;
import com.clustercontrol.logagent.util.EjbConnectionManager;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent {
    public static final String PLUGIN_ID = "LOGAGENT";
    private Properties m_props;
    private EjbConnectionManager m_ejbConnectionManager;
    private ReceiveTopic m_receiveTopic;
    private SendQueue m_sendQueue;
    private UpdateRepositoryInfoReceiveTopic m_updateRepository;
    protected Timer m_timer = new Timer(true);
    private TransferLogManager m_transferManager;
    private int m_pollingInterval = 10;
    private static Log log = LogFactory.getLog(Agent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Agent agent = new Agent(args[0]);
        agent.exec();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                String line = br.readLine();
                if (line.equals("quit")) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Agent agent2 = agent;
            synchronized (agent2) {
                agent.wait();
            }
        }
        agent.terminate();
    }

    public Agent(String propFileName) throws Exception {
        this.m_props = new Properties();
        try {
            this.m_props.load(new FileInputStream(propFileName));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        String pollingInterval = this.m_props.getProperty("manager.polling.interval");
        if (pollingInterval != null) {
            try {
                this.m_pollingInterval = Integer.parseInt(pollingInterval);
            }
            catch (NumberFormatException e) {
                log.error((Object)"manager.polling.interval", (Throwable)e);
            }
        }
        this.m_ejbConnectionManager = new EjbConnectionManager(this.m_props);
        this.m_sendQueue = new SendQueue(this.m_props);
        this.m_transferManager = new TransferLogManager(this.m_ejbConnectionManager, this.m_sendQueue, this.m_props);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Agent.this.terminate();
            }
        });
    }

    public void exec() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"\u30c8\u30d4\u30c3\u30af\u63a5\u7d9a");
        }
        try {
            this.m_receiveTopic = new ReceiveTopic(this.getFacility(), this.m_transferManager, this.m_sendQueue, this.m_props);
        }
        catch (RemoteException e) {
            HashMap map = new HashMap();
            this.m_receiveTopic = new ReceiveTopic(map.values(), this.m_transferManager, this.m_sendQueue, this.m_props);
            log.error((Object)"exec(): Unable to connect to Hinemos manager. ", (Throwable)e);
        }
        catch (NamingException e) {
            HashMap map = new HashMap();
            this.m_receiveTopic = new ReceiveTopic(map.values(), this.m_transferManager, this.m_sendQueue, this.m_props);
            log.error((Object)"exec(): Unable to connect to Hinemos manager. ", (Throwable)e);
        }
        catch (CreateException e) {
            HashMap map = new HashMap();
            this.m_receiveTopic = new ReceiveTopic(map.values(), this.m_transferManager, this.m_sendQueue, this.m_props);
            log.error((Object)"exec(): Unable to connect to Hinemos manager. ", (Throwable)e);
        }
        catch (Exception e) {
            HashMap map = new HashMap();
            this.m_receiveTopic = new ReceiveTopic(map.values(), this.m_transferManager, this.m_sendQueue, this.m_props);
            log.error((Object)"exec(): Other exceptions were generated. ", (Throwable)e);
        }
        this.m_updateRepository = new UpdateRepositoryInfoReceiveTopic(this, this.m_props);
        this.m_timer.schedule((TimerTask)new ReflashFilterTask(), this.m_pollingInterval * 1000, (long)(this.m_pollingInterval * 1000));
    }

    public void terminateTransfer() {
        this.m_transferManager.stopTransfer();
    }

    public void setFacility() {
        try {
            this.m_receiveTopic.setFacilityIdList(this.getFacility());
        }
        catch (RemoteException e) {
            log.error((Object)"Unable to connect to Hinemos manager. ", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"Unable to connect to Hinemos manager. ", (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)"Unable to connect to Hinemos manager. ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Other exceptions were generated. ", (Throwable)e);
        }
    }

    public Collection<String> getFacility() throws Exception {
        HashMap<String, String> map;
        block16: {
            map = new HashMap<String, String>();
            RepositoryController repository = null;
            repository = this.m_ejbConnectionManager.getRepositoryController();
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                if (null == networkInterfaces) break block16;
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface ni = networkInterfaces.nextElement();
                    if (log.isDebugEnabled()) {
                        try {
                            log.debug((Object)("\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u691c\u51fa:\t" + new String(ni.getDisplayName().getBytes("iso-8859-1"))));
                        }
                        catch (UnsupportedEncodingException e) {
                            log.debug((Object)"\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u691c\u51fa:\t", (Throwable)e);
                        }
                    }
                    Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress in4 = inetAddresses.nextElement();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("IP/HOST\u691c\u51fa:\t" + in4.getHostAddress() + "/" + in4.getHostName()));
                        }
                        if (in4.getHostAddress().compareTo("127.0.0.1") == 0) continue;
                        ArrayList facilityIdList = repository.getFacilityIdList(in4.getHostName(), in4.getHostAddress());
                        if (log.isDebugEnabled() && facilityIdList.size() == 0) {
                            log.debug((Object)"\u5bfe\u5fdc\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u306a\u3057");
                        }
                        for (String facilityId : facilityIdList) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\u5bfe\u5fdc\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3:" + facilityId));
                            }
                            if (map.containsKey(facilityId)) continue;
                            map.put(facilityId, facilityId);
                        }
                    }
                }
            }
            catch (SocketException e) {
                log.debug((Object)"NetWorkInterfaces\u306e\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                log.debug((Object)"\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u60c5\u5831\u53d6\u5f97\u5931\u6557");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (FinderException e) {
                log.debug((Object)"\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u60c5\u5831\u53d6\u5f97\u5931\u6557");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NamingException e) {
                log.debug((Object)"\u30d5\u30a1\u30b7\u30ea\u30c6\u30a3\u60c5\u5831\u53d6\u5f97\u5931\u6557");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return map.values();
    }

    public void terminate() {
        this.m_receiveTopic.terminate();
        this.m_updateRepository.terminate();
        this.m_sendQueue.terminate();
        this.m_timer.cancel();
    }

    protected class ReflashFilterTask
    extends TimerTask {
        protected ReflashFilterTask() {
        }

        public void run() {
            Agent.this.setFacility();
        }
    }
}

