/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Wrapper;
import org.jboss.logging.Logger;
import org.jboss.metadata.WebMetaData;
import org.jboss.security.RunAsIdentity;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

public class RunAsListener
implements InstanceListener {
    public static ThreadLocal metaDataLocal = new ThreadLocal();
    private static Logger log = Logger.getLogger(RunAsListener.class);
    private WebMetaData metaData = (WebMetaData)metaDataLocal.get();

    public void instanceEvent(InstanceEvent event) {
        Wrapper servlet = event.getWrapper();
        String type = event.getType();
        if (servlet != null && this.metaData != null) {
            boolean trace = log.isTraceEnabled();
            String name = servlet.getName();
            RunAsIdentity identity = this.metaData.getRunAsIdentity(name);
            if (trace) {
                log.trace((Object)(name + ", runAs: " + identity));
            }
            if (type.equals("beforeInit") || type.equals("beforeDestroy")) {
                SecurityAssociationActions.pushRunAsIdentity(identity);
            } else if (type.equals("afterInit") || type.equals("afterDestroy")) {
                SecurityAssociationActions.popRunAsIdentity();
            }
        }
    }
}

