/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.JBossCacheService;

public abstract class JBossCacheClusteredSession
extends ClusteredSession {
    protected transient JBossCacheService proxy_;

    public JBossCacheClusteredSession(JBossCacheManager manager) {
        super(manager, manager.getUseJK());
        this.establishProxy();
    }

    public void initAfterLoad(AbstractJBossManager manager) {
        this.setManager(manager);
        this.establishProxy();
        this.populateAttributes();
        this.activate();
        this.clearOutdated();
    }

    protected void establishProxy() {
        if (this.proxy_ == null) {
            this.proxy_ = ((JBossCacheManager)this.manager).getCacheService();
            if (this.proxy_ == null) {
                throw new RuntimeException("JBossCacheClusteredSession: Cache service is null.");
            }
        }
    }

    protected abstract void populateAttributes();

    public void recycle() {
        super.recycle();
        this.proxy_ = null;
    }

    public synchronized void processSessionRepl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("processSessionRepl(): session is dirty. Will increment version from: " + this.getVersion() + " and replicate."));
        }
        this.incrementVersion();
        this.proxy_.putSession(this.realId, this);
        this.sessionAttributesDirty = false;
        this.sessionMetadataDirty = false;
        this.updateLastReplicated();
    }

    protected void removeFromManager(boolean localCall, boolean localOnly) {
        if (localCall) {
            super.removeFromManager(localCall, localOnly);
        }
    }

    protected Object removeAttributeInternal(String name, boolean localCall, boolean localOnly) {
        return this.removeJBossInternalAttribute(name, localCall, localOnly);
    }

    protected Object removeJBossInternalAttribute(String name) {
        throw new UnsupportedOperationException("removeJBossInternalAttribute(String) is not supported by JBossCacheClusteredSession; use removeJBossInternalAttribute(String, boolean, boolean");
    }

    protected abstract Object removeJBossInternalAttribute(String var1, boolean var2, boolean var3);
}

