/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.factory;

import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.entity.SyslogMonitorRuleLocal;
import com.clustercontrol.syslogng.ejb.entity.SyslogMonitorRuleUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectMonitorRule {
    protected static Log m_log = LogFactory.getLog(SelectMonitorRule.class);

    public ArrayList<LogFilterInfo> getFilterInfoList() throws CreateException, FinderException, NamingException {
        ArrayList<LogFilterInfo> list = null;
        try {
            Collection ct = SyslogMonitorRuleUtil.getLocalHome().findAllByOrderNoOrder();
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            list = new ArrayList<LogFilterInfo>();
            for (SyslogMonitorRuleLocal moniterRule : ct) {
                NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
                Collection notifyId = nc.getNotifyRelation(moniterRule.getNotifyGroupId());
                LogFilterInfo filterInfo = new LogFilterInfo();
                filterInfo.setOrderNo(moniterRule.getOrderNo());
                filterInfo.setDescription(moniterRule.getDescription());
                String facilityPath = repository.getFacilityPath(moniterRule.getFacilityId(), null);
                filterInfo.setFacilityId(moniterRule.getFacilityId());
                filterInfo.setScope(facilityPath);
                filterInfo.setPattern(moniterRule.getPattern());
                filterInfo.setProcessType(moniterRule.getProcessType());
                filterInfo.setPriority(moniterRule.getPriority());
                filterInfo.setMonitorId(moniterRule.getMonitorId());
                filterInfo.setApplication(moniterRule.getApplication());
                filterInfo.setMessageId(moniterRule.getMessageId());
                filterInfo.setMessage(moniterRule.getMessage());
                filterInfo.setNotifyGroupId(moniterRule.getNotifyGroupId());
                filterInfo.setCalendarId(moniterRule.getCalendarId());
                filterInfo.setValid(moniterRule.getValidFlg());
                filterInfo.setNotifyId(notifyId);
                filterInfo.setRegDate(moniterRule.getRegDate());
                filterInfo.setUpdateDate(moniterRule.getUpdateDate());
                filterInfo.setRegUser(moniterRule.getRegUser());
                filterInfo.setUpdateUser(moniterRule.getUpdateUser());
                list.add(filterInfo);
            }
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            Object[] args = null;
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("getFilterInfoList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            Object[] args = null;
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("getFilterInfoList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("SLOGNG", "slogng");
            Object[] args = null;
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("getFilterInfoList():" + e.getMessage()));
            throw e;
        }
        return list;
    }
}

