/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.http.util;

import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoLocal;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoPK;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoUtil;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ControlHttpInfo {
    protected static Log m_log = LogFactory.getLog(ControlHttpInfo.class);
    protected String m_monitorTypeId;
    protected String m_monitorId;

    public ControlHttpInfo(String monitorId, String monitorTypeId) {
        this.m_monitorId = monitorId;
        this.m_monitorTypeId = monitorTypeId;
    }

    public MonitorHttpInfo get() throws FinderException, NamingException {
        MonitorHttpInfoPK pk = new MonitorHttpInfoPK(this.m_monitorId, this.m_monitorTypeId);
        MonitorHttpInfoLocal httpLocal = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(pk);
        MonitorHttpInfo http = new MonitorHttpInfo();
        http.setMonitorTypeId(this.m_monitorTypeId);
        http.setMonitorId(this.m_monitorId);
        http.setRequestUrl(httpLocal.getRequestUrl());
        http.setTimeout(httpLocal.getTimeout());
        http.setUrlReplace(httpLocal.getUrlReplace());
        http.setProxySet(httpLocal.getProxySet());
        http.setProxyHost(httpLocal.getProxyHost());
        http.setProxyPort(httpLocal.getProxyPort());
        return http;
    }

    public boolean add(MonitorHttpInfo http) throws CreateException, NamingException {
        MonitorHttpInfoUtil.getLocalHome().create(this.m_monitorTypeId, this.m_monitorId, http.getRequestUrl(), http.getTimeout(), http.getUrlReplace(), http.getProxySet(), http.getProxyHost(), http.getProxyPort());
        return true;
    }

    public boolean modify(MonitorHttpInfo http) throws CreateException, FinderException, NamingException {
        MonitorHttpInfoPK pk = new MonitorHttpInfoPK(this.m_monitorId, this.m_monitorTypeId);
        MonitorHttpInfoLocal httpLocal = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(pk);
        httpLocal.setRequestUrl(http.getRequestUrl());
        httpLocal.setUrlReplace(http.getUrlReplace());
        httpLocal.setTimeout(http.getTimeout());
        httpLocal.setProxySet(http.getProxySet());
        httpLocal.setProxyHost(http.getProxyHost());
        httpLocal.setProxyPort(http.getProxyPort());
        return true;
    }

    public boolean delete() throws FinderException, RemoveException, NamingException {
        MonitorHttpInfoPK pk = new MonitorHttpInfoPK(this.m_monitorId, this.m_monitorTypeId);
        MonitorHttpInfoLocal httpLocal = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(pk);
        httpLocal.remove();
        return true;
    }
}

