/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.quartz.Calendar;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.spi.TriggerFiredBundle;

public class JobExecutionContext
implements Serializable {
    private transient Scheduler scheduler;
    private Trigger trigger;
    private JobDetail jobDetail;
    private transient Job job;
    private Calendar calendar;
    private boolean recovering = false;
    private int numRefires = 0;
    private Date fireTime;
    private Date scheduledFireTime;
    private Date prevFireTime;
    private Date nextFireTime;
    private long jobRunTime = -1L;
    private Object result;
    private HashMap data = new HashMap();

    public JobExecutionContext(Scheduler scheduler, TriggerFiredBundle firedBundle, Job job) {
        this.scheduler = scheduler;
        this.trigger = firedBundle.getTrigger();
        this.calendar = firedBundle.getCalendar();
        this.jobDetail = firedBundle.getJobDetail();
        this.job = job;
        this.recovering = firedBundle.isRecovering();
        this.fireTime = firedBundle.getFireTime();
        this.scheduledFireTime = firedBundle.getScheduledFireTime();
        this.prevFireTime = firedBundle.getPrevFireTime();
        this.nextFireTime = firedBundle.getNextFireTime();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public boolean isRecovering() {
        return this.recovering;
    }

    public void incrementRefireCount() {
        ++this.numRefires;
    }

    public int getRefireCount() {
        return this.numRefires;
    }

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    public Job getJobInstance() {
        return this.job;
    }

    public Date getFireTime() {
        return this.fireTime;
    }

    public Date getScheduledFireTime() {
        return this.scheduledFireTime;
    }

    public Date getPreviousFireTime() {
        return this.prevFireTime;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public String toString() {
        return "JobExecutionContext: trigger: '" + this.getTrigger().getFullName() + " job: " + this.getJobDetail().getFullName() + " fireTime: '" + this.getFireTime() + " scheduledFireTime: " + this.getScheduledFireTime() + " previousFireTime: '" + this.getPreviousFireTime() + " nextFireTime: " + this.getNextFireTime() + " isRecovering: " + this.isRecovering() + " refireCount: " + this.getRefireCount();
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public long getJobRunTime() {
        return this.jobRunTime;
    }

    public void setJobRunTime(long jobRunTime) {
        this.jobRunTime = jobRunTime;
    }

    public void put(Object key, Object value) {
        this.data.put(key, value);
    }

    public Object get(Object key) {
        return this.data.get(key);
    }
}

