/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.InheritableAnnotationHolder;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class ClassInfoImpl
extends InheritableAnnotationHolder
implements ClassInfo {
    private static final long serialVersionUID = 3545798779904340792L;
    static final ClassInfo UNKNOWN_CLASS = new UnknownClassInfo();
    static final InterfaceInfo[] UNKNOWN_INTERFACES = new InterfaceInfo[0];
    static final ConstructorInfo[] UNKNOWN_CONSTRUCTORS = new ConstructorInfo[0];
    static final MethodInfo[] UNKNOWN_METHODS = new MethodInfo[0];
    private static final FieldInfo[] UNKNOWN_FIELDS = new FieldInfo[0];
    protected String name;
    protected int modifiers;
    protected InterfaceInfo[] interfaces = UNKNOWN_INTERFACES;
    protected MethodInfo[] methods = UNKNOWN_METHODS;
    protected FieldInfo[] fields = UNKNOWN_FIELDS;
    protected HashMap fieldMap;
    protected ClassInfo superclass = UNKNOWN_CLASS;
    protected ConstructorInfo[] constructors = UNKNOWN_CONSTRUCTORS;

    public static MethodInfo findMethod(MethodInfo[] methods, String name, TypeInfo[] parameters) {
        if (methods == null) {
            return null;
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || methods[i].getParameterTypes().length != parameters.length) continue;
            boolean ok = true;
            for (int j = 0; j < parameters.length; ++j) {
                if (parameters[j].equals(methods[i].getParameterTypes()[j])) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return methods[i];
        }
        return null;
    }

    public ClassInfoImpl() {
    }

    public ClassInfoImpl(String name) {
        this.name = name;
    }

    public ClassInfoImpl(String name, int modifiers, InterfaceInfo[] interfaces, ClassInfoImpl superclass) {
        this.name = name;
        this.modifiers = modifiers;
        this.interfaces = interfaces;
        this.superclass = superclass;
    }

    public void setType(Class type) {
        this.setAnnotatedElement(type);
    }

    public void setInterfaces(InterfaceInfo[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setDeclaredMethods(MethodInfoImpl[] methods) {
        this.methods = methods;
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                methods[i].declaringClass = this;
            }
        }
    }

    public void setDeclaredFields(FieldInfoImpl[] fields) {
        this.fields = fields;
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                fields[i].declaringClass = this;
            }
        }
    }

    public void setDeclaredConstructors(ConstructorInfoImpl[] constructors) {
        this.constructors = constructors;
        if (constructors != null) {
            for (int i = 0; i < constructors.length; ++i) {
                constructors[i].declaringClass = this;
            }
        }
    }

    public void setSuperclass(ClassInfo superInfo) {
        this.superclass = superInfo;
    }

    public boolean isInterface() {
        return false;
    }

    public InterfaceInfo[] getInterfaces() {
        if (this.interfaces == UNKNOWN_INTERFACES) {
            this.setInterfaces(this.typeInfoFactory.getInterfaces(this.getType()));
        }
        return this.interfaces;
    }

    public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters) {
        return ClassInfoImpl.findMethod(this.methods, name, parameters);
    }

    public MethodInfo[] getDeclaredMethods() {
        if (this.methods == UNKNOWN_METHODS) {
            this.setDeclaredMethods(this.typeInfoFactory.getMethods(this.getType(), this));
        }
        return this.methods;
    }

    public FieldInfo getDeclaredField(String name) {
        if (this.fields == UNKNOWN_FIELDS) {
            this.setDeclaredFields(this.typeInfoFactory.getFields(this.getType(), this));
        }
        return (FieldInfo)this.fieldMap.get(name);
    }

    public FieldInfo[] getDeclaredFields() {
        if (this.fields == UNKNOWN_FIELDS) {
            this.setDeclaredFields(this.typeInfoFactory.getFields(this.getType(), this));
        }
        return this.fields;
    }

    public ConstructorInfo[] getDeclaredConstructors() {
        if (this.constructors == UNKNOWN_CONSTRUCTORS) {
            this.setDeclaredConstructors(this.typeInfoFactory.getConstructors(this.getType(), this));
        }
        return this.constructors;
    }

    public ClassInfo getSuperclass() {
        if (this.superclass == UNKNOWN_CLASS) {
            this.setSuperclass(this.typeInfoFactory.getSuperClass(this.getType()));
        }
        return this.superclass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return (Class)this.annotatedElement;
    }

    protected InheritableAnnotationHolder getSuperHolder() {
        return (ClassInfoImpl)this.getSuperclass();
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ClassInfoImpl)) {
            return false;
        }
        ClassInfoImpl other = (ClassInfoImpl)obj;
        return !(this.name != null ? !this.name.equals(other.name) : other.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    static class UnknownClassInfo
    implements ClassInfo {
        UnknownClassInfo() {
        }

        public ConstructorInfo[] getDeclaredConstructors() {
            return null;
        }

        public FieldInfo getDeclaredField(String name) {
            return null;
        }

        public FieldInfo[] getDeclaredFields() {
            return null;
        }

        public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters) {
            return null;
        }

        public MethodInfo[] getDeclaredMethods() {
            return null;
        }

        public InterfaceInfo[] getInterfaces() {
            return null;
        }

        public String getName() {
            return null;
        }

        public ClassInfo getSuperclass() {
            return null;
        }

        public boolean isInterface() {
            return false;
        }

        public AnnotationValue getAnnotation(String name) {
            return null;
        }

        public AnnotationValue[] getAnnotations() {
            return null;
        }

        public boolean isAnnotationPresent(String name) {
            return false;
        }

        public String toShortString() {
            return null;
        }

        public void toShortString(JBossStringBuilder buffer) {
        }

        public Class getType() {
            return null;
        }

        public int getModifiers() {
            return 0;
        }

        public boolean isPublic() {
            return false;
        }

        public boolean isStatic() {
            return false;
        }

        public Object clone() {
            return null;
        }
    }
}

