/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.client.HTTPRemotingConnection;
import org.jboss.ws.core.client.RemotingConnection;
import org.jboss.ws.core.client.RemotingConnectionImpl;
import org.jboss.ws.core.client.SOAPRemotingConnection;
import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
import org.jboss.ws.core.jaxws.client.DispatchHTTPBinding;
import org.jboss.ws.core.jaxws.client.DispatchSOAPBinding;
import org.jboss.ws.core.jaxws.client.ResponseImpl;
import org.jboss.ws.metadata.umdm.EndpointMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchImpl<T>
implements Dispatch<T> {
    private final Logger log = Logger.getLogger(DispatchImpl.class);
    private BindingProvider bindingProvider;
    private EndpointMetaData epMetaData;
    private JAXBContext jaxbContext;
    private ExecutorService executor;
    private Class type;
    private Service.Mode mode;

    public DispatchImpl(ExecutorService executor, EndpointMetaData epMetaData, Class<T> type, Service.Mode mode) {
        this.bindingProvider = new BindingProviderImpl(epMetaData);
        this.epMetaData = epMetaData;
        this.executor = executor;
        this.type = type;
        this.mode = mode;
        this.initDispatch();
    }

    public DispatchImpl(ExecutorService executor, EndpointMetaData epMetaData, JAXBContext jbc, Service.Mode mode) {
        this.bindingProvider = new BindingProviderImpl(epMetaData);
        this.epMetaData = epMetaData;
        this.executor = executor;
        this.type = Object.class;
        this.jaxbContext = jbc;
        this.mode = mode;
        this.initDispatch();
    }

    public T invoke(T obj) {
        Object retObj = null;
        try {
            retObj = this.invokeInternal(obj, this.getResponseContext());
        }
        catch (Exception ex) {
            this.handleInvokeException(ex);
        }
        return (T)retObj;
    }

    private Object invokeInternal(Object obj, Map<String, Object> resContext) throws IOException {
        MessageAbstraction reqMsg = this.getRequestMessage(obj);
        String targetAddress = this.epMetaData.getEndpointAddress();
        String bindingID = this.bindingProvider.getBinding().getBindingID();
        if (bindingID.indexOf("soap") > 0) {
            String soapAction = null;
            Map<String, Object> reqContext = this.getRequestContext();
            Boolean useSOAPAction = (Boolean)reqContext.get("javax.xml.ws.soap.http.soapaction.use");
            if (Boolean.TRUE.equals(useSOAPAction) && (soapAction = (String)reqContext.get("javax.xml.ws.soap.http.soapaction.uri")) == null) {
                throw new IllegalStateException("Cannot obtain: javax.xml.ws.soap.http.soapaction.uri");
            }
            MimeHeaders mimeHeaders = reqMsg.getMimeHeaders();
            mimeHeaders.addHeader("SOAPAction", soapAction != null ? soapAction : "");
        }
        MessageAbstraction resMsg = this.getRemotingConnection().invoke(reqMsg, targetAddress, false);
        Object retObj = this.getReturnObject(resMsg);
        return retObj;
    }

    private RemotingConnection getRemotingConnection() {
        String bindingID = this.bindingProvider.getBinding().getBindingID();
        if (!EndpointMetaData.SUPPORTED_BINDINGS.contains(bindingID)) {
            throw new IllegalStateException("Unsupported binding: " + bindingID);
        }
        RemotingConnectionImpl remotingConnection = "http://www.w3.org/2004/08/wsdl/http".equals(bindingID) ? new HTTPRemotingConnection() : new SOAPRemotingConnection();
        return remotingConnection;
    }

    public Response<T> invokeAsync(T msg) {
        ResponseImpl response = new ResponseImpl();
        AsyncRunnable task = new AsyncRunnable(response, null, msg);
        Future<?> future = this.executor.submit(task);
        response.setFuture(future);
        return response;
    }

    public Future invokeAsync(T obj, AsyncHandler<T> handler) {
        ResponseImpl response = new ResponseImpl();
        AsyncRunnable task = new AsyncRunnable(response, handler, obj);
        Future<?> future = this.executor.submit(task);
        response.setFuture(future);
        return response;
    }

    public void invokeOneWay(T msg) {
        try {
            MessageAbstraction reqMsg = this.getRequestMessage(msg);
            String targetAddress = this.epMetaData.getEndpointAddress();
            this.getRemotingConnection().invoke(reqMsg, targetAddress, true);
        }
        catch (Exception ex) {
            this.handleInvokeException(ex);
        }
    }

    private void handleInvokeException(Exception ex) {
        if (ex instanceof WebServiceException) {
            throw (WebServiceException)ex;
        }
        String msg = "Cannot dispatch message";
        this.log.error((Object)msg, (Throwable)ex);
        throw new WebServiceException(msg, (Throwable)ex);
    }

    public Map<String, Object> getRequestContext() {
        return this.bindingProvider.getRequestContext();
    }

    public Map<String, Object> getResponseContext() {
        return this.bindingProvider.getResponseContext();
    }

    public Binding getBinding() {
        return this.bindingProvider.getBinding();
    }

    private void initDispatch() {
        if (!(SOAPMessage.class.isAssignableFrom(this.type) && this.mode == Service.Mode.MESSAGE || Source.class.isAssignableFrom(this.type) || this.jaxbContext != null && this.mode == Service.Mode.PAYLOAD)) {
            throw new WebServiceException("Illegal argument combination [type=" + (this.type != null ? this.type.getName() : null) + ",mode=" + this.mode + "]");
        }
    }

    private MessageAbstraction getRequestMessage(Object obj) {
        MessageAbstraction message;
        if (obj == null) {
            throw new SOAPFaultException("Request object cannot be null");
        }
        String bindingID = this.bindingProvider.getBinding().getBindingID();
        if (!EndpointMetaData.SUPPORTED_BINDINGS.contains(bindingID)) {
            throw new IllegalStateException("Unsupported binding: " + bindingID);
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID)) {
            DispatchHTTPBinding helper = new DispatchHTTPBinding(this.mode, this.type, this.jaxbContext);
            this.epMetaData.configure(helper);
            message = helper.getRequestMessage(obj);
        } else {
            DispatchSOAPBinding helper = new DispatchSOAPBinding(this.mode, this.type, this.jaxbContext);
            this.epMetaData.configure(helper);
            message = helper.getRequestMessage(obj);
        }
        return message;
    }

    private Object getReturnObject(MessageAbstraction resMsg) {
        String bindingID = this.bindingProvider.getBinding().getBindingID();
        if (!EndpointMetaData.SUPPORTED_BINDINGS.contains(bindingID)) {
            throw new IllegalStateException("Unsupported binding: " + bindingID);
        }
        Object retObj = null;
        if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID)) {
            DispatchHTTPBinding helper = new DispatchHTTPBinding(this.mode, this.type, this.jaxbContext);
            retObj = helper.getReturnObject(resMsg);
        } else {
            DispatchSOAPBinding helper = new DispatchSOAPBinding(this.mode, this.type, this.jaxbContext);
            retObj = helper.getReturnObject(resMsg);
        }
        return retObj;
    }

    public EndpointReference getEndpointReference() {
        throw new NotImplementedException();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        throw new NotImplementedException();
    }

    class AsyncRunnable
    implements Runnable {
        private ResponseImpl response;
        private AsyncHandler handler;
        private Object payload;

        public AsyncRunnable(ResponseImpl response, AsyncHandler handler, Object payload) {
            if (response == null) {
                throw new IllegalArgumentException("Async response cannot be null");
            }
            if (payload == null) {
                throw new IllegalArgumentException("Async payload cannot be null");
            }
            this.response = response;
            this.handler = handler;
            this.payload = payload;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Map<String, Object> resContext = this.response.getContext();
                Object result = DispatchImpl.this.invokeInternal(this.payload, resContext);
                this.response.set(result);
            }
            catch (Exception ex) {
                this.handleAsynInvokeException(ex);
            }
            finally {
                if (this.handler != null) {
                    this.handler.handleResponse((Response)this.response);
                }
            }
        }

        private void handleAsynInvokeException(Exception ex) {
            String msg = "Cannot dispatch message";
            DispatchImpl.this.log.error((Object)msg, (Throwable)ex);
            WebServiceException wsex = ex instanceof WebServiceException ? (WebServiceException)ex : new WebServiceException(msg, (Throwable)ex);
            this.response.setException(wsex);
        }
    }
}

