/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.jboss.logging.Logger;

public class JBossLogHandler
extends Handler {
    public JBossLogHandler() {
        super.setFormatter(new SimpleFormatter());
    }

    public void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().formatMessage(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        if (record.getLevel() == Level.INFO) {
            Logger.getLogger((String)record.getSourceClassName()).info((Object)msg);
        } else if (record.getLevel() == Level.SEVERE) {
            Logger.getLogger((String)record.getSourceClassName()).error((Object)msg);
        } else if (record.getLevel() == Level.WARNING) {
            Logger.getLogger((String)record.getSourceClassName()).warn((Object)msg);
        } else if (record.getLevel() == Level.FINE) {
            Logger.getLogger((String)record.getSourceClassName()).debug((Object)msg);
        } else if (record.getLevel() == Level.FINER || record.getLevel() == Level.FINEST) {
            Logger.getLogger((String)record.getSourceClassName()).trace((Object)msg);
        } else {
            Logger.getLogger((String)record.getSourceClassName()).debug((Object)msg);
        }
    }

    public boolean isLoggable(LogRecord record) {
        if (record == null) {
            return false;
        }
        return super.isLoggable(record);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

