/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.jmx;

import com.clustercontrol.performance.ejb.bmp.Collector;
import com.clustercontrol.performance.ejb.bmp.CollectorHome;
import com.clustercontrol.performance.util.JNDIConnectionManager;
import java.rmi.RemoteException;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceRestartManager {
    protected static Log m_log = LogFactory.getLog(PerformanceRestartManager.class);

    public void restartAll() {
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collection pks = home.findAll();
            for (Collector collector : pks) {
                if (collector.getCollectorType() == 1 || collector.getCollectorType() == 3) {
                    m_log.debug((Object)("set StopDate " + collector.getCollectorID()));
                    collector.setStopDate(null);
                } else {
                    m_log.debug((Object)("check StopTime " + collector.getCollectorID()));
                    if (collector.getStopDate() != null && System.currentTimeMillis() >= collector.getStopDate().getTime()) continue;
                }
                boolean restarted = collector.restartCollect();
                m_log.debug((Object)("restart " + collector.getCollectorID() + " " + restarted));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (FinderException e) {
            e.printStackTrace();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public void refreshRepositoryAll() {
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collection pks = home.findAll();
            for (Collector collector : pks) {
                if (collector.getCollectorType() != 1 && collector.getCollectorType() != 3) continue;
                collector.stopCollect();
                collector.updateScopeTree();
                collector.setStopDate(null);
                boolean restarted = collector.restartCollect();
                m_log.debug((Object)("restart " + collector.getCollectorID() + " " + restarted));
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (FinderException e) {
            e.printStackTrace();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

