/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.Connection;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.TransactionRequest;

public class SpyXAResourceManager
implements Serializable {
    static final long serialVersionUID = -6268132972627753772L;
    private static final Logger log = Logger.getLogger((Class)SpyXAResourceManager.class);
    private static boolean trace = log.isTraceEnabled();
    private static final byte TX_OPEN = 0;
    private static final byte TX_ENDED = 1;
    private static final byte TX_PREPARED = 3;
    private static final byte TX_COMMITED = 4;
    private static final byte TX_ROLLEDBACK = 5;
    private static final byte TX_READONLY = 6;
    private Connection connection;
    private Map transactions = new ConcurrentReaderHashMap();
    private long nextInternalXid = Long.MIN_VALUE;

    public SpyXAResourceManager(Connection conn) {
        this.connection = conn;
    }

    public void ackMessage(Object xid, SpyMessage msg) throws JMSException {
        TXState state;
        if (xid == null) {
            if (trace) {
                log.trace((Object)("No Xid, acking message " + msg.header.jmsMessageID));
            }
            msg.doAcknowledge();
            return;
        }
        if (trace) {
            log.trace((Object)("Adding acked message xid=" + xid + " " + msg.header.jmsMessageID));
        }
        if ((state = (TXState)this.transactions.get(xid)) == null) {
            throw new JMSException("Invalid transaction id.");
        }
        AcknowledgementRequest item = msg.getAcknowledgementRequest(true);
        state.ackedMessages.add(item);
    }

    public void addMessage(Object xid, SpyMessage msg) throws JMSException {
        if (xid == null) {
            if (trace) {
                log.trace((Object)("No Xid, sending message to server " + msg.header.jmsMessageID));
            }
            this.connection.sendToServer(msg);
            return;
        }
        if (trace) {
            log.trace((Object)("Adding message xid=" + xid + ", message=" + msg.header.jmsMessageID));
        }
        TXState state = (TXState)this.transactions.get(xid);
        if (trace) {
            log.trace((Object)("TXState=" + state));
        }
        if (state == null) {
            throw new JMSException("Invalid transaction id.");
        }
        state.sentMessages.add(msg);
    }

    public void commit(Object xid, boolean onePhase) throws XAException, JMSException {
        TXState state;
        if (trace) {
            log.trace((Object)("Commiting xid=" + xid + ", onePhase=" + onePhase));
        }
        if ((state = (TXState)this.transactions.remove(xid)) == null) {
            XAException e = new XAException("Unknown transaction during commit " + xid);
            e.errorCode = -4;
            throw e;
        }
        if (onePhase) {
            Externalizable[] job;
            if (state.isReadOnly() && trace) {
                log.trace((Object)("Nothing to do for " + xid));
            }
            TransactionRequest transaction = new TransactionRequest();
            transaction.requestType = 0;
            transaction.xid = null;
            if (state.sentMessages.size() != 0) {
                job = new SpyMessage[state.sentMessages.size()];
                job = state.sentMessages.toArray(job);
                transaction.messages = job;
            }
            if (state.ackedMessages.size() != 0) {
                job = new AcknowledgementRequest[state.ackedMessages.size()];
                job = (AcknowledgementRequest[])state.ackedMessages.toArray(job);
                transaction.acks = job;
            }
            this.connection.send(transaction);
        } else {
            if (state.txState == 6) {
                if (trace) {
                    log.trace((Object)("Nothing to do for " + xid));
                }
                return;
            }
            if (state.txState != 3) {
                XAException e = new XAException("Cannot complete 2 phase commit, the transaction has not been prepared " + xid);
                e.errorCode = -6;
                throw e;
            }
            TransactionRequest transaction = new TransactionRequest();
            transaction.xid = xid;
            transaction.requestType = (byte)2;
            this.connection.send(transaction);
        }
        state.txState = (byte)4;
    }

    public void endTx(Object xid, boolean success) throws XAException {
        TXState state;
        if (trace) {
            log.trace((Object)("Ending xid=" + xid + ", success=" + success));
        }
        if ((state = (TXState)this.transactions.get(xid)) == null) {
            XAException e = new XAException("Unknown transaction during delist " + xid);
            e.errorCode = -4;
            throw e;
        }
        state.txState = 1;
    }

    public Object joinTx(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("Joining tx xid=" + xid));
        }
        if (!this.transactions.containsKey(xid)) {
            XAException e = new XAException("Unknown transaction during join " + xid);
            e.errorCode = -4;
            throw e;
        }
        return xid;
    }

    public int prepare(Object xid) throws XAException, JMSException {
        Externalizable[] job;
        TXState state;
        if (trace) {
            log.trace((Object)("Preparing xid=" + xid));
        }
        if ((state = (TXState)this.transactions.get(xid)) == null) {
            XAException e = new XAException("Unknown transaction during prepare " + xid);
            e.errorCode = -4;
            throw e;
        }
        if (state.isReadOnly()) {
            if (trace) {
                log.trace((Object)("Vote read only for " + xid));
            }
            state.txState = (byte)6;
            return 3;
        }
        TransactionRequest transaction = new TransactionRequest();
        transaction.requestType = 1;
        transaction.xid = xid;
        if (state.sentMessages.size() != 0) {
            job = new SpyMessage[state.sentMessages.size()];
            job = state.sentMessages.toArray(job);
            transaction.messages = job;
        }
        if (state.ackedMessages.size() != 0) {
            job = new AcknowledgementRequest[state.ackedMessages.size()];
            job = (AcknowledgementRequest[])state.ackedMessages.toArray(job);
            transaction.acks = job;
        }
        this.connection.send(transaction);
        state.txState = (byte)3;
        return 0;
    }

    public Object resumeTx(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("Resuming tx xid=" + xid));
        }
        if (!this.transactions.containsKey(xid)) {
            XAException e = new XAException("Unknown transaction during resume " + xid);
            e.errorCode = -4;
            throw e;
        }
        return xid;
    }

    public void rollback(Object xid) throws XAException, JMSException {
        TXState state;
        if (trace) {
            log.trace((Object)("Rolling back xid=" + xid));
        }
        if ((state = (TXState)this.transactions.remove(xid)) == null) {
            XAException e = new XAException("Unknown transaction during rollback " + xid);
            e.errorCode = -4;
            throw e;
        }
        if (state.txState == 6) {
            if (trace) {
                log.trace((Object)("Nothing to do for " + xid));
            }
            return;
        }
        if (state.txState != 3) {
            TransactionRequest transaction = new TransactionRequest();
            transaction.requestType = 0;
            transaction.xid = null;
            if (state.ackedMessages.size() != 0) {
                AcknowledgementRequest[] job = new AcknowledgementRequest[state.ackedMessages.size()];
                job = state.ackedMessages.toArray(job);
                transaction.acks = job;
                for (int i = 0; i < transaction.acks.length; ++i) {
                    transaction.acks[i].isAck = false;
                }
            }
            this.connection.send(transaction);
        } else {
            TransactionRequest transaction = new TransactionRequest();
            transaction.xid = xid;
            transaction.requestType = (byte)3;
            this.connection.send(transaction);
        }
        state.txState = (byte)5;
    }

    public Xid[] recover(int arg) throws XAException, JMSException {
        if (trace) {
            log.trace((Object)("Recover arg=" + arg));
        }
        Xid[] xids = this.connection.recover(arg);
        for (int i = 0; i < xids.length; ++i) {
            if (this.transactions.containsKey(xids[i])) continue;
            TXState state = new TXState();
            state.txState = (byte)3;
            this.transactions.put(xids[i], state);
        }
        return xids;
    }

    public void forget(Xid xid) throws XAException, JMSException {
        TXState state;
        if (trace) {
            log.trace((Object)("Forget xid=" + xid));
        }
        if ((state = (TXState)this.transactions.get(xid)) == null) {
            return;
        }
        if (state.txState != 3) {
            this.transactions.remove(xid);
        }
        this.rollback(xid);
    }

    public synchronized Long getNewXid() {
        return new Long(this.nextInternalXid++);
    }

    public Object startTx() {
        Long newXid = this.getNewXid();
        this.transactions.put(newXid, new TXState());
        if (trace) {
            log.trace((Object)("Starting tx with new xid=" + newXid));
        }
        return newXid;
    }

    public Object startTx(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("Starting tx xid=" + xid));
        }
        if (this.transactions.containsKey(xid)) {
            XAException e = new XAException("Duplicate transaction id during enlist " + xid);
            e.errorCode = -8;
            throw e;
        }
        this.transactions.put(xid, new TXState());
        return xid;
    }

    public Object suspendTx(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("Suppending tx xid=" + xid));
        }
        if (!this.transactions.containsKey(xid)) {
            XAException e = new XAException("Unknown transaction during suspend " + xid);
            e.errorCode = -4;
            throw e;
        }
        return xid;
    }

    public Object convertTx(Long anonXid, Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("Converting tx anonXid=" + anonXid + ", xid=" + xid));
        }
        if (!this.transactions.containsKey(anonXid)) {
            XAException e = new XAException("Unknown transaction during convert " + anonXid);
            e.errorCode = -4;
            throw e;
        }
        if (this.transactions.containsKey(xid)) {
            XAException e = new XAException("Duplicate transaction during convert " + xid);
            e.errorCode = -8;
            throw e;
        }
        TXState s = (TXState)this.transactions.remove(anonXid);
        this.transactions.put(xid, s);
        return xid;
    }

    static class TXState {
        byte txState = 0;
        ArrayList sentMessages = new ArrayList();
        ArrayList ackedMessages = new ArrayList();

        TXState() {
        }

        public boolean isReadOnly() {
            return this.sentMessages.size() == 0 && this.ackedMessages.size() == 0;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append("TxState txState=").append(this.txState);
            buffer.append(" sent=").append(this.sentMessages);
            buffer.append(" acks=").append(this.ackedMessages);
            return buffer.toString();
        }
    }
}

