/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import org.jboss.logging.Logger;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;

public final class OILClientIL
implements ClientIL,
Serializable {
    static final long serialVersionUID = 7812173621233374692L;
    private static final Logger log = Logger.getLogger((Class)OILClientIL.class);
    private InetAddress addr;
    private int port;
    protected boolean enableTcpNoDelay = false;
    private transient ObjectInputStream in;
    private transient ObjectOutputStream out;
    private transient Socket socket;

    OILClientIL(InetAddress addr, int port, boolean enableTcpNoDelay) {
        this.addr = addr;
        this.port = port;
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public synchronized void close() throws Exception {
        block3: {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Closing OILClientIL");
            }
            this.checkSocket();
            this.out.writeByte(29);
            this.waitAnswer();
            try {
                this.socket.close();
                this.in.close();
                this.out.close();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Error closing the socket connection", (Throwable)e);
            }
        }
    }

    public synchronized void deleteTemporaryDestination(SpyDestination dest) throws Exception {
        this.checkSocket();
        this.out.writeByte(15);
        this.out.writeObject(dest);
        this.waitAnswer();
    }

    public synchronized void pong(long serverTime) throws Exception {
        this.checkSocket();
        this.out.writeByte(28);
        this.out.writeLong(serverTime);
        this.waitAnswer();
    }

    public synchronized void receive(ReceiveRequest[] messages) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Checking socket");
        }
        this.checkSocket();
        if (trace) {
            log.trace((Object)"Writing request");
        }
        this.out.writeByte(19);
        this.out.writeInt(messages.length);
        for (int i = 0; i < messages.length; ++i) {
            messages[i].writeExternal(this.out);
        }
        if (trace) {
            log.trace((Object)"Waiting for anwser");
        }
        this.waitAnswer();
        if (trace) {
            log.trace((Object)"Done");
        }
    }

    private void checkSocket() throws RemoteException {
        if (this.socket == null) {
            this.createConnection();
        }
    }

    private void createConnection() throws RemoteException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ConnectionReceiverOILClient is connecting to: " + this.addr.getHostAddress() + ":" + this.port));
            }
            this.socket = new Socket(this.addr, this.port);
            this.out = new ObjectOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.out.flush();
            this.in = new ObjectInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (Exception e) {
            log.error((Object)"Cannot connect to the ConnectionReceiver/Server", (Throwable)e);
            throw new RemoteException("Cannot connect to the ConnectionReceiver/Server");
        }
    }

    private void waitAnswer() throws Exception {
        RemoteException throwException = null;
        try {
            this.out.reset();
            this.out.flush();
            byte val = this.in.readByte();
            switch (val) {
                case 2: {
                    Exception e = (Exception)this.in.readObject();
                    throwException = new RemoteException("", e);
                }
            }
        }
        catch (IOException e) {
            throw new RemoteException("Cannot contact the remote object", e);
        }
        if (throwException != null) {
            throw throwException;
        }
    }
}

