/*
 * Decompiled with CFR 0.152.
 */
package javax.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class TopicRequestor {
    private TopicSession topicSession = null;
    private TopicPublisher requestPublisher = null;
    private TemporaryTopic responseTopic = null;
    private TopicSubscriber responseSubscriber = null;

    public TopicRequestor(TopicSession session, Topic topic) throws JMSException {
        this.topicSession = session;
        this.requestPublisher = this.topicSession.createPublisher(topic);
        this.responseTopic = this.topicSession.createTemporaryTopic();
        this.responseSubscriber = this.topicSession.createSubscriber(this.responseTopic);
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this.responseTopic);
        this.requestPublisher.publish(message);
        return this.responseSubscriber.receive();
    }

    public void close() throws JMSException {
        try {
            this.responseSubscriber.close();
        }
        catch (JMSException ignored) {
            // empty catch block
        }
        try {
            this.responseTopic.delete();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.topicSession.close();
    }
}

