/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.port.util;

import com.clustercontrol.port.util.ReachAddressProtocol;
import com.clustercontrol.util.Messages;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReachAddressTCP
extends ReachAddressProtocol {
    protected static Log m_log = LogFactory.getLog(ReachAddressTCP.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning(String addressText) {
        this.m_message = "";
        this.m_messageOrg = "";
        this.m_response = -1L;
        boolean isReachable = false;
        try {
            long start = 0L;
            long end = 0L;
            StringBuffer bufferOrg = new StringBuffer();
            String result = "";
            boolean retry = true;
            InetAddress address = InetAddress.getByName(addressText);
            bufferOrg.append("Monitoring the port of " + address.getHostName() + "[" + address.getHostAddress() + "]:" + this.m_portNo + ".\n\n");
            Socket socket = null;
            for (int i = 0; i < this.m_sentCount && retry; ++i) {
                try {
                    socket = new Socket();
                    InetSocketAddress isa = new InetSocketAddress(address, this.m_portNo);
                    Object object = m_syncObj;
                    synchronized (object) {
                        Date d = new Date();
                        bufferOrg.append(d + " Tried to Connect: ");
                        start = System.currentTimeMillis();
                        socket.connect(isa, this.m_timeout);
                        end = System.currentTimeMillis();
                    }
                    this.m_response = end - start;
                    if (this.m_response > 0L) {
                        if (this.m_response < (long)this.m_timeout) {
                            result = "Response Time = " + this.m_response + "ms";
                        } else {
                            this.m_response = this.m_timeout;
                            result = "Response Time = " + this.m_response + "ms";
                        }
                    } else {
                        result = "Response Time < 1ms";
                    }
                    retry = false;
                    isReachable = true;
                }
                catch (BindException e) {
                    result = e.getMessage() + "[BindException]";
                    retry = true;
                    isReachable = false;
                }
                catch (ConnectException e) {
                    result = e.getMessage() + "[ConnectException]";
                    retry = false;
                    isReachable = false;
                }
                catch (NoRouteToHostException e) {
                    result = e.getMessage() + "[NoRouteToHostException]";
                    retry = true;
                    isReachable = false;
                }
                catch (PortUnreachableException e) {
                    result = e.getMessage() + "[PortUnreachableException]";
                    retry = true;
                    isReachable = false;
                }
                catch (IOException e) {
                    result = e.getMessage() + "[IOException]";
                    retry = true;
                    isReachable = false;
                }
                finally {
                    bufferOrg.append(result + "\n");
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            m_log.error((Object)("isRunning(): socket close failed: " + e.getMessage()));
                        }
                    }
                }
                if (i >= this.m_sentCount - 1 || !retry) continue;
                try {
                    Thread.sleep(this.m_sentInterval);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.m_message = result + "(TCP/" + this.m_portNo + ")";
            this.m_messageOrg = bufferOrg.toString();
            return isReachable;
        }
        catch (UnknownHostException e) {
            m_log.debug((Object)("isRunning(): " + Messages.getString((String)"message.port.6") + e.getMessage()));
            this.m_message = Messages.getString((String)"message.port.6") + " (" + e.getMessage() + ")";
            return false;
        }
    }
}

