/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

abstract class TreeEditorImpl {
    private CellEditor cellEditor;
    private CellEditor[] cellEditors;
    private ICellModifier cellModifier;
    private String[] columnProperties;
    private Item treeItem;
    private int columnNumber;
    private ICellEditorListener cellEditorListener;
    private FocusListener focusListener;
    private MouseListener mouseListener;
    private int doubleClickExpirationTime;
    private StructuredViewer viewer;

    TreeEditorImpl(StructuredViewer viewer) {
        this.viewer = viewer;
        this.initCellEditorListener();
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    private void activateCellEditor() {
        String property;
        Object element;
        if (this.cellEditors != null && this.cellEditors[this.columnNumber] != null && this.cellModifier != null && this.cellModifier.canModify(element = this.treeItem.getData(), property = this.columnProperties[this.columnNumber])) {
            this.cellEditor = this.cellEditors[this.columnNumber];
            this.cellEditor.addListener(this.cellEditorListener);
            Object value = this.cellModifier.getValue(element, property);
            this.cellEditor.setValue(value);
            final Control control = this.cellEditor.getControl();
            this.cellEditor.activate();
            if (control == null) {
                return;
            }
            this.setLayoutData(this.cellEditor.getLayoutData());
            this.setEditor(control, this.treeItem, this.columnNumber);
            this.cellEditor.setFocus();
            if (this.focusListener == null) {
                this.focusListener = new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        TreeEditorImpl.this.applyEditorValue();
                    }
                };
            }
            control.addFocusListener(this.focusListener);
            this.mouseListener = new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.time <= TreeEditorImpl.this.doubleClickExpirationTime) {
                        control.removeMouseListener(TreeEditorImpl.this.mouseListener);
                        TreeEditorImpl.this.cancelEditing();
                        TreeEditorImpl.this.handleDoubleClickEvent();
                    } else if (TreeEditorImpl.this.mouseListener != null) {
                        control.removeMouseListener(TreeEditorImpl.this.mouseListener);
                    }
                }
            };
            control.addMouseListener(this.mouseListener);
        }
    }

    private void activateCellEditor(MouseEvent event) {
        int columnToEdit;
        if (this.treeItem == null || this.treeItem.isDisposed()) {
            return;
        }
        int columns = this.getColumnCount();
        if (columns == 0) {
            columnToEdit = 0;
        } else {
            columnToEdit = -1;
            int i = 0;
            while (i < columns) {
                Rectangle bounds = this.getBounds(this.treeItem, i);
                if (bounds.contains(event.x, event.y)) {
                    columnToEdit = i;
                    break;
                }
                ++i;
            }
            if (columnToEdit == -1) {
                return;
            }
        }
        this.columnNumber = columnToEdit;
        this.activateCellEditor();
    }

    public void applyEditorValue() {
        CellEditor c = this.cellEditor;
        if (c != null) {
            this.cellEditor = null;
            Item t = this.treeItem;
            if (t != null && !t.isDisposed()) {
                this.saveEditorValue(c, t);
            }
            this.setEditor(null, null, 0);
            c.removeListener(this.cellEditorListener);
            Control control = c.getControl();
            if (control != null) {
                if (this.mouseListener != null) {
                    control.removeMouseListener(this.mouseListener);
                }
                if (this.focusListener != null) {
                    control.removeFocusListener(this.focusListener);
                }
            }
            c.deactivate();
        }
    }

    public void cancelEditing() {
        if (this.cellEditor != null) {
            this.setEditor(null, null, 0);
            this.cellEditor.removeListener(this.cellEditorListener);
            CellEditor oldEditor = this.cellEditor;
            this.cellEditor = null;
            oldEditor.deactivate();
        }
    }

    public void editElement(Object element, int column) {
        if (this.cellEditor != null) {
            this.applyEditorValue();
        }
        this.setSelection(new StructuredSelection(element), true);
        Item[] selection = this.getSelection();
        if (selection.length != 1) {
            return;
        }
        this.treeItem = selection[0];
        this.showSelection();
        this.columnNumber = column;
        this.activateCellEditor();
    }

    abstract Rectangle getBounds(Item var1, int var2);

    public CellEditor[] getCellEditors() {
        return this.cellEditors;
    }

    public ICellModifier getCellModifier() {
        return this.cellModifier;
    }

    abstract int getColumnCount();

    public Object[] getColumnProperties() {
        return this.columnProperties;
    }

    abstract Item[] getSelection();

    public void handleMouseDown(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        if (this.cellEditor != null) {
            this.applyEditorValue();
        }
        this.doubleClickExpirationTime = event.time + Display.getCurrent().getDoubleClickTime();
        Item[] items = this.getSelection();
        if (items.length != 1) {
            this.treeItem = null;
            return;
        }
        this.treeItem = items[0];
        this.activateCellEditor(event);
    }

    private void initCellEditorListener() {
        this.cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                TreeEditorImpl.this.cancelEditing();
            }

            public void applyEditorValue() {
                TreeEditorImpl.this.applyEditorValue();
            }
        };
    }

    public boolean isCellEditorActive() {
        return this.cellEditor != null;
    }

    private void saveEditorValue(CellEditor cellEditor, Item treeItem) {
        if (this.cellModifier != null) {
            String property = null;
            if (this.columnProperties != null && this.columnNumber < this.columnProperties.length) {
                property = this.columnProperties[this.columnNumber];
            }
            this.cellModifier.modify(treeItem, property, cellEditor.getValue());
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this.cellEditors = editors;
    }

    public void setCellModifier(ICellModifier modifier) {
        this.cellModifier = modifier;
    }

    public void setColumnProperties(String[] columnProperties) {
        this.columnProperties = columnProperties;
    }

    abstract void setEditor(Control var1, Item var2, int var3);

    abstract void setLayoutData(CellEditor.LayoutData var1);

    abstract void setSelection(StructuredSelection var1, boolean var2);

    abstract void showSelection();

    abstract void handleDoubleClickEvent();
}

