/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeEditorImpl;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewer
extends AbstractTreeViewer {
    private TreeEditorImpl treeViewerImpl;
    private Tree tree;
    private TreeEditor treeEditor;
    private TreeColorAndFontCollector treeColorAndFont = new TreeColorAndFontCollector();

    public TreeViewer(Composite parent) {
        this(parent, 2818);
    }

    public TreeViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    public TreeViewer(Tree tree) {
        this.tree = tree;
        this.hookControl((Control)tree);
        this.treeEditor = new TreeEditor(tree);
        this.initTreeViewerImpl();
    }

    protected void addTreeListener(Control c, TreeListener listener) {
        ((Tree)c).addTreeListener(listener);
    }

    public void cancelEditing() {
        this.treeViewerImpl.cancelEditing();
    }

    protected void doUpdateItem(Item item, Object element) {
        int columnCount;
        if (!(item instanceof TreeItem)) {
            return;
        }
        TreeItem treeItem = (TreeItem)item;
        if (treeItem.isDisposed()) {
            this.unmapElement(element);
            return;
        }
        this.getColorAndFontCollector().setFontsAndColors(element);
        IBaseLabelProvider prov = this.getLabelProvider();
        ITableLabelProvider tprov = null;
        ILabelProvider lprov = null;
        IViewerLabelProvider vprov = null;
        if (prov instanceof ILabelProvider) {
            lprov = (ILabelProvider)prov;
        }
        if (prov instanceof IViewerLabelProvider) {
            vprov = (IViewerLabelProvider)prov;
        }
        if (prov instanceof ITableLabelProvider) {
            tprov = (ITableLabelProvider)prov;
        }
        if ((columnCount = this.tree.getColumnCount()) == 0) {
            ViewerLabel updateLabel = new ViewerLabel(treeItem.getText(), treeItem.getImage());
            if (vprov != null) {
                this.buildLabel(updateLabel, element, vprov);
            } else if (lprov != null) {
                this.buildLabel(updateLabel, element, lprov);
            }
            if (treeItem.isDisposed()) {
                this.unmapElement(element);
                return;
            }
            if (updateLabel.hasNewText()) {
                treeItem.setText(updateLabel.getText());
            }
            if (updateLabel.hasNewImage()) {
                treeItem.setImage(updateLabel.getImage());
            }
        } else {
            int column = 0;
            while (column < columnCount) {
                String text = "";
                Image image = null;
                this.treeColorAndFont.setFontsAndColors(treeItem, element, column);
                if (tprov == null) {
                    if (column == 0) {
                        ViewerLabel updateLabel = new ViewerLabel(treeItem.getText(), treeItem.getImage());
                        if (vprov != null) {
                            this.buildLabel(updateLabel, element, vprov);
                        } else if (lprov != null) {
                            this.buildLabel(updateLabel, element, lprov);
                        }
                        if (treeItem.isDisposed()) {
                            this.unmapElement(element);
                            return;
                        }
                        text = updateLabel.getText();
                        image = updateLabel.getImage();
                    }
                } else {
                    text = tprov.getColumnText(element, column);
                    image = tprov.getColumnImage(element, column);
                }
                if (text == null) {
                    text = "";
                }
                treeItem.setText(column, text);
                if (treeItem.getImage(column) != image) {
                    treeItem.setImage(column, image);
                }
                ++column;
            }
        }
        this.getColorAndFontCollector().applyFontsAndColors(treeItem);
    }

    public void editElement(Object element, int column) {
        this.treeViewerImpl.editElement(element, column);
    }

    public CellEditor[] getCellEditors() {
        return this.treeViewerImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.treeViewerImpl.getCellModifier();
    }

    protected Item[] getChildren(Widget o) {
        if (o instanceof TreeItem) {
            return ((TreeItem)o).getItems();
        }
        if (o instanceof Tree) {
            return ((Tree)o).getItems();
        }
        return null;
    }

    public Object[] getColumnProperties() {
        return this.treeViewerImpl.getColumnProperties();
    }

    public Control getControl() {
        return this.tree;
    }

    protected boolean getExpanded(Item item) {
        return ((TreeItem)item).getExpanded();
    }

    protected Item getItem(int x, int y) {
        return this.getTree().getItem(this.getTree().toControl(new Point(x, y)));
    }

    protected int getItemCount(Control widget) {
        return ((Tree)widget).getItemCount();
    }

    protected int getItemCount(Item item) {
        return ((TreeItem)item).getItemCount();
    }

    protected Item[] getItems(Item item) {
        return ((TreeItem)item).getItems();
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected Item getParentItem(Item item) {
        return ((TreeItem)item).getParentItem();
    }

    protected Item[] getSelection(Control widget) {
        return ((Tree)widget).getSelection();
    }

    public Tree getTree() {
        return this.tree;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Tree treeControl = (Tree)control;
        treeControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TreeViewer.this.treeViewerImpl.handleMouseDown(e);
            }
        });
    }

    private void initTreeViewerImpl() {
        this.treeViewerImpl = new TreeEditorImpl(this){

            Rectangle getBounds(Item item, int columnNumber) {
                return ((TreeItem)item).getBounds(columnNumber);
            }

            int getColumnCount() {
                return TreeViewer.this.getTree().getColumnCount();
            }

            Item[] getSelection() {
                return TreeViewer.this.getTree().getSelection();
            }

            void setEditor(Control w, Item item, int columnNumber) {
                TreeViewer.this.treeEditor.setEditor(w, (TreeItem)item, columnNumber);
            }

            void setSelection(StructuredSelection selection, boolean b) {
                TreeViewer.this.setSelection(selection, b);
            }

            void showSelection() {
                TreeViewer.this.getTree().showSelection();
            }

            void setLayoutData(CellEditor.LayoutData layoutData) {
                ((TreeViewer)TreeViewer.this).treeEditor.grabHorizontal = layoutData.grabHorizontal;
                ((TreeViewer)TreeViewer.this).treeEditor.horizontalAlignment = layoutData.horizontalAlignment;
                ((TreeViewer)TreeViewer.this).treeEditor.minimumWidth = layoutData.minimumWidth;
            }

            void handleDoubleClickEvent() {
                StructuredViewer viewer = this.getViewer();
                TreeViewer.this.fireDoubleClick(new DoubleClickEvent(viewer, ((Viewer)viewer).getSelection()));
                TreeViewer.this.fireOpen(new OpenEvent(viewer, ((Viewer)viewer).getSelection()));
            }
        };
    }

    public boolean isCellEditorActive() {
        return this.treeViewerImpl.isCellEditorActive();
    }

    protected Item newItem(Widget parent, int flags, int ix) {
        TreeItem item = ix >= 0 ? (parent instanceof TreeItem ? new TreeItem((TreeItem)parent, flags, ix) : new TreeItem((Tree)parent, flags, ix)) : (parent instanceof TreeItem ? new TreeItem((TreeItem)parent, flags) : new TreeItem((Tree)parent, flags));
        return item;
    }

    protected void removeAll(Control widget) {
        ((Tree)widget).removeAll();
    }

    public void setCellEditors(CellEditor[] editors) {
        this.treeViewerImpl.setCellEditors(editors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.treeViewerImpl.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        this.treeViewerImpl.setColumnProperties(columnProperties);
    }

    protected void setExpanded(Item node, boolean expand) {
        ((TreeItem)node).setExpanded(expand);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue(labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider);
        super.setLabelProvider(labelProvider);
        this.treeColorAndFont = new TreeColorAndFontCollector(labelProvider);
    }

    protected void setSelection(List items) {
        Item[] current = this.getSelection((Control)this.getTree());
        if (this.isSameSelection(items, current)) {
            return;
        }
        TreeItem[] newItems = new TreeItem[items.size()];
        items.toArray(newItems);
        this.getTree().setSelection(newItems);
    }

    protected boolean isSameSelection(List items, Item[] current) {
        int n = items.size();
        if (n != current.length) {
            return false;
        }
        CustomHashtable itemSet = this.newHashtable(n * 2 + 1);
        Iterator i = items.iterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            Object element = item.getData();
            itemSet.put(element, element);
        }
        int i2 = 0;
        while (i2 < current.length) {
            if (!itemSet.containsKey(current[i2].getData())) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected void showItem(Item item) {
        this.getTree().showItem((TreeItem)item);
    }

    protected Item getChild(Widget widget, int index) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItem(index);
        }
        if (widget instanceof Tree) {
            return ((Tree)widget).getItem(index);
        }
        return null;
    }

    private class TreeColorAndFontCollector {
        ITableFontProvider fontProvider = null;
        ITableColorProvider colorProvider = null;

        public TreeColorAndFontCollector(IBaseLabelProvider provider) {
            if (provider instanceof ITableFontProvider) {
                this.fontProvider = (ITableFontProvider)((Object)provider);
            }
            if (provider instanceof ITableColorProvider) {
                this.colorProvider = (ITableColorProvider)((Object)provider);
            }
        }

        public TreeColorAndFontCollector() {
        }

        public void setFontsAndColors(TreeItem treeItem, Object element, int column) {
            if (this.colorProvider != null) {
                treeItem.setBackground(column, this.colorProvider.getBackground(element, column));
                treeItem.setForeground(column, this.colorProvider.getForeground(element, column));
            }
            if (this.fontProvider != null) {
                treeItem.setFont(column, this.fontProvider.getFont(element, column));
            }
        }
    }
}

