/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.acessor;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.umdm.Accessor;
import org.jboss.ws.metadata.umdm.AccessorFactory;
import org.jboss.ws.metadata.umdm.AccessorFactoryCreator;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;

public class ReflectiveFieldAccessor
implements Accessor {
    private Field field;
    public static AccessorFactoryCreator FACTORY_CREATOR = new AccessorFactoryCreator(){

        public AccessorFactory create(ParameterMetaData parameter) {
            return this.create(parameter.getJavaType());
        }

        public AccessorFactory create(FaultMetaData fault) {
            return this.create(fault.getFaultBean());
        }

        private AccessorFactory create(final Class clazz) {
            return new AccessorFactory(){

                public Accessor create(WrappedParameter parameter) {
                    String fieldName = parameter.getVariable();
                    try {
                        Field field;
                        try {
                            field = clazz.getField(fieldName);
                        }
                        catch (NoSuchFieldException e) {
                            field = clazz.getDeclaredField(fieldName);
                            field.setAccessible(true);
                        }
                        if (Modifier.isStatic(field.getModifiers())) {
                            throw new WSException("Field can not be static: " + fieldName);
                        }
                        return new ReflectiveFieldAccessor(field);
                    }
                    catch (Throwable t) {
                        WSException ex = new WSException("Error accessing field: " + fieldName + t.getClass().getSimpleName() + ": " + t.getMessage());
                        ex.setStackTrace(t.getStackTrace());
                        throw ex;
                    }
                }
            };
        }
    };

    private ReflectiveFieldAccessor(Field field) {
        this.field = field;
    }

    public Object get(Object bean) {
        try {
            return this.field.get(bean);
        }
        catch (Throwable e) {
            WSException ex = new WSException(e.getMessage());
            ex.setStackTrace(ex.getStackTrace());
            throw ex;
        }
    }

    public void set(Object bean, Object value) {
        try {
            this.field.set(bean, value);
        }
        catch (Throwable e) {
            WSException ex = new WSException(e.getMessage());
            ex.setStackTrace(ex.getStackTrace());
            throw ex;
        }
    }
}

