/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarEntryHandler
extends AbstractURLHandler
implements StructuredVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private final transient JarFile jar;
    private final transient JarEntry entry;
    private transient List<VirtualFileHandler> entryChildren;
    private transient Map<String, VirtualFileHandler> entryMap;

    public JarEntryHandler(VFSContext context, VirtualFileHandler parent, JarFile jar, JarEntry entry, String entryName, URL url) throws IOException {
        super(context, parent, url, entryName);
        try {
            URL parentVfsUrl = parent.toVfsUrl();
            String vfsParentUrl = parentVfsUrl.toString();
            String vfsUrlString = null;
            vfsUrlString = vfsParentUrl.endsWith("/") ? String.valueOf(vfsParentUrl) + entryName : String.valueOf(vfsParentUrl) + "/" + entryName;
            if (entry.isDirectory()) {
                vfsUrlString = String.valueOf(vfsUrlString) + "/";
            }
            this.vfsUrl = new URL(vfsUrlString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (jar == null) {
            throw new IllegalArgumentException("Null jar");
        }
        this.jar = jar;
        this.entry = entry;
    }

    @Override
    protected void initCacheLastModified() {
    }

    @Override
    public boolean hasBeenModified() throws IOException {
        return false;
    }

    public void addChild(VirtualFileHandler child) {
        if (this.entryChildren == null) {
            this.entryChildren = new ArrayList<VirtualFileHandler>();
        }
        this.entryChildren.add(child);
    }

    protected JarEntry getEntry() {
        this.checkClosed();
        return this.entry;
    }

    @Override
    public long getLastModified() {
        return this.getEntry().getTime();
    }

    @Override
    public long getSize() {
        return this.getEntry().getSize();
    }

    @Override
    public boolean isLeaf() {
        return !this.getEntry().isDirectory();
    }

    @Override
    public boolean isHidden() {
        this.checkClosed();
        return false;
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        this.checkClosed();
        List<VirtualFileHandler> children = this.entryChildren;
        if (this.entryChildren == null) {
            children = Collections.emptyList();
        }
        return children;
    }

    @Override
    public VirtualFileHandler findChild(String path) throws IOException {
        return super.structuredFindChild(path);
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.jar.getInputStream(this.getEntry());
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        VirtualFileHandler child2;
        if (this.entryChildren == null) {
            throw new FileNotFoundException(this + " has no children");
        }
        if (this.entryMap == null) {
            this.entryMap = new HashMap<String, VirtualFileHandler>();
            for (VirtualFileHandler child2 : this.entryChildren) {
                this.entryMap.put(child2.getName(), child2);
            }
        }
        if ((child2 = this.entryMap.get(name)) == null) {
            throw new FileNotFoundException(this + " has no child: " + name);
        }
        return child2;
    }
}

