/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.Serializable;
import java.util.ArrayList;
import org.jboss.aop.DispatcherConnectException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.InvokerLocator;

public class ClusterChooserInterceptor
implements Interceptor,
ClusterConstants,
Serializable {
    private static final long serialVersionUID = -8666382019058421135L;
    public static final ClusterChooserInterceptor singleton = new ClusterChooserInterceptor();

    public String getName() {
        return "ClusterChooserInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        LoadBalancePolicy lb = (LoadBalancePolicy)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"LOADBALANCE_POLICY");
        FamilyWrapper family = (FamilyWrapper)invocation.getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY_WRAPPER");
        int failoverCounter = 0;
        String familyName = family.get().getFamilyName();
        invocation.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY", (Object)familyName, PayloadKey.AS_IS);
        InvokerLocator target = (InvokerLocator)lb.chooseTarget(family.get());
        Throwable lastException = null;
        while (target != null) {
            invocation.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"FAILOVER_COUNTER", (Object)new Integer(failoverCounter), PayloadKey.AS_IS);
            invocation.getMetaData().addMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR", (Object)target, PayloadKey.AS_IS);
            invocation.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_VIEW_ID", (Object)new Long(family.get().getCurrentViewId()), PayloadKey.AS_IS);
            boolean definitivlyRemoveNodeOnFailure = true;
            lastException = null;
            try {
                Object rsp = invocation.invokeNext();
                ArrayList newReplicants = (ArrayList)invocation.getResponseAttachment((Object)"replicants");
                if (newReplicants != null) {
                    long newViewId = (Long)invocation.getResponseAttachment((Object)"viewId");
                    family.get().updateClusterInfo(newReplicants, newViewId);
                }
                return rsp;
            }
            catch (DispatcherConnectException dce) {
                lastException = dce;
            }
            catch (CannotConnectException ex) {
                lastException = ex;
            }
            catch (GenericClusteringException gce) {
                lastException = gce;
                if (gce.getCompletionStatus() == 1) {
                    if (family.get().getTargets().size() >= failoverCounter && !gce.isDefinitive()) {
                        definitivlyRemoveNodeOnFailure = false;
                    }
                }
                throw new RuntimeException("Clustering exception thrown", gce);
            }
            catch (Throwable t) {
                if (t.getCause() instanceof GenericClusteringException) {
                    GenericClusteringException gce = (GenericClusteringException)t.getCause();
                    lastException = gce;
                    if (gce.getCompletionStatus() == 1) {
                        if (family.get().getTargets().size() >= failoverCounter && !gce.isDefinitive()) {
                            definitivlyRemoveNodeOnFailure = false;
                        }
                    }
                    throw new RuntimeException("Clustering exception thrown", gce);
                }
                throw t;
            }
            family.get().removeDeadTarget((Object)target);
            if (!definitivlyRemoveNodeOnFailure) {
                family.get().resetView();
            }
            if ((target = (InvokerLocator)lb.chooseTarget(family.get())) == null) {
                if (lastException != null) {
                    throw new RuntimeException("cluster invocation failed, last exception was: ", lastException);
                }
                throw new RuntimeException("cluster invocation failed");
            }
            ++failoverCounter;
        }
        throw new RuntimeException("Unreachable?: Service unavailable.");
    }
}

