/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.bean;

import com.clustercontrol.performance.bean.CollectedDataInfo;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectedDataSet
implements Serializable {
    private static final long serialVersionUID = -2016025252868760081L;
    private HashMap<String, HashMap<CollectorItemInfo, List<CollectedDataInfo>>> dataMap = new HashMap();

    public void setCollectedDataList(String facilityID, CollectorItemInfo key, List<CollectedDataInfo> data) {
        HashMap<CollectorItemInfo, List<CollectedDataInfo>> subDataMap = this.dataMap.get(facilityID);
        if (subDataMap == null) {
            subDataMap = new HashMap();
        }
        subDataMap.put(key, data);
        this.dataMap.put(facilityID, subDataMap);
    }

    public void addCollectedDataList(CollectedDataSet dataSet) {
        Set<String> facilityIDSet = dataSet.dataMap.keySet();
        for (String facilityID : facilityIDSet) {
            HashMap<CollectorItemInfo, List<CollectedDataInfo>> subDataMap = dataSet.dataMap.get(facilityID);
            Set<CollectorItemInfo> pks = subDataMap.keySet();
            for (CollectorItemInfo key : pks) {
                List<CollectedDataInfo> dataList = dataSet.getCollectedDataList(facilityID, key);
                this.setCollectedDataList(facilityID, key, dataList);
            }
        }
    }

    public List<CollectedDataInfo> getCollectedDataList(String facilityID, CollectorItemInfo key) {
        HashMap<CollectorItemInfo, List<CollectedDataInfo>> subDataMap = this.dataMap.get(facilityID);
        if (subDataMap != null) {
            return subDataMap.get(key);
        }
        return new ArrayList<CollectedDataInfo>();
    }

    public int getDataListNum(String facilityID) {
        HashMap<CollectorItemInfo, List<CollectedDataInfo>> subDataMap = this.dataMap.get(facilityID);
        if (subDataMap != null) {
            return subDataMap.size();
        }
        return 0;
    }
}

