/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.log;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.wsf.common.log.JBossLogHandler;
import org.jboss.wsf.common.log.NamespaceFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKLogRedirector {
    private List<String> namespaces = new LinkedList<String>();

    public void changeHandlers() {
        for (String ns : this.namespaces) {
            this.changeHandler(ns);
        }
    }

    public void changeHandler(String ns) {
        if (ns == null) {
            ns = "";
        }
        org.jboss.logging.Logger.getLogger(this.getClass()).info((Object)("Changing current root logger's log handlers to hide logs with namespace " + ns));
        Logger jdkRootLogger = Logger.getLogger("");
        Handler[] handlers = jdkRootLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            if (handler instanceof JBossLogHandler) continue;
            StringBuffer sb = new StringBuffer("Disableing handler ");
            sb.append(handler).append(" with level ").append(handler.getLevel());
            org.jboss.logging.Logger.getLogger(this.getClass()).debug((Object)sb);
            Filter f = handler.getFilter();
            if (f != null && f instanceof NamespaceFilter) {
                ((NamespaceFilter)f).addNamespace(ns);
                continue;
            }
            NamespaceFilter nsFilter = new NamespaceFilter(false);
            nsFilter.addNamespace(ns);
            handler.setFilter(nsFilter);
        }
        JBossLogHandler jbossLogHandler = new JBossLogHandler();
        jbossLogHandler.setLevel(Level.ALL);
        Logger.getLogger(ns).addHandler(jbossLogHandler);
    }

    public void addNamespace(String ns) {
        this.namespaces.add(ns);
        this.changeHandler(ns);
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
        this.changeHandlers();
    }
}

