/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.GenericValueContainer;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.group.ValueList;
import org.jboss.xb.binding.group.ValueListHandler;
import org.jboss.xb.binding.group.ValueListInitializer;
import org.jboss.xb.binding.introspection.FieldInfo;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBeforeSetParentCallback;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.UnmarshallingContext;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.xop.XOPIncludeHandler;
import org.xml.sax.Attributes;

public class SundayContentHandler
implements JBossXBParser.ContentHandler {
    private static final Logger log = Logger.getLogger((Class)SundayContentHandler.class);
    private static final Object NIL = new Object();
    private final SchemaBinding schema;
    private final SchemaBindingResolver schemaResolver;
    private final StackImpl stack = new StackImpl();
    private Object root;
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private ParticleHandler defParticleHandler = DefaultHandlers.ELEMENT_HANDLER;
    private UnmarshallingContextImpl ctx = new UnmarshallingContextImpl();
    private final boolean trace = log.isTraceEnabled();

    public SundayContentHandler(SchemaBinding schema) {
        this.schema = schema;
        this.schemaResolver = null;
    }

    public SundayContentHandler(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
        this.schema = null;
    }

    public void characters(char[] ch, int start, int length) {
        int i;
        StackItem stackItem = this.stack.peek();
        if (stackItem.cursor != null) {
            return;
        }
        ElementBinding e = (ElementBinding)stackItem.particle.getTerm();
        if (stackItem.ended) {
            i = 0;
            do {
                stackItem = this.stack.peek(++i);
            } while (stackItem.cursor != null && i < this.stack.size());
            e = (ElementBinding)stackItem.particle.getTerm();
        }
        if (e.getType().isTextContentAllowed()) {
            if (stackItem.indentation != Boolean.FALSE) {
                if (e.getType().isSimple()) {
                    stackItem.indentation = Boolean.FALSE;
                    stackItem.ignorableCharacters = false;
                } else if (e.getSchema() != null && !e.getSchema().isIgnoreWhitespacesInMixedContent()) {
                    stackItem.indentation = Boolean.FALSE;
                    stackItem.ignorableCharacters = false;
                } else {
                    for (i = start; i < start + length; ++i) {
                        if (ch[i] == '\n') {
                            stackItem.indentation = Boolean.TRUE;
                            continue;
                        }
                        if (Character.isWhitespace(ch[i])) continue;
                        stackItem.indentation = Boolean.FALSE;
                        stackItem.ignorableCharacters = false;
                        break;
                    }
                }
            }
            if (stackItem.textContent == null) {
                stackItem.textContent = new StringBuffer();
            }
            stackItem.textContent.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        StackItem item;
        ElementBinding elementBinding = null;
        QName endName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
        while (true) {
            ParticleBinding currentParticle;
            TermBinding term;
            item = this.stack.peek();
            if (item.cursor == null) {
                if (item.ended) {
                    this.pop();
                    if (!item.particle.isRepeatable()) continue;
                    this.endRepeatableParticle(item.particle);
                    continue;
                }
                break;
            }
            if (!item.ended) {
                this.endParticle(item, endName, 1);
            }
            if ((term = (currentParticle = item.cursor.getCurrentParticle()).getTerm()).isWildcard() && currentParticle.isRepeatable()) {
                this.endRepeatableParticle(currentParticle);
            }
            this.pop();
            if (!item.particle.isRepeatable()) continue;
            this.endRepeatableParticle(item.particle);
        }
        elementBinding = (ElementBinding)item.particle.getTerm();
        item.ended = true;
        if (elementBinding == null) {
            throw new JBossXBRuntimeException("Failed to endElement " + qName + ": binding not found");
        }
        if (!elementBinding.getQName().equals(endName)) {
            throw new JBossXBRuntimeException("Failed to end element " + new QName(namespaceURI, localName) + ": element on the stack is " + elementBinding.getQName());
        }
        this.endElement();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts, XSTypeDefinition xercesType) {
        QName startName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
        ParticleBinding particle = null;
        ParticleHandler handler = null;
        boolean repeated = false;
        boolean repeatedParticle = false;
        StackItem item = null;
        ModelGroupBinding.Cursor cursor = null;
        SchemaBinding schemaBinding = this.schema;
        if (this.stack.isEmpty()) {
            if (schemaBinding != null) {
                particle = schemaBinding.getElementParticle(startName);
            } else {
                if (this.schemaResolver == null) throw new JBossXBRuntimeException("Neither schema binding nor schema binding resolver is available!");
                String schemaLocation = atts == null ? null : Util.getSchemaLocation(atts, namespaceURI);
                schemaBinding = this.schemaResolver.resolve(namespaceURI, null, schemaLocation);
                if (schemaBinding == null) throw new JBossXBRuntimeException("Failed to resolve schema nsURI=" + namespaceURI + " location=" + schemaLocation);
                particle = schemaBinding.getElementParticle(startName);
            }
        } else {
            while (!this.stack.isEmpty()) {
                ParticleBinding curParticle;
                item = this.stack.peek();
                if (item.cursor == null) {
                    ModelGroupBinding modelGroup;
                    TermBinding term = item.particle.getTerm();
                    ElementBinding element = (ElementBinding)term;
                    if (item.ended) {
                        if (element.getQName().equals(startName)) {
                            particle = item.particle;
                            repeated = true;
                            item.reset();
                            if (particle.isRepeatable()) break;
                            this.endRepeatableParent(startName);
                            break;
                        }
                        this.pop();
                        if (!item.particle.isRepeatable()) continue;
                        this.endRepeatableParticle(item.particle);
                        continue;
                    }
                    ParticleBinding typeParticle = element.getType().getParticle();
                    ModelGroupBinding modelGroupBinding = modelGroup = typeParticle == null ? null : (ModelGroupBinding)typeParticle.getTerm();
                    if (modelGroup == null) {
                        if (startName.equals(Constants.QNAME_XOP_INCLUDE)) {
                            TypeBinding anyUriType = this.schema.getType(Constants.QNAME_ANYURI);
                            if (anyUriType == null) {
                                log.warn((Object)("Type " + Constants.QNAME_ANYURI + " not bound."));
                            }
                            TypeBinding xopIncludeType = new TypeBinding(new QName("http://www.w3.org/2004/08/xop/include", "Include"));
                            xopIncludeType.setSchemaBinding(this.schema);
                            xopIncludeType.addAttribute(new QName("href"), anyUriType, DefaultHandlers.ATTRIBUTE_HANDLER);
                            xopIncludeType.setHandler(new XOPIncludeHandler(element.getType(), this.schema.getXopUnmarshaller()));
                            ElementBinding xopInclude = new ElementBinding(this.schema, Constants.QNAME_XOP_INCLUDE, xopIncludeType);
                            particle = new ParticleBinding(xopInclude);
                            ElementBinding parentElement = (ElementBinding)item.particle.getTerm();
                            parentElement.setXopUnmarshaller(this.schema.getXopUnmarshaller());
                            this.flushIgnorableCharacters();
                            item.handler = DefaultHandlers.XOP_HANDLER;
                            item.ignoreCharacters = true;
                            item.o = item.handler.startParticle(this.stack.peek().o, startName, this.stack.peek().particle, null, this.nsRegistry);
                            break;
                        }
                        QName typeName = element.getType().getQName();
                        throw new JBossXBRuntimeException((typeName == null ? "Anonymous" : typeName.toString()) + " type of element " + element.getQName() + " should be complex and contain " + startName + " as a child element.");
                    }
                    cursor = modelGroup.newCursor(typeParticle);
                    List newCursors = cursor.startElement(startName, atts);
                    if (newCursors.isEmpty()) {
                        throw new JBossXBRuntimeException(startName + " not found as a child of " + ((ElementBinding)term).getQName());
                    }
                    this.flushIgnorableCharacters();
                    Object o = item.o;
                    for (int i = newCursors.size() - 1; i >= 0; --i) {
                        cursor = (ModelGroupBinding.Cursor)newCursors.get(i);
                        ParticleBinding modelGroupParticle = cursor.getParticle();
                        if (modelGroupParticle.isRepeatable()) {
                            this.startRepeatableParticle(startName, modelGroupParticle);
                        }
                        handler = this.getHandler(modelGroupParticle);
                        o = handler.startParticle(o, startName, modelGroupParticle, atts, this.nsRegistry);
                        this.push(cursor, o, handler);
                    }
                    particle = cursor.getCurrentParticle();
                    break;
                }
                cursor = item.cursor;
                if (cursor == null) {
                    throw new JBossXBRuntimeException("No cursor for " + startName);
                }
                if (!item.ended && cursor.isPositioned() && cursor.getParticle().getTerm() instanceof ChoiceBinding) {
                    this.endParticle(item, startName, 1);
                    if (item.particle.isRepeatable()) continue;
                    this.pop();
                    continue;
                }
                ParticleBinding prevParticle = cursor.isPositioned() ? cursor.getCurrentParticle() : null;
                List newCursors = cursor.startElement(startName, atts);
                if (newCursors.isEmpty()) {
                    if (!item.ended) {
                        this.endParticle(item, startName, 1);
                    }
                    this.pop();
                    continue;
                }
                if (item.ended) {
                    if (!item.particle.isRepeatable()) {
                        throw new JBossXBRuntimeException("The particle expected to be repeatable but it's not: " + item.particle.getTerm());
                    }
                    item.reset();
                    handler = this.getHandler(item.particle);
                    item.o = handler.startParticle(this.stack.peek((int)1).o, startName, item.particle, atts, this.nsRegistry);
                }
                if ((curParticle = cursor.getCurrentParticle()) != prevParticle) {
                    if (prevParticle != null && prevParticle.isRepeatable() && prevParticle.getTerm().isModelGroup()) {
                        this.endRepeatableParticle(prevParticle);
                    }
                    if (newCursors.size() > 1 && curParticle.isRepeatable()) {
                        this.startRepeatableParticle(startName, curParticle);
                    }
                } else {
                    repeatedParticle = true;
                }
                Object o = item.o;
                for (int i = newCursors.size() - 2; i >= 0; --i) {
                    cursor = (ModelGroupBinding.Cursor)newCursors.get(i);
                    ParticleBinding modelGroupParticle = cursor.getParticle();
                    handler = this.getHandler(modelGroupParticle);
                    o = handler.startParticle(o, startName, modelGroupParticle, atts, this.nsRegistry);
                    this.push(cursor, o, handler);
                }
                cursor = (ModelGroupBinding.Cursor)newCursors.get(0);
                particle = cursor.getCurrentParticle();
                break;
            }
        }
        Object o = null;
        if (particle != null) {
            String nil;
            List interceptors;
            TypeBinding type;
            ElementBinding element;
            Object parent;
            Object object = this.stack.isEmpty() ? null : (parent = repeated ? this.stack.peek((int)1).o : this.stack.peek().o);
            if (particle.getTerm() instanceof WildcardBinding) {
                element = cursor.getElement();
                if (element == null) {
                    throw new JBossXBRuntimeException("Failed to resolve element " + startName + " for wildcard.");
                }
                if (!repeatedParticle && particle.isRepeatable()) {
                    this.startRepeatableParticle(startName, particle);
                }
                particle = new ParticleBinding(element);
            }
            element = (ElementBinding)particle.getTerm();
            String xsiType = atts.getValue("xsi:type");
            if (xsiType != null) {
                String xsiTypeLocal;
                String xsiTypePrefix;
                int colon;
                if (this.trace) {
                    log.trace((Object)(element.getQName() + " uses xsi:type " + xsiType));
                }
                if ((colon = xsiType.indexOf(58)) == -1) {
                    xsiTypePrefix = "";
                    xsiTypeLocal = xsiType;
                } else {
                    xsiTypePrefix = xsiType.substring(0, colon);
                    xsiTypeLocal = xsiType.substring(colon + 1);
                }
                String xsiTypeNs = this.nsRegistry.getNamespaceURI(xsiTypePrefix);
                QName xsiTypeQName = new QName(xsiTypeNs, xsiTypeLocal);
                TypeBinding xsiTypeBinding = schemaBinding.getType(xsiTypeQName);
                if (xsiTypeBinding == null) {
                    throw new JBossXBRuntimeException("Type binding not found for type " + xsiTypeQName + " specified with xsi:type for element " + startName);
                }
                element = new ElementBinding(schemaBinding, startName, xsiTypeBinding);
                particle = new ParticleBinding(element, particle.getMinOccurs(), particle.getMaxOccurs(), particle.getMaxOccursUnbounded());
            }
            if (!repeated && particle.isRepeatable()) {
                this.startRepeatableParticle(startName, particle);
            }
            if ((type = element.getType()) == null) {
                throw new JBossXBRuntimeException("No type for element " + element);
            }
            handler = type.getHandler();
            if (handler == null) {
                handler = this.defParticleHandler;
            }
            if (!(interceptors = element.getInterceptors()).isEmpty()) {
                if (repeated) {
                    this.pop();
                }
                for (int i = 0; i < interceptors.size(); ++i) {
                    ElementInterceptor interceptor = (ElementInterceptor)interceptors.get(i);
                    parent = interceptor.startElement(parent, startName, type);
                    this.push(startName, particle, parent, handler);
                    interceptor.attributes(parent, startName, type, atts, this.nsRegistry);
                }
                if (repeated) {
                    this.stack.push(item);
                }
            }
            o = (nil = atts.getValue("xsi:nil")) == null || !"1".equals(nil) && !"true".equals(nil) ? handler.startParticle(parent, startName, particle, atts, this.nsRegistry) : NIL;
        } else {
            TermBinding parentBinding = null;
            if (!this.stack.isEmpty()) {
                ParticleBinding stackParticle;
                ParticleBinding particleBinding = stackParticle = repeated ? this.stack.peek((int)1).particle : this.stack.peek().particle;
                if (stackParticle != null) {
                    parentBinding = (ElementBinding)stackParticle.getTerm();
                }
            }
            if (parentBinding != null && parentBinding.getSchema() != null) {
                schemaBinding = parentBinding.getSchema();
            }
            String msg = "Element " + startName + " is not bound " + (parentBinding == null ? "as a global element." : "in type " + ((ElementBinding)parentBinding).getType().getQName());
            if (schemaBinding != null && schemaBinding.isStrictSchema()) {
                throw new JBossXBRuntimeException(msg);
            }
            if (this.trace) {
                log.trace((Object)msg);
            }
        }
        if (repeated) {
            item.o = o;
            item.particle = particle;
            return;
        } else {
            this.push(startName, particle, o, handler);
        }
    }

    private ParticleHandler getHandler(ParticleBinding modelGroupParticle) {
        ParticleHandler handler = ((ModelGroupBinding)modelGroupParticle.getTerm()).getHandler();
        return handler == null ? this.defParticleHandler : handler;
    }

    private void endRepeatableParent(QName startName) {
        StackItem parentItem;
        int parentPos = 1;
        ParticleBinding parentParticle = null;
        while (true) {
            parentItem = this.stack.peek(parentPos);
            if (parentItem.cursor == null) {
                throw new JBossXBRuntimeException("Failed to start " + startName + ": the element is not repeatable, repeatable parent expected to be a model group but got element " + ((ElementBinding)parentItem.particle.getTerm()).getQName());
            }
            parentParticle = parentItem.particle;
            if (parentParticle.isRepeatable()) break;
            this.endParticle(parentItem, startName, ++parentPos);
        }
        if (!parentParticle.isRepeatable()) {
            StringBuffer msg = new StringBuffer();
            StackItem item = this.stack.peek();
            ParticleBinding currentParticle = item.particle;
            msg.append("Failed to start ").append(startName).append(": ").append(currentParticle.getTerm()).append(" is not repeatable.").append(" Its parent ").append(parentParticle.getTerm()).append(" expected to be repeatable!").append("\ncurrent stack: ");
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                item = this.stack.peek(i);
                ParticleBinding particle = item.particle;
                TermBinding term = particle.getTerm();
                if (term.isModelGroup()) {
                    if (term instanceof SequenceBinding) {
                        msg.append("sequence");
                    } else if (term instanceof ChoiceBinding) {
                        msg.append("choice");
                    } else {
                        msg.append("all");
                    }
                } else if (term.isWildcard()) {
                    msg.append("wildcard");
                } else {
                    msg.append(((ElementBinding)term).getQName());
                }
                msg.append("\\");
            }
            throw new JBossXBRuntimeException(msg.toString());
        }
        this.endParticle(parentItem, startName, parentPos + 1);
        parentItem = this.stack.peek(parentPos + 1);
        while (parentPos > 0) {
            StackItem item = this.stack.peek(parentPos--);
            ParticleHandler handler = this.getHandler(item.particle);
            item.reset();
            item.o = handler.startParticle(parentItem.o, startName, item.particle, null, this.nsRegistry);
            parentItem = item;
        }
    }

    private void startRepeatableParticle(QName startName, ParticleBinding particle) {
        TermBinding term = particle.getTerm();
        if (term.isSkip()) {
            return;
        }
        StackItem item = this.stack.peek();
        if (item.o != null && !(item.o instanceof GenericValueContainer) && term.getAddMethodMetaData() == null && term.getMapEntryMetaData() == null && term.getPutMethodMetaData() == null) {
            ValueListHandler handler = ValueListHandler.FACTORY.lazy(item.o);
            Class<?> cls = item.o.getClass();
            item.repeatableParticleValue = new ValueListInitializer().newValueList(handler, cls);
        }
    }

    private void endRepeatableParticle(ParticleBinding particle) {
        StackItem item = this.stack.peek();
        ValueList valueList = item.repeatableParticleValue;
        if (valueList != null) {
            item.repeatableParticleValue = null;
            if (valueList.size() == 0) {
                return;
            }
            if (particle.getTerm().isWildcard()) {
                ParticleHandler handler = ((WildcardBinding)particle.getTerm()).getWildcardHandler();
                if (handler == null) {
                    handler = this.defParticleHandler;
                }
                QName qName = valueList.getValue((int)0).qName;
                ArrayList<Object> col = new ArrayList<Object>();
                for (int i = 0; i < valueList.size(); ++i) {
                    col.add(valueList.getValue((int)i).value);
                }
                StackItem parentItem = this.stack.peek(1);
                handler.setParent(parentItem.o, col, qName, particle, parentItem.particle);
            } else {
                valueList.getHandler().newInstance(particle, valueList);
            }
        }
    }

    private void endParticle(StackItem item, QName qName, int parentStackPos) {
        Object o;
        if (item.ended) {
            throw new JBossXBRuntimeException(item.particle.getTerm() + " has already been ended.");
        }
        ParticleBinding modelGroupParticle = item.particle;
        ParticleHandler handler = item.handler;
        if (item.o instanceof ValueList && !modelGroupParticle.getTerm().isSkip()) {
            if (this.trace) {
                log.trace((Object)("endParticle " + modelGroupParticle.getTerm() + " valueList"));
            }
            ValueList valueList = (ValueList)item.o;
            o = valueList.getHandler().newInstance(modelGroupParticle, valueList);
        } else {
            o = handler.endParticle(item.o, qName, modelGroupParticle);
        }
        item.ended = true;
        item = this.stack.peek(parentStackPos);
        if (item.o != null) {
            ParticleBinding parentParticle = this.getParentParticle();
            if (parentParticle == null) {
                parentParticle = item.particle;
            }
            this.setParent(handler, item.repeatableParticleValue == null ? item.o : item.repeatableParticleValue, o, qName, modelGroupParticle, parentParticle);
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.nsRegistry.addPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.nsRegistry.removePrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) {
    }

    public Object getRoot() {
        return this.root;
    }

    private void flushIgnorableCharacters() {
        StackItem stackItem = this.stack.peek();
        if (stackItem.cursor != null || stackItem.textContent == null) {
            return;
        }
        if (stackItem.indentation == Boolean.TRUE || stackItem.ignorableCharacters) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ignored characters: " + ((ElementBinding)stackItem.particle.getTerm()).getQName() + " '" + stackItem.textContent + "'"));
            }
            stackItem.textContent = null;
            stackItem.indentation = null;
        }
    }

    private ParticleBinding getParentParticle() {
        ListIterator iter = this.stack.prevIterator();
        while (iter.hasPrevious()) {
            StackItem prev = (StackItem)iter.previous();
            ParticleBinding peeked = prev.particle;
            TermBinding term = peeked.getTerm();
            if (term.isSkip()) continue;
            return peeked;
        }
        return null;
    }

    private void endElement() {
        StackItem item = this.stack.peek();
        Object o = item.o;
        ParticleBinding particle = item.particle;
        ElementBinding element = (ElementBinding)particle.getTerm();
        QName endName = element.getQName();
        TypeBinding type = element.getType();
        List interceptors = element.getInterceptors();
        int interceptorsTotal = interceptors.size();
        if (o != NIL) {
            String textContent;
            this.flushIgnorableCharacters();
            TypeBinding charType = type.getSimpleType();
            if (charType == null) {
                charType = type;
            }
            CharactersHandler charHandler = item.ignoreCharacters ? null : charType.getCharactersHandler();
            String string = textContent = item.textContent == null ? "" : item.textContent.toString();
            if (textContent.length() > 0 || charHandler != null && type.isSimple()) {
                Object unmarshalled;
                String dataContent;
                SchemaBinding schema = element.getSchema();
                if (textContent.length() == 0) {
                    dataContent = null;
                } else {
                    dataContent = textContent.toString();
                    if (schema != null && schema.isReplacePropertyRefs()) {
                        dataContent = StringPropertyReplacer.replaceProperties((String)dataContent);
                    }
                }
                if (charHandler == null) {
                    if (!type.isSimple() && schema != null && schema.isStrictSchema() && !element.isSkip()) {
                        throw new JBossXBRuntimeException("Element " + endName + " with type binding " + type.getQName() + " does not include text content binding: " + dataContent);
                    }
                    unmarshalled = dataContent;
                } else {
                    CharactersMetaData charactersMetaData;
                    ValueMetaData valueMetaData = element.getValueMetaData();
                    if (valueMetaData == null && (charactersMetaData = type.getCharactersMetaData()) != null) {
                        valueMetaData = charactersMetaData.getValue();
                    }
                    Object object = unmarshalled = dataContent == null ? charHandler.unmarshalEmpty(endName, charType, this.nsRegistry, valueMetaData) : charHandler.unmarshal(endName, charType, this.nsRegistry, valueMetaData, dataContent);
                }
                if (unmarshalled != null) {
                    if (o == null) {
                        o = unmarshalled;
                    } else if (charHandler != null) {
                        TermBeforeSetParentCallback beforeSetParent = charType.getBeforeSetParentCallback();
                        if (beforeSetParent != null) {
                            this.ctx.parent = o;
                            this.ctx.particle = particle;
                            this.ctx.parentParticle = this.getParentParticle();
                            unmarshalled = beforeSetParent.beforeSetParent(unmarshalled, this.ctx);
                            this.ctx.clear();
                        }
                        if (o instanceof ValueList) {
                            ValueList valueList = (ValueList)o;
                            if (type.isSimple()) {
                                valueList.getInitializer().addTermValue(endName, particle, charHandler, valueList, unmarshalled, null);
                            } else {
                                valueList.getInitializer().addTextValue(endName, particle, charHandler, valueList, unmarshalled);
                            }
                        } else {
                            charHandler.setValue(endName, element, o, unmarshalled);
                        }
                    }
                }
                for (int i = interceptorsTotal - 1; i >= 0; --i) {
                    ElementInterceptor interceptor = (ElementInterceptor)interceptors.get(i);
                    interceptor.characters(this.stack.peek((int)(interceptorsTotal - i)).o, endName, type, this.nsRegistry, dataContent);
                }
            }
        } else {
            o = null;
        }
        StackItem parentItem = this.stack.size() == 1 ? null : this.stack.peek(1);
        Object parent = parentItem == null ? null : parentItem.o;
        ParticleHandler handler = this.stack.peek().handler;
        if (o instanceof ValueList && !particle.getTerm().isSkip()) {
            if (this.trace) {
                log.trace((Object)("endParticle " + endName + " valueList"));
            }
            ValueList valueList = (ValueList)o;
            o = valueList.getHandler().newInstance(particle, valueList);
        } else {
            o = handler.endParticle(o, endName, particle);
        }
        for (int i = interceptorsTotal - 1; i >= 0; --i) {
            ElementInterceptor interceptor = (ElementInterceptor)interceptors.get(i);
            interceptor.endElement(this.stack.peek((int)(interceptorsTotal - i)).o, endName, type);
        }
        if (interceptorsTotal == 0) {
            WildcardBinding wildcard;
            ParticleBinding parentParticle = this.getParentParticle();
            boolean hasWildcard = false;
            ParticleHandler wildcardHandler = null;
            if (parentParticle != null && parentParticle.getTerm().isElement() && (wildcard = ((ElementBinding)parentParticle.getTerm()).getType().getWildcard()) != null) {
                hasWildcard = true;
                wildcardHandler = wildcard.getWildcardHandler();
            }
            if (parent != null) {
                if (wildcardHandler != null) {
                    this.setParent(wildcardHandler, parentItem.repeatableParticleValue == null ? parent : parentItem.repeatableParticleValue, o, endName, particle, parentParticle);
                } else {
                    this.setParent(handler, parentItem.repeatableParticleValue == null ? parent : parentItem.repeatableParticleValue, o, endName, particle, parentParticle);
                }
            } else if (parentParticle != null && hasWildcard && this.stack.size() > 1) {
                ListIterator iter = this.stack.prevIterator();
                while (iter.hasPrevious()) {
                    StackItem peeked = (StackItem)iter.previous();
                    peeked.o = o;
                    if (peeked.cursor != null) continue;
                    break;
                }
                if (this.trace) {
                    log.trace((Object)("Value of " + endName + " " + o + " is promoted as the value of its parent element."));
                }
            }
        } else {
            StackItem popped = this.pop();
            for (int i = interceptorsTotal - 1; i >= 0; --i) {
                ElementInterceptor interceptor = (ElementInterceptor)interceptors.get(i);
                parent = this.pop().o;
                interceptor.add(parent, o, endName);
                o = parent;
            }
            this.stack.push(popped);
        }
        if (this.stack.size() == 1) {
            this.root = o;
            this.stack.clear();
        }
    }

    private void setParent(ParticleHandler handler, Object parent, Object o, QName endName, ParticleBinding particle, ParticleBinding parentParticle) {
        TermBeforeSetParentCallback beforeSetParent = particle.getTerm().getBeforeSetParentCallback();
        if (beforeSetParent != null) {
            this.ctx.parent = parent;
            this.ctx.particle = particle;
            this.ctx.parentParticle = parentParticle;
            o = beforeSetParent.beforeSetParent(o, this.ctx);
            this.ctx.clear();
        }
        if (parent instanceof ValueList) {
            if (parent == o) {
                return;
            }
            ValueList valueList = (ValueList)parent;
            valueList.getInitializer().addTermValue(endName, particle, handler, valueList, o, parentParticle);
        } else {
            handler.setParent(parent, o, endName, particle, parentParticle);
        }
    }

    private void push(QName qName, ParticleBinding particle, Object o, ParticleHandler handler) {
        StackItem item = new StackItem(particle, o, handler);
        this.stack.push(item);
        if (this.trace) {
            TermBinding binding = null;
            if (particle != null) {
                binding = particle.getTerm();
            }
            log.trace((Object)("pushed " + qName + "=" + o + ", binding=" + binding));
        }
    }

    private void push(ModelGroupBinding.Cursor cursor, Object o, ParticleHandler handler) {
        StackItem item = new StackItem(cursor, o, handler);
        this.stack.push(item);
        if (this.trace) {
            log.trace((Object)("pushed cursor " + cursor + ", o=" + o));
        }
    }

    private StackItem pop() {
        StackItem item = this.stack.pop();
        if (this.trace) {
            if (item.cursor == null) {
                log.trace((Object)("poped " + ((ElementBinding)item.particle.getTerm()).getQName() + "=" + item.particle));
            } else {
                log.trace((Object)("poped " + item.cursor.getCurrentParticle().getTerm()));
            }
        }
        return item;
    }

    private class UnmarshallingContextImpl
    implements UnmarshallingContext {
        Object parent;
        ParticleBinding particle;
        ParticleBinding parentParticle;

        private UnmarshallingContextImpl() {
        }

        public Object getParentValue() {
            return this.parent;
        }

        public ParticleBinding getParticle() {
            return this.particle;
        }

        public ParticleBinding getParentParticle() {
            return this.parentParticle;
        }

        public String resolvePropertyName() {
            String prop;
            TermBinding term = this.particle.getTerm();
            PropertyMetaData propertyMetaData = term.getPropertyMetaData();
            String string = prop = propertyMetaData == null ? null : propertyMetaData.getName();
            if (prop != null) {
                return prop;
            }
            if (term.isElement()) {
                QName name = ((ElementBinding)term).getQName();
                prop = Util.xmlNameToFieldName(name.getLocalPart(), term.getSchema().isIgnoreLowLine());
            }
            return prop;
        }

        public Class resolvePropertyType() {
            FieldInfo fieldInfo;
            if (this.parent == null) {
                return null;
            }
            String prop = this.resolvePropertyName();
            if (prop != null && (fieldInfo = FieldInfo.getFieldInfo(this.parent.getClass(), prop, false)) != null) {
                return fieldInfo.getType();
            }
            return null;
        }

        void clear() {
            ((SundayContentHandler)SundayContentHandler.this).ctx.parent = null;
            ((SundayContentHandler)SundayContentHandler.this).ctx.particle = null;
            ((SundayContentHandler)SundayContentHandler.this).ctx.parentParticle = null;
        }
    }

    static class StackImpl {
        private List list = new ArrayList();

        StackImpl() {
        }

        public void clear() {
            this.list.clear();
        }

        public void push(Object o) {
            this.list.add(o);
        }

        public StackItem pop() {
            return (StackItem)this.list.remove(this.list.size() - 1);
        }

        public ListIterator prevIterator() {
            return this.list.listIterator(this.list.size() - 1);
        }

        public StackItem peek() {
            return (StackItem)this.list.get(this.list.size() - 1);
        }

        public StackItem peek(int i) {
            return (StackItem)this.list.get(this.list.size() - 1 - i);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public int size() {
            return this.list.size();
        }
    }

    private static class StackItem {
        final ModelGroupBinding.Cursor cursor;
        ParticleBinding particle;
        ParticleHandler handler;
        boolean ignoreCharacters;
        Object o;
        ValueList repeatableParticleValue;
        StringBuffer textContent;
        Boolean indentation;
        boolean ignorableCharacters = true;
        boolean ended;

        public StackItem(ModelGroupBinding.Cursor cursor, Object o, ParticleHandler handler) {
            if (cursor == null) {
                throw new IllegalArgumentException("Null cursor");
            }
            this.cursor = cursor;
            this.particle = cursor.getParticle();
            this.o = o;
            this.handler = handler;
        }

        public StackItem(ParticleBinding particle, Object o, ParticleHandler handler) {
            if (particle == null) {
                throw new IllegalArgumentException("Null particle");
            }
            this.cursor = null;
            this.particle = particle;
            this.o = o;
            this.handler = handler;
        }

        void reset() {
            if (!this.ended) {
                throw new JBossXBRuntimeException("Attempt to reset a particle that has already been reset: " + this.particle.getTerm());
            }
            this.ended = false;
            this.o = null;
            if (this.textContent != null) {
                this.textContent.delete(0, this.textContent.length());
            }
            this.indentation = null;
            this.ignorableCharacters = true;
        }
    }
}

