/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.HashMap;
import java.util.HashSet;
import javax.ejb.EJBContext;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.ejb3.BaseSessionContext;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.security.RealmMapping;

public abstract class BaseContext
implements BeanContext {
    protected static Logger log = Logger.getLogger(BaseContext.class);
    protected Container container;
    protected Object bean;
    protected RealmMapping rm;
    protected SimpleMetaData metadata;
    protected EJBContext ejbContext;
    protected HashMap<Class, Object> interceptorInstances;

    public Object getId() {
        return null;
    }

    public Object getInstance() {
        return this.bean;
    }

    public void setInstance(Object instance) {
        this.bean = instance;
    }

    public Container getContainer() {
        return this.container;
    }

    public SimpleMetaData getMetaData() {
        if (this.metadata == null) {
            this.metadata = new SimpleMetaData();
        }
        return this.metadata;
    }

    public void setContainer(Container container) {
        this.container = container;
        this.bindEJBContext();
    }

    public void bindEJBContext() {
        try {
            Util.rebind((Context)this.container.getEnc(), (String)"EJBContext", (Object)this.getEJBContext());
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void initialiseInterceptorInstances() {
        HashSet<InterceptorInfo> interceptors = ((EJBContainer)this.container).getApplicableInterceptors();
        if (interceptors != null && interceptors.size() > 0 && this.interceptorInstances == null) {
            HashMap<Class, InterceptorInjector> interceptorInjectors = ((EJBContainer)this.container).getInterceptorInjectors();
            this.interceptorInstances = new HashMap();
            for (InterceptorInfo info : interceptors) {
                try {
                    Object instance = info.getClazz().newInstance();
                    this.interceptorInstances.put(info.getClazz(), instance);
                    interceptorInjectors.get(info.getClazz()).inject(this, instance);
                }
                catch (Exception e) {
                    log.warn((Object)("Interceptors must have a public noargs constructor: " + info.getClazz().getName()));
                }
            }
        }
    }

    public EJBContext getEJBContext() {
        if (this.ejbContext == null) {
            BaseSessionContext bsc = new BaseSessionContext();
            bsc.setContainer(this.getContainer());
            bsc.setBaseContext(this);
            this.ejbContext = bsc;
        }
        return this.ejbContext;
    }

    public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos) {
        Object[] interceptors = new Object[interceptorInfos.length];
        int i = 0;
        for (InterceptorInfo info : interceptorInfos) {
            interceptors[i++] = this.interceptorInstances.get(info.getClazz());
        }
        return interceptors;
    }

    public Object getInvokedMethodKey() {
        return this.container;
    }
}

