/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.lang.ref.WeakReference;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;

public class ScopedClassLoaderDomain
extends Domain {
    WeakReference loader;
    boolean parentDelegation;
    ConcurrentReaderHashMap myPerVMAspects = new ConcurrentReaderHashMap();
    ConcurrentReaderHashMap notMyPerVMAspects = new ConcurrentReaderHashMap();

    public ScopedClassLoaderDomain(ClassLoader loader, String name, boolean parentDelegation, AspectManager manager, boolean parentFirst) {
        super(manager, name, parentFirst);
        this.loader = new WeakReference<ClassLoader>(loader);
        this.parentDelegation = parentDelegation;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader cl = (ClassLoader)this.loader.get();
        if (cl != null) {
            return cl;
        }
        return null;
    }

    public void removeAspectDefinition(String name) {
        AspectDefinition def = super.internalRemoveAspectDefintion(name);
        if (def != null) {
            Object object = this.myPerVMAspects.remove((Object)name);
        }
    }

    public Object getPerVMAspect(AspectDefinition def) {
        return this.getPerVMAspect(def.getName());
    }

    public Object getPerVMAspect(String def) {
        if (this.parentDelegation) {
            Object aspect = super.getPerVMAspect(def);
            return aspect;
        }
        return this.getPerVmAspectWithNoParentDelegation(def);
    }

    private Object getPerVmAspectWithNoParentDelegation(String def) {
        Object aspect = this.myPerVMAspects.get((Object)def);
        if (aspect != null) {
            return aspect;
        }
        aspect = super.getPerVMAspect(def);
        if (aspect != null) {
            HeirarchicalLoaderRepository3 myRepository;
            LoaderRepository loadingRepository = this.getAspectRepository(aspect);
            if (loadingRepository == (myRepository = this.getScopedRepository())) {
                this.myPerVMAspects.put((Object)def, aspect);
            } else {
                try {
                    Class clazz = myRepository.loadClass(aspect.getClass().getName());
                    if (clazz == aspect.getClass()) {
                        this.notMyPerVMAspects.put((Object)def, (Object)Boolean.TRUE);
                    } else {
                        AspectDefinition aspectDefinition = this.getAspectDefinition(def);
                        aspect = this.createPerVmAspect(def, aspectDefinition, this.getClassLoader());
                        this.myPerVMAspects.put((Object)def, aspect);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return aspect;
    }

    private LoaderRepository getAspectRepository(Object aspect) {
        ClassLoader cl;
        for (ClassLoader parent = cl = aspect.getClass().getClassLoader(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof RepositoryClassLoader)) continue;
            return ((RepositoryClassLoader)parent).getLoaderRepository();
        }
        return null;
    }

    private HeirarchicalLoaderRepository3 getScopedRepository() {
        HeirarchicalLoaderRepository3 myRepository = (HeirarchicalLoaderRepository3)((RepositoryClassLoader)this.getClassLoader()).getLoaderRepository();
        return myRepository;
    }
}

