/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynch;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.asynch.AsynchProvider;
import org.jboss.aspects.asynch.Future;

public class AsynchProxyMixin
implements AsynchProvider,
Externalizable {
    private static final long serialVersionUID = -6895953696792282031L;
    public static final String CURRENT_FUTURE = "CURRENT_FUTURE";
    private transient ThreadLocal currentFuture;
    private InstanceAdvisor advisor;

    public void setAdvisor(InstanceAdvisor advisor) {
        this.advisor = advisor;
    }

    public void setFuture(Future future) {
        try {
            Future oldFuture = this.getFuture();
            if (oldFuture != null) {
                oldFuture.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentFuture.set(future);
    }

    public Future getFuture() {
        Future future = (Future)this.currentFuture.get();
        this.currentFuture.set(null);
        return future;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.advisor);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.advisor = (InstanceAdvisor)in.readObject();
        this.currentFuture = new ThreadLocal();
        this.advisor.getMetaData().addMetaData((Object)CURRENT_FUTURE, (Object)CURRENT_FUTURE, (Object)this.currentFuture, PayloadKey.TRANSIENT);
    }
}

