/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.LifecycleHandlerFactory;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.InvocationHandlerFactory;
import org.jboss.wsf.spi.invocation.InvocationType;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.invocation.RequestHandlerFactory;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;

public class EndpointHandlerDeploymentAspect
extends DeploymentAspect {
    private SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();

    public void create(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ep.setRequestHandler(this.getRequestHandler(dep));
            ep.setLifecycleHandler(this.getLifecycleHandler(dep));
            InvocationHandler invocationHandler = this.getInvocationHandler(ep);
            if (invocationHandler == null) continue;
            ep.setInvocationHandler(invocationHandler);
        }
    }

    private RequestHandler getRequestHandler(Deployment dep) {
        return ((RequestHandlerFactory)this.spiProvider.getSPI(RequestHandlerFactory.class)).newRequestHandler();
    }

    private LifecycleHandler getLifecycleHandler(Deployment dep) {
        return ((LifecycleHandlerFactory)this.spiProvider.getSPI(LifecycleHandlerFactory.class)).newLifecylceHandler();
    }

    private InvocationHandler getInvocationHandler(Endpoint ep) {
        EJBMetaData bmd;
        Deployment dep = ep.getService().getDeployment();
        String key = dep.getType().toString();
        EJBArchiveMetaData uapp = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
        if (uapp != null && (bmd = uapp.getBeanByEjbName(ep.getShortName())) instanceof MDBMetaData) {
            key = "JAXRPC_MDB21";
        }
        InvocationType type = InvocationType.valueOf((String)key);
        InvocationHandler invocationHandler = ((InvocationHandlerFactory)this.spiProvider.getSPI(InvocationHandlerFactory.class)).newInvocationHandler(type);
        return invocationHandler;
    }
}

