/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EjbModule;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStartCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStopCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCXmlFileLoader;
import org.jboss.ejb.plugins.cmp.jdbc2.ApplicationPkCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.CreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.InstanceFactory;
import org.jboss.ejb.plugins.cmp.jdbc2.PersistentContext;
import org.jboss.ejb.plugins.cmp.jdbc2.QueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.QueryFactory;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.tm.TransactionLocal;

public class JDBCStoreManager2
implements JDBCEntityPersistenceStore {
    private static final String CATALOG = "CATALOG";
    private static final String SCHEMA = "SCHEMA";
    private static final String CREATED_MANAGERS = "CREATED_JDBCStoreManagers";
    private static final String CMP_JDBC = "CMP-JDBC";
    private EntityContainer container;
    private EjbModule ejbModule;
    private Logger log;
    private JDBCEntityMetaData metaData;
    private JDBCEntityBridge2 entityBridge;
    private JDBCTypeFactory typeFactory;
    private Schema schema;
    private InstanceFactory instanceFactory;
    private QueryFactory queryFactory;
    private CreateCommand createCmd;
    private JDBCStartCommand startCmd;
    private JDBCStopCommand stop;
    private final TransactionLocal cascadeDeleteRegistry = new TransactionLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };

    public Schema getSchema() {
        this.schema = (Schema)this.getApplicationData(SCHEMA);
        if (this.schema == null) {
            this.schema = new Schema();
            this.putApplicationData(SCHEMA, this.schema);
        }
        return this.schema;
    }

    public Catalog getCatalog() {
        Catalog catalog = (Catalog)this.getApplicationData(CATALOG);
        if (catalog == null) {
            catalog = new Catalog();
            this.putApplicationData(CATALOG, catalog);
        }
        return catalog;
    }

    public QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public boolean registerCascadeDelete(Object key, Object value) {
        Map map = (Map)this.cascadeDeleteRegistry.get();
        return map.put(key, value) == null;
    }

    public boolean isCascadeDeleted(Object key) {
        Map map = (Map)this.cascadeDeleteRegistry.get();
        return map.containsKey(key);
    }

    public void unregisterCascadeDelete(Object key) {
        Map map = (Map)this.cascadeDeleteRegistry.get();
        map.remove(key);
    }

    public void setContainer(Container con) {
        this.container = (EntityContainer)con;
        if (this.container != null) {
            this.ejbModule = this.container.getEjbModule();
            this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.container.getBeanMetaData().getEjbName()));
        } else {
            this.ejbModule = null;
        }
    }

    public void create() throws Exception {
        HashMap<String, JDBCStoreManager2> managersMap = (HashMap<String, JDBCStoreManager2>)this.getApplicationData(CREATED_MANAGERS);
        if (managersMap == null) {
            managersMap = new HashMap<String, JDBCStoreManager2>();
            this.putApplicationData(CREATED_MANAGERS, managersMap);
        }
        managersMap.put(this.container.getBeanMetaData().getEjbName(), this);
    }

    public void start() throws Exception {
        this.initStoreManager();
        HashMap managersMap = (HashMap)this.getApplicationData(CREATED_MANAGERS);
        Catalog catalog = this.getCatalog();
        if (catalog.getEntityCount() == managersMap.size() && ((Object)catalog.getEJBNames()).equals(managersMap.keySet())) {
            JDBCStoreManager2 manager;
            int i;
            ArrayList managers = new ArrayList(managersMap.values());
            for (i = 0; i < managers.size(); ++i) {
                manager = (JDBCStoreManager2)managers.get(i);
                manager.resolveRelationships();
            }
            for (i = 0; i < managers.size(); ++i) {
                manager = (JDBCStoreManager2)managers.get(i);
                manager.startEntity();
            }
            for (i = 0; i < managers.size(); ++i) {
                manager = (JDBCStoreManager2)managers.get(i);
                manager.startStoreManager();
            }
            for (i = 0; i < managers.size(); ++i) {
                manager = (JDBCStoreManager2)managers.get(i);
                manager.startCmd.addForeignKeyConstraints();
            }
        }
    }

    public void stop() {
        if (this.stop != null) {
            HashMap managersMap = (HashMap)this.getApplicationData(CREATED_MANAGERS);
            while (!managersMap.isEmpty()) {
                int stoppedInIteration = 0;
                Iterator i = managersMap.values().iterator();
                while (i.hasNext()) {
                    JDBCStoreManager2 manager = (JDBCStoreManager2)i.next();
                    if (!manager.stop.execute()) continue;
                    i.remove();
                    try {
                        manager.entityBridge.stop();
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Failed to stop entity bridge.", (Throwable)e);
                    }
                    ++stoppedInIteration;
                }
                if (stoppedInIteration != 0) continue;
                break;
            }
        }
    }

    public void destroy() {
    }

    public JDBCAbstractEntityBridge getEntityBridge() {
        return this.entityBridge;
    }

    public JDBCEntityMetaData getMetaData() {
        return this.metaData;
    }

    public JDBCTypeFactory getJDBCTypeFactory() {
        return this.typeFactory;
    }

    public EntityContainer getContainer() {
        return this.container;
    }

    public Object getApplicationData(Object key) {
        return this.ejbModule.getModuleData(key);
    }

    public void putApplicationData(Object key, Object value) {
        this.ejbModule.putModuleData(key, value);
    }

    public Object createBeanClassInstance() throws Exception {
        return this.instanceFactory.newInstance();
    }

    public void initEntity(EntityEnterpriseContext ctx) {
        this.entityBridge.initPersistenceContext(ctx);
        this.entityBridge.initInstance(ctx);
    }

    public Object createEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws CreateException {
        return this.createCmd.execute(m, args, ctx);
    }

    public Object postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws CreateException {
        return null;
    }

    public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory) throws FinderException {
        QueryCommand query = this.queryFactory.getQueryCommand(finderMethod);
        return query.fetchOne(this.schema, factory, args);
    }

    public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory) throws FinderException {
        QueryCommand query = this.queryFactory.getQueryCommand(finderMethod);
        return query.fetchCollection(this.schema, factory, args);
    }

    public void activateEntity(EntityEnterpriseContext ctx) {
        this.entityBridge.initPersistenceContext(ctx);
    }

    public void loadEntity(EntityEnterpriseContext ctx) {
        try {
            EntityTable.Row row = this.entityBridge.getTable().loadRow(ctx.getId());
            PersistentContext pctx = new PersistentContext(this.entityBridge, row);
            ctx.setPersistenceContext(pctx);
        }
        catch (EJBException e) {
            this.log.error((Object)("Failed to load instance of " + this.entityBridge.getEntityName() + " with pk=" + ctx.getId()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Failed to load instance of " + this.entityBridge.getEntityName() + " with pk=" + ctx.getId(), e);
        }
    }

    public boolean isStoreRequired(EntityEnterpriseContext instance) {
        return this.entityBridge.isStoreRequired(instance);
    }

    public boolean isModified(EntityEnterpriseContext instance) throws Exception {
        return this.entityBridge.isModified(instance);
    }

    public void storeEntity(EntityEnterpriseContext instance) {
    }

    public void passivateEntity(EntityEnterpriseContext ctx) {
        JDBCEntityBridge2.destroyPersistenceContext(ctx);
    }

    public void removeEntity(EntityEnterpriseContext ctx) throws RemoveException {
        this.entityBridge.remove(ctx);
        PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
        pctx.remove();
    }

    protected void initStoreManager() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing CMP plugin for " + this.container.getBeanMetaData().getEjbName()));
        }
        this.metaData = this.loadJDBCEntityMetaData();
        this.typeFactory = new JDBCTypeFactory(this.metaData.getTypeMapping(), this.metaData.getJDBCApplication().getValueClasses(), this.metaData.getJDBCApplication().getUserTypeMappings());
        this.entityBridge = new JDBCEntityBridge2(this, this.metaData);
        this.entityBridge.init();
        Catalog catalog = this.getCatalog();
        catalog.addEntity(this.entityBridge);
        this.stop = new JDBCStopCommand(this);
    }

    private void resolveRelationships() throws Exception {
        this.entityBridge.resolveRelationships();
    }

    protected void startStoreManager() throws Exception {
        this.entityBridge.start();
        this.queryFactory = new QueryFactory(this.entityBridge);
        this.queryFactory.init();
        this.instanceFactory = new InstanceFactory(this, this.entityBridge);
        this.startCmd = new JDBCStartCommand(this);
        this.startCmd.execute();
        JDBCEntityCommandMetaData entityCommand = this.getMetaData().getEntityCommand();
        if (entityCommand == null || "default".equals(entityCommand.getCommandName())) {
            this.createCmd = new ApplicationPkCreateCommand();
        } else {
            Class cmdClass = entityCommand.getCommandClass();
            if (cmdClass == null) {
                throw new DeploymentException("entity-command class name is not specified for entity " + this.entityBridge.getEntityName());
            }
            try {
                this.createCmd = (CreateCommand)cmdClass.newInstance();
            }
            catch (ClassCastException cce) {
                throw new DeploymentException("Entity command " + cmdClass + " does not implement " + CreateCommand.class);
            }
        }
        this.createCmd.init(this);
    }

    private void startEntity() throws DeploymentException {
        this.entityBridge.start();
    }

    private JDBCEntityMetaData loadJDBCEntityMetaData() throws DeploymentException {
        String ejbName;
        JDBCEntityMetaData metadata;
        ApplicationMetaData amd = this.container.getBeanMetaData().getApplicationMetaData();
        JDBCApplicationMetaData jamd = (JDBCApplicationMetaData)amd.getPluginData(CMP_JDBC);
        if (jamd == null) {
            JDBCXmlFileLoader jfl = new JDBCXmlFileLoader(amd, this.container.getClassLoader(), this.container.getLocalClassLoader(), this.log);
            jamd = jfl.load();
            amd.addPluginData(CMP_JDBC, jamd);
        }
        if ((metadata = jamd.getBeanByEjbName(ejbName = this.container.getBeanMetaData().getEjbName())) == null) {
            throw new DeploymentException("No metadata found for bean " + ejbName);
        }
        return metadata;
    }
}

