/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.util.threadpool.BasicThreadPoolMBean;
import org.jboss.web.WebServer;
import org.jboss.web.WebServiceMBean;

public class WebService
extends ServiceMBeanSupport
implements WebServiceMBean {
    private WebServer server = new WebServer();
    private String host;

    public URL addClassLoader(ClassLoader cl) {
        return this.server.addClassLoader(cl);
    }

    public void removeClassLoader(ClassLoader cl) {
        this.server.removeClassLoader(cl);
    }

    public void setPort(int port) {
        this.server.setPort(port);
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void setHost(String hostname) {
        this.host = ServerConfigUtil.fixRemoteAddress((String)hostname);
    }

    public String getHost() {
        return this.host;
    }

    public void setBindAddress(String address) throws UnknownHostException {
        InetAddress bindAddress = this.toInetAddress(address);
        this.server.setBindAddress(bindAddress);
    }

    public String getBindAddress() {
        InetAddress bindAddress = this.server.getBindAddress();
        if (bindAddress != null) {
            return bindAddress.getHostAddress();
        }
        return null;
    }

    public int getBacklog() {
        return this.server.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.server.setBacklog(backlog);
    }

    public void setThreadPool(BasicThreadPoolMBean threadPool) {
        this.server.setThreadPool(threadPool);
    }

    public boolean getDownloadServerClasses() {
        return this.server.getDownloadServerClasses();
    }

    public void setDownloadServerClasses(boolean flag) {
        this.server.setDownloadServerClasses(flag);
    }

    public boolean getDownloadResources() {
        return this.server.getDownloadResources();
    }

    public void setDownloadResources(boolean flag) {
        this.server.setDownloadResources(flag);
    }

    public String getCodebase() {
        return System.getProperty("java.rmi.server.codebase");
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    protected void createService() throws Exception {
        String codebase;
        Properties mimeTypes = new Properties();
        try {
            mimeTypes.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jboss/web/mime.types"));
            Enumeration<Object> keys = mimeTypes.keys();
            while (keys.hasMoreElements()) {
                String extension = (String)keys.nextElement();
                String type = mimeTypes.getProperty(extension);
                this.server.addMimeType(extension, type);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load org/jboss/web/mime.types; ignoring", (Throwable)e);
        }
        if (this.getBindAddress() == null) {
            this.setBindAddress(System.getProperty("jboss.bind.address"));
        }
        if (this.getHost() == null) {
            this.setHost(System.getProperty("java.rmi.server.hostname"));
        }
        if ((codebase = this.getCodebase()) == null) {
            // empty if block
        }
        codebase = "http://" + this.getHost() + ":" + this.getPort() + "/";
        System.setProperty("java.rmi.server.codebase", codebase);
        this.log.info((Object)("Using RMI server codebase: " + codebase));
    }

    protected void startService() throws Exception {
        this.server.start();
        this.log.debug((Object)("Started WebServer with address: " + this.server.getBindAddress() + ":" + this.getPort()));
    }

    protected void stopService() throws Exception {
        this.server.stop();
        this.log.debug((Object)("Stopped WebServer with address: " + this.server.getBindAddress() + ":" + this.getPort()));
    }

    private InetAddress toInetAddress(String host) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return null;
        }
        return InetAddress.getByName(host);
    }
}

