/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.factory;

import com.clustercontrol.accesscontrol.bean.RoleConstant;
import com.clustercontrol.accesscontrol.ejb.entity.RoleLocal;
import com.clustercontrol.accesscontrol.ejb.entity.RoleUtil;
import com.clustercontrol.accesscontrol.ejb.entity.UserLocal;
import com.clustercontrol.accesscontrol.ejb.entity.UserUtil;
import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public class ModifyUser {
    protected static Log m_log = LogFactory.getLog(ModifyUser.class);
    public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    public static final String OBJECT_NAME = "jboss.security:service=JaasSecurityManager";
    public static final String OPERATION_NAME = "flushAuthenticationCache";

    public void addUser(Property property, String userName) throws NamingException, CreateException, FinderException, ParseException {
        AccessLock.lock("ACCESS");
        String uid = null;
        try {
            ArrayList values = null;
            Date now = new Date();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"uid");
            uid = (String)values.get(0);
            this.checkValidUid(uid);
            UserLocal user = UserUtil.getLocalHome().create(uid);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"namae");
            user.setCn(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            user.setDescription(this.checkString(values.get(0)));
            user.setCreatorsName(this.checkString(userName));
            user.setCreateTimestamp(now);
            user.setModifiersName(this.checkString(userName));
            user.setModifyTimestamp(now);
            this.assignUser("HinemosUser", user.getDn());
            List<String> roleList = RoleConstant.getRoles();
            for (int i = 0; i < roleList.size(); ++i) {
                String roleName = roleList.get(i);
                values = PropertyUtil.getPropertyValue((Property)property, (String)roleName);
                if (values.size() <= 0 || !((Boolean)values.get(0)).booleanValue()) continue;
                this.assignUser(roleName, user.getDn());
            }
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("addUser() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("addUser() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("addUser() : " + e.getMessage()));
            throw e;
        }
    }

    public void modifyUser(Property property, String userName) throws NamingException, FinderException {
        AccessLock.lock("ACCESS");
        String uid = null;
        try {
            ArrayList values = null;
            Date now = new Date();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"uid");
            uid = (String)values.get(0);
            UserLocal user = UserUtil.getLocalHome().findByUid(uid);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"namae");
            user.setCn(this.checkString(values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            user.setDescription(this.checkString(values.get(0)));
            user.setModifiersName(this.checkString(userName));
            user.setModifyTimestamp(now);
            List<String> roleList = RoleConstant.getRoles();
            for (int i = 0; i < roleList.size(); ++i) {
                String roleName = roleList.get(i);
                values = PropertyUtil.getPropertyValue((Property)property, (String)roleName);
                if (values.size() <= 0) continue;
                this.releaseUser(roleName, user.getDn());
                if (!((Boolean)values.get(0)).booleanValue()) continue;
                this.assignUser(roleName, user.getDn());
            }
            this.flushAuthenticationCache();
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("modifyUser() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("modifyUser() : " + e.getMessage()));
            throw e;
        }
    }

    public void deleteUser(String uid) throws NamingException, RemoveException, FinderException {
        AccessLock.lock("ACCESS");
        try {
            UserLocal user = UserUtil.getLocalHome().findByUid(uid);
            String dn = user.getDn();
            user.remove();
            List<String> roleList = RoleConstant.getRoles();
            for (int i = 0; i < roleList.size(); ++i) {
                String roleName = roleList.get(i);
                this.releaseUser(roleName, dn);
            }
            this.flushAuthenticationCache();
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("deleteUser() : " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("deleteUser() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("deleteUser() : " + e.getMessage()));
            throw e;
        }
    }

    protected void assignUser(String roleName, String dn) throws FinderException, NamingException {
        RoleLocal role = null;
        try {
            role = RoleUtil.getLocalHome().findByCn(roleName);
            ArrayList<String> list = role.getMember();
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(dn);
            role.setMember(list);
        }
        catch (FinderException e) {
            throw new FinderException("ModifyUser.assignUser() -> error : " + e.getMessage());
        }
        catch (NamingException e) {
            throw e;
        }
    }

    protected void releaseUser(String roleName, String dn) throws FinderException, NamingException {
        RoleLocal role = null;
        try {
            role = RoleUtil.getLocalHome().findByCn(roleName);
            String userDn = dn;
            ArrayList list = role.getMember();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!userDn.equalsIgnoreCase((String)list.get(i))) continue;
                    list.remove(i);
                    break;
                }
                role.setMember(list);
            } else {
                role.setMember(null);
            }
        }
        catch (FinderException e) {
            throw new FinderException("ModifyUser.releaseUser() -> " + e.getMessage());
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public void modifyPassword(String uid, String password) throws FinderException, NamingException {
        AccessLock.lock("ACCESS");
        try {
            UserLocal user = UserUtil.getLocalHome().findByUid(uid);
            user.setPassword(password);
            this.flushAuthenticationCache();
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "009", args);
            m_log.debug((Object)("modifyPassword() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{uid};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("modifyPassword() : " + e.getMessage()));
            throw e;
        }
    }

    private String checkString(Object value) {
        if (value instanceof String) {
            if (((String)value).compareTo("") == 0) {
                return null;
            }
            return (String)value;
        }
        return null;
    }

    private void checkValidUid(String uid) throws ParseException {
        char charData = '\u0000';
        for (int i = 0; i < uid.length(); ++i) {
            charData = uid.charAt(i);
            if (charData >= 'A' && charData <= 'Z' || charData >= 'a' && charData <= 'z' || charData >= '0' && charData <= '9') continue;
            throw new ParseException(uid, i);
        }
    }

    public void flushAuthenticationCache() {
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME);
            Object[] args = new Object[]{"hinemos"};
            String[] signature = new String[]{String.class.getName()};
            server.invoke(name, OPERATION_NAME, args, signature);
        }
        catch (NamingException e) {
            m_log.debug((Object)("flushAuthenticationCache() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            m_log.debug((Object)("flushAuthenticationCache() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            m_log.debug((Object)("flushAuthenticationCache() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            m_log.debug((Object)("flushAuthenticationCache() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            m_log.debug((Object)("flushAuthenticationCache() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            m_log.debug((Object)("flushAuthenticationCache() : " + e.getMessage()));
        }
        catch (IOException e) {
            m_log.debug((Object)("flushAuthenticationCache() : " + e.getMessage()));
        }
    }
}

