/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.interfaces;

import java.io.Serializable;
import java.net.InetAddress;
import org.jgroups.stack.IpAddress;

public class ClusterNode
implements Comparable,
Cloneable,
Serializable {
    protected String id = null;
    protected String jgId = null;
    protected IpAddress originalJGAddress = null;

    public ClusterNode() {
    }

    public ClusterNode(IpAddress jgAddress) {
        this.id = jgAddress.getAdditionalData() == null ? jgAddress.getIpAddress().getHostAddress() + ":" + jgAddress.getPort() : new String(jgAddress.getAdditionalData());
        this.originalJGAddress = jgAddress;
        StringBuffer sb = new StringBuffer();
        InetAddress jgIPAddr = jgAddress.getIpAddress();
        if (jgIPAddr == null) {
            sb.append("<null>");
        } else if (jgIPAddr.isMulticastAddress()) {
            sb.append(jgIPAddr.getHostAddress());
        } else {
            sb.append(this.getShortName(jgIPAddr.getHostName()));
        }
        sb.append(":" + jgAddress.getPort());
        this.jgId = sb.toString();
    }

    public String getName() {
        return this.id;
    }

    public String getJGName() {
        return this.jgId;
    }

    public IpAddress getOriginalJGAddress() {
        return this.originalJGAddress;
    }

    public InetAddress getIpAddress() {
        return this.originalJGAddress.getIpAddress();
    }

    public int getPort() {
        return this.originalJGAddress.getPort();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof ClusterNode)) {
            throw new ClassCastException("ClusterNode.compareTo(): comparison between different classes");
        }
        ClusterNode other = (ClusterNode)o;
        return this.id.compareTo(other.id);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClusterNode)) {
            return false;
        }
        ClusterNode other = (ClusterNode)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    protected String getShortName(String hostname) {
        int index = hostname.indexOf(46);
        if (hostname == null) {
            return "";
        }
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            return hostname.substring(0, index);
        }
        return hostname;
    }
}

