/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.CacheLoaderInterceptorMBean;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.AsyncCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ChainingCacheLoader;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jgroups.blocks.MethodCall;

public class CacheLoaderInterceptor
extends Interceptor
implements CacheLoaderInterceptorMBean {
    private boolean isCustomCacheLoader;
    private long m_cacheLoads = 0L;
    private long m_cacheMisses = 0L;
    private TransactionTable txTable = null;
    protected CacheLoader loader;
    protected boolean useCacheStore = true;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.txTable = cache.getTransactionTable();
        this.loader = cache.getCacheLoaderManager().getCacheLoader();
        this.isCustomCacheLoader = this.isCustomCacheLoaderConfigured(this.loader);
    }

    private boolean isCustomCacheLoaderConfigured(CacheLoader cl) {
        if (cl instanceof ChainingCacheLoader) {
            ChainingCacheLoader ccl = (ChainingCacheLoader)cl;
            Iterator it = ccl.getCacheLoaders().iterator();
            boolean isCustom = false;
            while (it.hasNext()) {
                CacheLoader nextCacheLoader = (CacheLoader)it.next();
                isCustom = isCustom || this.isCustomCacheLoaderConfigured(nextCacheLoader);
            }
            return isCustom;
        }
        if (cl instanceof AsyncCacheLoader) {
            CacheLoader underlying = ((AsyncCacheLoader)cl).getCacheLoader();
            return this.isCustomCacheLoaderConfigured(underlying);
        }
        Package pkg = cl.getClass().getPackage();
        return pkg == null || !pkg.getName().startsWith("org.jboss.cache");
    }

    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        Fqn fqn = null;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        boolean acquireLock = false;
        Object nodeData = null;
        boolean initNode = false;
        Object key = null;
        InvocationContext ctx = this.getInvocationContext();
        TransactionEntry entry = null;
        GlobalTransaction gtx = null;
        gtx = ctx.getGlobalTransaction();
        if (gtx != null) {
            entry = this.txTable.get(gtx);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("invoke " + (Object)((Object)m)));
        }
        switch (m.getMethodId()) {
            case 1: 
            case 2: {
                fqn = (Fqn)args[1];
                initNode = true;
                break;
            }
            case 3: {
                fqn = (Fqn)args[1];
                if (this.useCacheStore) {
                    initNode = true;
                    break;
                }
                acquireLock = true;
                break;
            }
            case 15: {
                fqn = (Fqn)args[1];
                break;
            }
            case 26: {
                fqn = (Fqn)args[0];
                key = args[1];
                acquireLock = true;
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 31: 
            case 32: {
                fqn = (Fqn)args[0];
                acquireLock = true;
                break;
            }
            case 12: {
                this.cleanupNodesCreated(entry);
                break;
            }
            default: {
                if (this.useCacheStore) break;
                if (m.getMethodId() == 6) {
                    fqn = (Fqn)args[1];
                    break;
                }
                if (m.getMethodId() != 7) break;
                fqn = (Fqn)args[1];
                initNode = true;
            }
        }
        if (fqn != null) {
            DataNode n = this.cache.peek(fqn);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("load element " + fqn + " mustLoad=" + this.mustLoad(n, key)));
            }
            if (this.mustLoad(n, key)) {
                if (initNode) {
                    n = this.createTempNode(fqn, entry);
                }
                if (acquireLock) {
                    this.lock(fqn, 2, false);
                }
                if (!initNode && !this.wasRemovedInTx(fqn)) {
                    n = this.loadNode(fqn, n, entry);
                }
            }
            if (m.getMethodId() == 23) {
                this.loadChildren(fqn, n);
            }
        }
        return super.invoke(m);
    }

    private void loadChildren(Fqn fqn, DataNode n) throws Throwable {
        if (n != null && n.getChildrenLoaded()) {
            return;
        }
        Set children_names = this.loader.getChildrenNames(fqn);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("load children " + fqn + " children=" + children_names));
        }
        if (children_names == null) {
            if (n != null) {
                if (this.useCacheStore) {
                    n.setChildren(null);
                }
                n.setChildrenLoaded(true);
            }
            return;
        }
        if (n == null) {
            n = this.createNodes(fqn, null);
        }
        Iterator i = children_names.iterator();
        while (i.hasNext()) {
            String child_name = (String)i.next();
            Fqn child_fqn = new Fqn(fqn, child_name);
            n.createChild(child_name, child_fqn, n, "jboss:internal:uninitialized", null);
        }
        this.lock(fqn, 1, true);
        n.setChildrenLoaded(true);
    }

    private boolean mustLoad(DataNode n, Object key) {
        return n == null || n.containsKey("jboss:internal:uninitialized") && (key == null || !n.containsKey(key));
    }

    public long getCacheLoaderLoads() {
        return this.m_cacheLoads;
    }

    public long getCacheLoaderMisses() {
        return this.m_cacheMisses;
    }

    public void resetStatistics() {
        this.m_cacheLoads = 0L;
        this.m_cacheMisses = 0L;
    }

    public Map dumpStatistics() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("CacheLoaderLoads", new Long(this.m_cacheLoads));
        retval.put("CacheLoaderMisses", new Long(this.m_cacheMisses));
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(Fqn fqn, int lock_type, boolean recursive) throws Throwable {
        if (this.cache.isNodeLockingOptimistic()) {
            return;
        }
        JBCMethodCall meth = MethodCallFactory.create(MethodDeclarations.lockMethodLocal, new Object[]{fqn, new Integer(lock_type), recursive});
        InvocationContext ctx = this.getInvocationContext();
        Option opt = ctx.getOptionOverrides();
        try {
            ((Interceptor)this.cache.getInterceptors().get(0)).invoke(meth);
        }
        finally {
            if (opt != null) {
                ctx.setOptionOverrides(opt);
            }
        }
    }

    protected DataNode getNode(Fqn fqn) {
        int treeNodeSize = fqn.size();
        TreeNode n = this.cache.getRoot();
        for (int i = 0; i < treeNodeSize && n != null; ++i) {
            Object child_name = fqn.get(i);
            TreeNode child_node = n.getChild(child_name);
            n = child_node;
        }
        return n;
    }

    private boolean wasRemovedInTx(Fqn fqn) {
        GlobalTransaction t = this.getInvocationContext().getGlobalTransaction();
        if (t == null) {
            return false;
        }
        TransactionEntry entry = this.txTable.get(t);
        Iterator i = entry.getCacheLoaderModifications().iterator();
        while (i.hasNext()) {
            JBCMethodCall m = (JBCMethodCall)((Object)i.next());
            if (m.getMethodId() != 5 || !fqn.isChildOrEquals((Fqn)m.getArgs()[1])) continue;
            return true;
        }
        return false;
    }

    private DataNode loadNode(Fqn fqn, DataNode n, TransactionEntry entry) throws Exception {
        Map nodeData;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("loadNode " + fqn));
        }
        if ((nodeData = this.loadData(fqn)) != null) {
            n = this.createNodes(fqn, entry);
            n.put(nodeData, true);
        } else if (n != null && n.containsKey("jboss:internal:uninitialized")) {
            n.remove("jboss:internal:uninitialized");
        }
        return n;
    }

    private DataNode createTempNode(Fqn fqn, TransactionEntry entry) throws Exception {
        DataNode n = this.createNodes(fqn, entry);
        n.put("jboss:internal:uninitialized", null);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("createTempNode n " + n));
        }
        return n;
    }

    private DataNode createNodes(Fqn fqn, TransactionEntry entry) throws Exception {
        Fqn tmp_fqn = Fqn.ROOT;
        int size = fqn.size();
        TreeNode n = this.cache.getRoot();
        for (int i = 0; i < size; ++i) {
            boolean last;
            Object child_name = fqn.get(i);
            tmp_fqn = new Fqn(tmp_fqn, child_name);
            TreeNode child_node = n.getChild(child_name);
            boolean bl = last = i == size - 1;
            if (child_node == null) {
                child_node = last ? n.createChild(child_name, tmp_fqn, n) : n.createChild(child_name, tmp_fqn, n, "jboss:internal:uninitialized", null);
                if (entry != null) {
                    entry.loadUninitialisedNode(tmp_fqn);
                }
            }
            n = child_node;
        }
        return n;
    }

    private void cleanupNodesCreated(TransactionEntry entry) {
        boolean traceEnabled = this.log.isTraceEnabled();
        this.log.trace((Object)"Removing temporarily created nodes from treecache");
        List list = entry.getDummyNodesCreatedByCacheLoader();
        if (list != null && list.size() > 0) {
            ListIterator i = list.listIterator(list.size());
            while (i.hasPrevious()) {
                Fqn fqn = (Fqn)i.previous();
                try {
                    this.cache._evict(fqn);
                }
                catch (CacheException e) {
                    if (!traceEnabled) continue;
                    this.log.trace((Object)("Unable to evict node " + fqn), (Throwable)e);
                }
            }
        }
    }

    private Map loadData(Fqn fqn) throws Exception {
        boolean nodeExists;
        Map nodeData = this.loader.get(fqn);
        boolean bl = nodeExists = nodeData != null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("nodeExists " + nodeExists));
        }
        if (this.cache.getUseInterceptorMbeans() && this.statsEnabled) {
            if (nodeExists) {
                ++this.m_cacheLoads;
            } else {
                ++this.m_cacheMisses;
            }
        }
        if (!nodeExists && this.isCustomCacheLoader) {
            this.warnCustom();
        }
        if (nodeExists) {
            this.cache.notifyNodeLoaded(fqn);
        }
        return nodeData;
    }

    private void warnCustom() {
        this.log.info((Object)"CacheLoader.get(Fqn) returned a null; assuming the node does not exist.");
        this.log.info((Object)"The CacheLoader interface has changed since JBossCache 1.3.x");
        this.log.info((Object)"Please see http://jira.jboss.com/jira/browse/JBCACHE-118");
        this.log.info((Object)"CacheLoader.get() should return an empty Map if the node does exist but doesn't have any attributes.");
    }
}

