/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.OptimisticTransactionEntry;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.interceptors.InvalidationInterceptorMBean;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jgroups.blocks.MethodCall;

public class InvalidationInterceptor
extends BaseRpcInterceptor
implements InvalidationInterceptorMBean {
    private boolean synchronous;
    private long m_invalidations = 0L;
    protected TransactionTable txTable;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.synchronous = cache.getCacheModeInternal() == 5;
        this.txTable = cache.getTransactionTable();
    }

    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        InvocationContext ctx = this.getInvocationContext();
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && optionOverride.isCacheModeLocal() && ctx.getTransaction() == null) {
            return super.invoke(m);
        }
        Transaction tx = ctx.getTransaction();
        Object retval = super.invoke(m);
        Method meth = m.getMethod();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(" + this.cache.getLocalAddress() + ") method call " + (Object)((Object)m)));
        }
        if (MethodDeclarations.isCrudMethod(meth)) {
            if (m.getMethodId() != 4) {
                Fqn fqn;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Is a CRUD method");
                }
                if (!((fqn = this.findFqn(m.getArgs())) == null || tx != null && this.isValid(tx))) {
                    this.invalidateAcrossCluster(fqn, null);
                }
            } else {
                this.log.debug((Object)"Encountered a putFailFast() - is a no op.");
            }
        } else if (tx != null && this.isValid(tx)) {
            switch (m.getMethodId()) {
                case 10: 
                case 18: {
                    this.log.debug((Object)"Entering InvalidationInterceptor's prepare phase");
                    GlobalTransaction gtx = ctx.getGlobalTransaction();
                    TransactionEntry entry = this.txTable.get(gtx);
                    if (entry == null) {
                        throw new IllegalStateException("cannot find transaction entry for " + gtx);
                    }
                    LinkedList modifications = new LinkedList(entry.getModifications());
                    if (modifications.size() > 0) {
                        if (this.containsPutFailFast(modifications)) {
                            this.log.debug((Object)"Modification list contains a putFailFast operation.  Not invalidating.");
                            break;
                        }
                        try {
                            this.invalidateModifications(modifications, this.cache.isNodeLockingOptimistic() ? this.getWorkspace(gtx) : null);
                            break;
                        }
                        catch (Throwable t) {
                            this.log.warn((Object)"Unable to broadcast evicts as a part of the prepare phase.  Rolling back.", t);
                            try {
                                tx.setRollbackOnly();
                            }
                            catch (SystemException se) {
                                throw new RuntimeException("setting tx rollback failed ", se);
                            }
                            if (t instanceof RuntimeException) {
                                throw (RuntimeException)t;
                            }
                            throw new RuntimeException("Unable to broadcast invalidation messages", t);
                        }
                    }
                    this.log.debug((Object)"Nothing to invalidate - no modifications in the transaction.");
                }
            }
        }
        return retval;
    }

    private boolean containsPutFailFast(List l) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            if (((JBCMethodCall)((Object)i.next())).getMethodId() != 4) continue;
            return true;
        }
        return false;
    }

    public long getInvalidations() {
        return this.m_invalidations;
    }

    public void resetStatistics() {
        this.m_invalidations = 0L;
    }

    public Map dumpStatistics() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("Invalidations", new Long(this.m_invalidations));
        return retval;
    }

    protected void invalidateAcrossCluster(Fqn fqn, TransactionWorkspace workspace) throws Throwable {
        JBCMethodCall call;
        if (this.cache.getUseInterceptorMbeans() && this.statsEnabled) {
            ++this.m_invalidations;
        }
        JBCMethodCall jBCMethodCall = call = workspace != null && !workspace.isVersioningImplicit() ? MethodCallFactory.create(MethodDeclarations.evictVersionedNodeMethodLocal, new Object[]{fqn, workspace.getNode(fqn).getVersion()}) : MethodCallFactory.create(MethodDeclarations.evictNodeMethodLocal, new Object[]{fqn});
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cache [" + this.cache.getLocalAddress() + "] replicating " + (Object)((Object)call)));
        }
        this.replicateCall(call, this.synchronous);
    }

    protected void invalidateModifications(List modifications, TransactionWorkspace workspace) throws Throwable {
        Iterator modifiedFqns = this.optimisedIterator(modifications);
        while (modifiedFqns.hasNext()) {
            Fqn fqn = (Fqn)modifiedFqns.next();
            this.invalidateAcrossCluster(fqn, workspace);
        }
    }

    protected TransactionWorkspace getWorkspace(GlobalTransaction gtx) {
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)this.txTable.get(gtx);
        return entry.getTransactionWorkSpace();
    }

    protected Fqn findFqn(Object[] objects) {
        return (Fqn)objects[1];
    }

    protected Iterator optimisedIterator(List list) {
        HashSet<Fqn> fqns = new HashSet<Fqn>();
        Iterator listIter = list.iterator();
        while (listIter.hasNext()) {
            MethodCall mc = (MethodCall)listIter.next();
            if (!MethodDeclarations.isCrudMethod(mc.getMethod())) continue;
            fqns.add(this.findFqn(mc.getArgs()));
        }
        return fqns.iterator();
    }
}

