/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.factory;

import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectLogTransfer {
    protected static Log m_log = LogFactory.getLog(SelectLogTransfer.class);

    public LogTransferInfo getLogTransfer(String transferId) throws CreateException, FinderException, NamingException {
        LogTransferInfo bean = null;
        try {
            LogTransferInfoLocal logTransfer = LogTransferInfoUtil.getLocalHome().findByPrimaryKey(transferId);
            ArrayList<LogTransferFileInfo> logTransferFiles = new ArrayList<LogTransferFileInfo>();
            Collection ct = logTransfer.getLogTransferFileInfo();
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            String facilityPath = repository.getFacilityPath(logTransfer.getFacilityId(), null);
            Iterator itr = ct.iterator();
            LogTransferFileInfoLocal local = null;
            while (itr.hasNext()) {
                local = (LogTransferFileInfoLocal)itr.next();
                LogTransferFileInfo event = new LogTransferFileInfo(transferId, local.getFilePath(), local.getRunInterval().intValue(), local.getExistenceFlg().intValue(), local.getValidFlg().intValue());
                logTransferFiles.add(event);
            }
            bean = new LogTransferInfo(logTransfer.getTransferId(), logTransfer.getDescription(), facilityPath, logTransfer.getFacilityId(), logTransferFiles, logTransfer.getValidFlg().intValue(), logTransfer.getRegDate(), logTransfer.getUpdateDate(), logTransfer.getRegUser(), logTransfer.getUpdateUser());
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{transferId};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("getLogTransfer():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{transferId};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("getLogTransfer():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{transferId};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("getLogTransfer():" + e.getMessage()));
            throw e;
        }
        return bean;
    }

    public ArrayList getLogTransferList() throws CreateException, FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = LogTransferInfoUtil.getLocalHome().findAllOrderByTransferId();
            list = this.collectionToArray(ct);
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            apllog.put("SYS", "005");
            m_log.debug((Object)("getLogTransferList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            apllog.put("SYS", "005");
            m_log.debug((Object)("getLogTransferList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            apllog.put("SYS", "005");
            m_log.debug((Object)("getLogTransferList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    public HashMap<String, ArrayList<LogTransferFileInfo>> getLogTransferFileInfoMap() throws FinderException, NamingException {
        HashMap<String, ArrayList<LogTransferFileInfo>> map = new HashMap<String, ArrayList<LogTransferFileInfo>>();
        try {
            Collection ct = LogTransferInfoUtil.getLocalHome().findAll();
            for (LogTransferInfoLocal logTransfer : ct) {
                ArrayList<LogTransferFileInfo> list = new ArrayList<LogTransferFileInfo>();
                Collection ctFile = logTransfer.getLogTransferFileInfo();
                Iterator itrFile = ctFile.iterator();
                LogTransferFileInfoLocal local = null;
                String transferId = logTransfer.getTransferId();
                while (itrFile.hasNext()) {
                    local = (LogTransferFileInfoLocal)itrFile.next();
                    int validFlg = 0;
                    if (logTransfer.getValidFlg() == 1) {
                        validFlg = local.getValidFlg();
                    }
                    LogTransferFileInfo event = new LogTransferFileInfo(transferId, local.getFilePath(), local.getRunInterval().intValue(), local.getExistenceFlg().intValue(), validFlg);
                    list.add(event);
                }
                map.put(transferId, list);
            }
        }
        catch (FinderException e) {
            m_log.debug((Object)("getLogTransferFileInfoMap():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("getLogTransferFileInfoMap():" + e.getMessage()));
            throw e;
        }
        return map;
    }

    public HashMap<String, ArrayList<String>> getFacilityIdsMap() throws CreateException, FinderException, NamingException {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        try {
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            Collection ct = LogTransferInfoUtil.getLocalHome().findAll();
            for (LogTransferInfoLocal logTransfer : ct) {
                String facilityId = logTransfer.getFacilityId();
                ArrayList facilityIdList = repository.getExecTargetFacilityIdList(facilityId);
                map.put(logTransfer.getTransferId(), facilityIdList);
            }
        }
        catch (CreateException e) {
            m_log.debug((Object)("getFacilityIdsMap():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("getFacilityIdsMap():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("getFacilityIdsMap():" + e.getMessage()));
            throw e;
        }
        return map;
    }

    private ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        ArrayList list = new ArrayList();
        for (LogTransferInfoLocal logTransfer : ct) {
            String facilityPath = repository.getFacilityPath(logTransfer.getFacilityId(), null);
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(logTransfer.getTransferId());
            info.add(logTransfer.getDescription());
            info.add(facilityPath);
            info.add(logTransfer.getValidFlg());
            info.add(logTransfer.getRegUser());
            info.add(logTransfer.getRegDate() == null ? null : new Date(logTransfer.getRegDate().getTime()));
            info.add(logTransfer.getUpdateUser());
            info.add(logTransfer.getUpdateDate() == null ? null : new Date(logTransfer.getUpdateDate().getTime()));
            list.add(info);
        }
        return list;
    }
}

