/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.factory;

import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;
import com.clustercontrol.maintenance.factory.SelectSchedule;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.quartz.SchedulerException;

public class SelectMaintenanceInfo {
    public MaintenanceInfoDataImp getMaintenanceInfo(String maintenanceId) throws FinderException, NamingException, CreateException {
        MaintenanceInfoLocal infoLocal = MaintenanceInfoUtil.getLocalHome().findByPrimaryKey(maintenanceId);
        MaintenanceInfoDataImp info = new MaintenanceInfoDataImp();
        info.setMaintenance_id(infoLocal.getMaintenance_id());
        info.setDescription(infoLocal.getDescription());
        info.setType_id(infoLocal.getType_id());
        info.setKeep_id(infoLocal.getKeep_id());
        info.setCalendar_id(infoLocal.getCalendar_id());
        info.setSchedule_date(infoLocal.getSchedule_date());
        info.setNotifyGroupId(infoLocal.getNotifyGroupId());
        info.setApplication(infoLocal.getApplication());
        info.setValid_flg(infoLocal.getValid_flg());
        info.setRegUser(infoLocal.getRegUser());
        info.setRegDate(infoLocal.getRegDate());
        info.setUpdateUser(infoLocal.getUpdateUser());
        info.setUpdateDate(infoLocal.getUpdateDate());
        NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
        info.setNotifyId(nc.getNotifyRelation(info.getNotifyGroupId()));
        return info;
    }

    public ArrayList getMaintenanceList() throws FinderException, NamingException, CreateException, SchedulerException {
        Collection ct = MaintenanceInfoUtil.getLocalHome().findAllOrderByMaintenanceId();
        ArrayList list = this.collectionToArray(ct);
        return list;
    }

    public ArrayList getMaintenanceListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"maintenance.id", (Locale)locale), -1, 80, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 200, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"maintenance.type", (Locale)locale), -1, 100, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"maintenance.keep", (Locale)locale), -1, 100, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"calendar.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"schedule", (Locale)locale), 7, 100, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"valid", (Locale)locale) + "/" + Messages.getString((String)"invalid", (Locale)locale), 4, 50, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 80, 16384));
        tableDefine.add(9, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 80, 16384));
        tableDefine.add(10, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 80, 16384));
        return tableDefine;
    }

    private ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, NamingException, SchedulerException {
        ArrayList list = new ArrayList();
        for (MaintenanceInfoLocal maintenance : ct) {
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(maintenance.getMaintenance_id());
            info.add(maintenance.getDescription());
            info.add(maintenance.getType_id());
            info.add(maintenance.getKeep_id());
            info.add(maintenance.getCalendar_id());
            SelectSchedule selectSchedule = new SelectSchedule();
            Schedule schedule = (Schedule)selectSchedule.getSchedule(maintenance.getMaintenance_id()).get(5);
            info.add(schedule.getDate().getTime());
            info.add(maintenance.getValid_flg());
            info.add(maintenance.getRegUser());
            info.add(new Date(maintenance.getRegDate().getTime()));
            info.add(maintenance.getUpdateUser());
            info.add(new Date(maintenance.getUpdateDate().getTime()));
            list.add(info);
        }
        return list;
    }
}

