#!/bin/bash

#Copyright (C) since 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

. /opt/hinemos/hinemos.cfg

# check for incorrect use
EXEC_USER=`/usr/bin/whoami`
if [ ${EXEC_USER} != "hinemos" -a ${EXEC_USER} != "root" ]; then
        echo "";
        echo "ERROR  Hinemos Maneger boot at incorrect user ";
        echo "";
        exit 1;
fi

# check on option
if [ $# = 0 ] ;then
    if [ ! -d ${JBOSS_HOME}/server/default ] ;then
        echo "ERROR JBoss is high availability composition."
        exit 1
    fi
fi

for OPTION in "$@"
do
	case $OPTION in
		-a)
			if [ ! -d ${JBOSS_HOME}/server/all ] ;then
				echo "ERROR JBoss is not high availability composition. "
				exit 1
			fi
			;;
		-c)
			. ${HINEMOS_HOME}/sbin/mng/hinemos_clear_jbm.sh
			;;
		*)
			echo "usage"
			echo "jboss_start.sh    : JBoss is started as usual. "
			echo "jboss_start.sh -c : After the JMS message is annulled, JBoss is started. "
			exit 1
			;;
	esac
done


# Start up JBoss
if [ -f ${HINEMOS_JBOSS_PID} ] ; then

        read JBOSS_PID < ${HINEMOS_JBOSS_PID}
        ps -p ${JBOSS_PID} e | grep ${HINEMOS_HOME} > /dev/null && TMP=1
        if [ "$TMP" ] ; then
                echo ""
                echo "======================================================"
                echo "ERROR another jboss may be running."
                echo "pid file (${HINEMOS_JBOSS_PID}) is exist."
                echo "======================================================"
                exit 24
        else
                rm -f ${HINEMOS_JBOSS_PID}
        fi
fi

echo "waiting for jboss to start..."

#Processing is changed according to the argument. 
for OPTION in "$@"
do
	case $OPTION in
		-a)
			ALL_OPTION="-c all"
			;;
		-c)
			echo "After the JMS message is annulled, JBoss is started. "
			rm -rf ${JBOSS_HOME}/server/default/data/hypersonic/*
			;;
		*)
			;;
	esac
done


nohup ${JBOSS_HOME}/bin/run_hinemos.sh ${ALL_OPTION} -b ${IP_ADDRESS} > ${HINEMOS_HOME}/var/log/jboss_stdout.log 2>&1 &

TODAY=`date +%Y-%m-%d`
TIME_COUNT=0

# twiddle.sh実行時にログの出力先を /var/log とするために移動する
cd ${HINEMOS_HOME}/var/log

while [ 1 ];
do
        if [ -f ${HINEMOS_HOME}/var/log/jboss.log ]; then
                LOG_DATE=`tail -1 /opt/hinemos/var/log/jboss.log | gawk -F\  '{ print $1 }'`
                if [ "${TODAY}" = "${LOG_DATE}" ];  then
                RUN_COUNT=`grep -a 'JBoss (MX MicroKernel).*Started' ${HINEMOS_HOME}/var/log/jboss.log | wc -l`
                EXCEPTION_COUNT=`grep -a Exception ${HINEMOS_HOME}/var/log/jboss.log | wc -l`

                while [ 1 ] ;
                do
                        if [ `grep -a 'JBoss (MX MicroKernel).*Started' ${HINEMOS_HOME}/var/log/jboss.log | wc -l` -gt ${RUN_COUNT} ] ; then
                                break;
                        elif [ `grep -a Exception ${HINEMOS_HOME}/var/log/jboss.log | wc -l` -gt ${EXCEPTION_COUNT} ] ; then
                                echo ""
                                echo "Exception occurred. It may not start normally."
                                        echo "Please check ${HINEMOS_HOME}/var/log/jboss.log ."
                                exit 1
                        fi

                        sleep 2

                        TIME_COUNT=$((${TIME_COUNT} + 2))
                        if [ "${TIME_COUNT}" -ge 120 ]; then
                                STATE_STRING=`${JBOSS_HOME}/bin/twiddle.sh -s jnp://${IP_ADDRESS}:1099 get "jboss.system:type=Server" Started`
                                if [ "${STATE_STRING}" = "Started=true" ]; then
                                        break;
                                fi
                        fi

                        echo -n "."
                done

                echo "done"
                break;
                fi

        fi
                sleep 2
                TIME_COUNT=$((${TIME_COUNT} + 2))
                echo -n "."
done

#copy jboss boot.log to /opt/hinemos/var/log/boot.log.XXXX-XX-XX
SDATE=`date +%Y-%m-%d`

if [ -n "${ALL_OPTION}" ] ; then
	cat ${JBOSS_HOME}/server/all/log/boot.log >>${HINEMOS_HOME}/var/log/boot.log.${SDATE}
else
	cat ${JBOSS_HOME}/server/default/log/boot.log >>${HINEMOS_HOME}/var/log/boot.log.${SDATE}
fi

echo "jboss started"
