/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.accesscontrol.util.AccessEndpointWrapper;
import com.clustercontrol.util.Messages;

/**
 * アクセス権限を確認するクライアント側アクションクラス<BR>
 * 
 * ユーザに権限があるか確認します。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class CheckPermission {

	// ログ
	private static Log m_log = LogFactory.getLog( CheckPermission.class );

	/**
	 * ユーザにロールの権限があるかチェックします。
	 * 
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * ログインユーザに指定のRole(権限)があるか判定し結果を返します。
	 * 
	 * @param roleName Role名(権限)
	 * @return 指定のRole(権限)がある場合は true
	 * 
	 */
	public boolean check(String roleName) {

		try {
			return AccessEndpointWrapper.isPermission(roleName);
		} catch (Exception e) {
			m_log.warn("check(), " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}

		return false;
	}
}