/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.calendar.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.calendar.dialog.WeekdayInfoDialog;
import com.clustercontrol.calendar.view.WeekdayInfoListView;

/**
 * カレンダ曜日別情報の作成・変更ダイアログによる、カレンダ曜日別情報の登録を行うクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class WeekdayInfoAddAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.calendar.view.action.WeekdayInfoAddAction";

	private IViewPart viewPart;

	/**
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {
		//カレンダIDを取得
		WeekdayInfoListView view =
			(WeekdayInfoListView)this.viewPart.getAdapter(WeekdayInfoListView.class);
		String calendarId = view.getComposite().getCalendarId();

		if(calendarId != null & calendarId.length() > 0){
			// ダイアログを生成
			WeekdayInfoDialog dialog =
				new WeekdayInfoDialog(this.viewPart.getSite().getShell(), calendarId, null, null, null, PropertyConstant.MODE_ADD);

			// ダイアログにて変更が選択された場合、入力内容をもって登録を行う。
			dialog.open();

			view.update(calendarId);
		}
	}

	/**
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}