/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.action;

import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.util.HistoryFilterPropertyUtil;
import com.clustercontrol.fault.HinemosUnknown;

/**
 * 履歴フィルタ用プロパティ取得するクライアント側アクションクラス<BR>
 * 
 * サーバから履歴フィルタ用プロパティを取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetHistoryFilterProperty {

	// ログ
	private static Log m_log = LogFactory.getLog( GetHistoryFilterProperty.class );

	/**
	 * 履歴フィルタ用プロパティを取得します。<BR>
	 * 
	 * @return 履歴フィルタ用プロパティ
	 * @since 1.0.0
	 */
	public Property getProperty() {

		Property property = null;

		try {
			property = HistoryFilterPropertyUtil.getProperty(Locale.getDefault());
		} catch (HinemosUnknown e) {
			m_log.warn("getProperty(), " + e.getMessage(), e);
		}


		return property;
	}
}