/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.composite.action;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;

import com.clustercontrol.collectiverun.bean.CommandTypeConstant;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ParameterTypeConstant;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.collectiverun.CommandInfo;
import com.clustercontrol.ws.collectiverun.CommandParameterInfo;
import com.clustercontrol.ws.collectiverun.ItemInfo;
import com.clustercontrol.ws.collectiverun.ParameterInfo;
import com.clustercontrol.ws.collectiverun.ParameterSelectInfo;
import com.clustercontrol.ws.collectiverun.TreeItem;
import com.clustercontrol.ws.collectiverun.TypeInfo;

/**
 * 一括制御階層ツリー作成のSelectionListenerクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class CreateTreeItemSelectionListener extends BaseTreeItemSelectionListener {

	/**
	 * コンストラクタ
	 * 
	 * @param composite
	 */
	public CreateTreeItemSelectionListener(TreeComposite composite) {
		super(composite);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	@Override
	public void widgetSelected(SelectionEvent e) {

		//作成中アイテムのチェック
		if(!checkCreateItem())
			return;

		//更新中アイテムのチェック
		if(!checkUpdateItem())
			return;

		TreeItem item = null;
		TreeItem parent = null;

		parent = this.composite.getSelectItem();

		if (parent != null) {
			ItemInfo parentInfo = getInfo(parent);

			int maxOrderNo = TreeItemUtil.getMaxOrderNo(parent);

			ItemInfo info = null;
			item = new TreeItem();
			if(parentInfo.getType() == ItemConstant.TYPE_COMMAND_COMPOSITE){
				info = new TypeInfo();
				info.setType(ItemConstant.TYPE_TYPE);
				item.setTypeInfo((TypeInfo)info);
			} else if(parentInfo.getType() == ItemConstant.TYPE_PARAMETER_COMPOSITE){
				info = new ParameterInfo();
				info.setType(ItemConstant.TYPE_PARAMETER);
				((ParameterInfo)info).setParamType(ParameterTypeConstant.TYPE_STRING);
				item.setParameterInfo((ParameterInfo)info);
			} else if(parentInfo.getType() == ItemConstant.TYPE_TYPE){
				info = new CommandInfo();
				info.setType(ItemConstant.TYPE_COMMAND);
				((CommandInfo)info).setCommandType(CommandTypeConstant.TYPE_COMMAND);
				item.setCommandInfo((CommandInfo)info);
			} else if(parentInfo.getType() == ItemConstant.TYPE_COMMAND){
				info = new CommandParameterInfo();
				info.setType(ItemConstant.TYPE_COMMAND_PARAMETER);
				item.setCommandParameterInfo((CommandParameterInfo)info);
			} else if(parentInfo.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
				return ;
			} else if(parentInfo.getType() == ItemConstant.TYPE_PARAMETER){
				info = new ParameterSelectInfo();
				info.setType(ItemConstant.TYPE_SELECT_ITEM);
				((ParameterSelectInfo)info).setId(((ParameterInfo)parentInfo).getId());
				item.setParameterSelectInfo((ParameterSelectInfo)info);
			} else if(parentInfo.getType() == ItemConstant.TYPE_SELECT_ITEM){
				return ;
			}

			info.setName(Messages.getString("new.creating"));
			info.setOrderNo(maxOrderNo + 1);
			item.setParent(parent);
			TreeItemUtil.addChildren(parent, item);

			this.composite.setCreateItem(item);
			this.composite.getTreeViewer().refresh(parent);
			this.composite.getTreeViewer().setSelection(
					new StructuredSelection(item), true);
		}
	}

	private ItemInfo getInfo(TreeItem item){
		if(item.getCommandInfo() != null){
			return item.getCommandInfo();
		}
		else if(item.getCommandParameterInfo() != null){
			return item.getCommandParameterInfo();
		}
		else if(item.getParameterInfo() != null){
			return item.getParameterInfo();
		}
		else if(item.getParameterSelectInfo() != null){
			return item.getParameterSelectInfo();
		}
		else if(item.getTypeInfo() != null){
			return item.getTypeInfo();
		}
		else{
			return null;
		}
	}
}

